/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.mpt.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsat.common.mpt.MaxPlusSpecification;
import org.eclipse.lsat.common.mpt.api.MaxPlusAlgorithms;
import org.eclipse.lsat.common.mpt.api.MaximumThroughputResult;
import org.eclipse.lsat.mpt.ui.Activator;
import org.eclipse.lsat.mpt.ui.Activity2DispatchingHelper;
import org.eclipse.lsat.mpt.ui.ActivityTransformationOptions;
import org.eclipse.lsat.mpt.xtend.transformation.Mpt2DispatchingMaxThroughput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activity2DispatchingMaxThroughputJob
extends Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activity2DispatchingMaxThroughputJob.class);
    private final UISynchronize sync;
    private final Shell shell;
    private final Activity2DispatchingHelper helper;

    public Activity2DispatchingMaxThroughputJob(ActivityTransformationOptions options, UISynchronize sync, Shell shell) {
        super("Activity2DispatchingMaxThroughputJob");
        this.sync = sync;
        this.shell = shell;
        this.helper = new Activity2DispatchingHelper(options);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            MaxPlusSpecification maxPlusSpecification = this.helper.createMaxPlusSpecification(monitor);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            final MaximumThroughputResult result = MaxPlusAlgorithms.calculateMaximumThroughput((MaxPlusSpecification)maxPlusSpecification);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            LOGGER.info("Maximum throughput: " + result.getThroughput());
            Mpt2DispatchingMaxThroughput mpt2DispatchingMatrix = new Mpt2DispatchingMaxThroughput();
            CharSequence dispatchingContent = mpt2DispatchingMatrix.transformModel(this.helper.getActivitySet(), result);
            this.helper.createDispatchingFile(dispatchingContent);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.worked(50);
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    new Activity2DispatchingHelper.SuccessDialog(Activity2DispatchingMaxThroughputJob.this.shell, "Maximum throughput analysis", "Maximum throughput: " + Activity2DispatchingMaxThroughputJob.this.helper.round(result.getThroughput()) + ".\nResult stored in \"" + Activity2DispatchingMaxThroughputJob.this.helper.getDispatchingFile() + "\".").open();
                }
            });
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.lsat.mpt.ui", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Convert activity specification to dispatching file", (String)("Converting activity specification to dispatching file failed:\n" + e.getMessage() + "\n\nSee Error Log for details."));
                }
            });
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

