package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.ObjectMapperProvider;

/**
 * Immutable implementation of {@link ImageConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableImageConfig.builder()}.
 */
@SuppressWarnings({"all", "deprecation", "removal"})
final class ImmutableImageConfig implements ImageConfig {
  private final @Nullable String hostname;
  private final @Nullable String domainname;
  private final @Nullable String user;
  private final @Nullable Boolean attachStdin;
  private final @Nullable Boolean attachStdout;
  private final @Nullable Boolean attachStderr;
  private final @Nullable List<String> portSpecs;
  private final @Nullable Set<String> exposedPorts;
  private final @Nullable Boolean tty;
  private final @Nullable Boolean openStdin;
  private final @Nullable Boolean stdinOnce;
  private final @Nullable List<String> env;
  private final @Nullable List<String> cmd;
  private final @Nullable String image;
  private final @Nullable Set<String> volumes;
  private final @Nullable String workingDir;
  private final @Nullable List<String> entrypoint;
  private final @Nullable Boolean networkDisabled;
  private final @Nullable List<String> onBuild;
  private final @Nullable Map<String, String> labels;
  private final @Nullable String macAddress;
  private final @Nullable HostConfig hostConfig;
  private final @Nullable String stopSignal;
  private final @Nullable Healthcheck healthcheck;
  private final @Nullable NetworkingConfig networkingConfig;
  private transient final ImageConfig.Builder toBuilder;

  private ImmutableImageConfig(
      @Nullable String hostname,
      @Nullable String domainname,
      @Nullable String user,
      @Nullable Boolean attachStdin,
      @Nullable Boolean attachStdout,
      @Nullable Boolean attachStderr,
      @Nullable List<String> portSpecs,
      @Nullable Set<String> exposedPorts,
      @Nullable Boolean tty,
      @Nullable Boolean openStdin,
      @Nullable Boolean stdinOnce,
      @Nullable List<String> env,
      @Nullable List<String> cmd,
      @Nullable String image,
      @Nullable Set<String> volumes,
      @Nullable String workingDir,
      @Nullable List<String> entrypoint,
      @Nullable Boolean networkDisabled,
      @Nullable List<String> onBuild,
      @Nullable Map<String, String> labels,
      @Nullable String macAddress,
      @Nullable HostConfig hostConfig,
      @Nullable String stopSignal,
      @Nullable Healthcheck healthcheck,
      @Nullable NetworkingConfig networkingConfig) {
    this.hostname = hostname;
    this.domainname = domainname;
    this.user = user;
    this.attachStdin = attachStdin;
    this.attachStdout = attachStdout;
    this.attachStderr = attachStderr;
    this.portSpecs = portSpecs;
    this.exposedPorts = exposedPorts;
    this.tty = tty;
    this.openStdin = openStdin;
    this.stdinOnce = stdinOnce;
    this.env = env;
    this.cmd = cmd;
    this.image = image;
    this.volumes = volumes;
    this.workingDir = workingDir;
    this.entrypoint = entrypoint;
    this.networkDisabled = networkDisabled;
    this.onBuild = onBuild;
    this.labels = labels;
    this.macAddress = macAddress;
    this.hostConfig = hostConfig;
    this.stopSignal = stopSignal;
    this.healthcheck = healthcheck;
    this.networkingConfig = networkingConfig;
    this.toBuilder = Objects.requireNonNull(ImageConfig.super.toBuilder(), "toBuilder");
  }

  /**
   * @return The value of the {@code hostname} attribute
   */
  @JsonProperty("Hostname")
  @Deprecated
  @Override
  public @Nullable String hostname() {
    return hostname;
  }

  /**
   * @return The value of the {@code domainname} attribute
   */
  @JsonProperty("Domainname")
  @Deprecated
  @Override
  public @Nullable String domainname() {
    return domainname;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty("User")
  @Override
  public @Nullable String user() {
    return user;
  }

  /**
   * @return The value of the {@code attachStdin} attribute
   */
  @JsonProperty("AttachStdin")
  @Deprecated
  @Override
  public @Nullable Boolean attachStdin() {
    return attachStdin;
  }

  /**
   * @return The value of the {@code attachStdout} attribute
   */
  @JsonProperty("AttachStdout")
  @Deprecated
  @Override
  public @Nullable Boolean attachStdout() {
    return attachStdout;
  }

  /**
   * @return The value of the {@code attachStderr} attribute
   */
  @JsonProperty("AttachStderr")
  @Deprecated
  @Override
  public @Nullable Boolean attachStderr() {
    return attachStderr;
  }

  /**
   * @return The value of the {@code portSpecs} attribute
   */
  @JsonProperty("PortSpecs")
  @Override
  public @Nullable List<String> portSpecs() {
    return portSpecs;
  }

  /**
   * @return The value of the {@code exposedPorts} attribute
   */
  @JsonProperty("ExposedPorts")
  @JsonSerialize(using = ObjectMapperProvider.SetSerializer.class)
  @JsonDeserialize(using = ObjectMapperProvider.SetDeserializer.class)
  @Override
  public @Nullable Set<String> exposedPorts() {
    return exposedPorts;
  }

  /**
   * @return The value of the {@code tty} attribute
   */
  @JsonProperty("Tty")
  @Deprecated
  @Override
  public @Nullable Boolean tty() {
    return tty;
  }

  /**
   * @return The value of the {@code openStdin} attribute
   */
  @JsonProperty("OpenStdin")
  @Deprecated
  @Override
  public @Nullable Boolean openStdin() {
    return openStdin;
  }

  /**
   * @return The value of the {@code stdinOnce} attribute
   */
  @JsonProperty("StdinOnce")
  @Deprecated
  @Override
  public @Nullable Boolean stdinOnce() {
    return stdinOnce;
  }

  /**
   * @return The value of the {@code env} attribute
   */
  @JsonProperty("Env")
  @Override
  public @Nullable List<String> env() {
    return env;
  }

  /**
   * @return The value of the {@code cmd} attribute
   */
  @JsonProperty("Cmd")
  @Override
  public @Nullable List<String> cmd() {
    return cmd;
  }

  /**
   * @return The value of the {@code image} attribute
   */
  @JsonProperty("Image")
  @Deprecated
  @Override
  public @Nullable String image() {
    return image;
  }

  /**
   * @return The value of the {@code volumes} attribute
   */
  @JsonProperty("Volumes")
  @JsonSerialize(using = ObjectMapperProvider.SetSerializer.class)
  @JsonDeserialize(using = ObjectMapperProvider.SetDeserializer.class)
  @Override
  public @Nullable Set<String> volumes() {
    return volumes;
  }

  /**
   * @return The value of the {@code workingDir} attribute
   */
  @JsonProperty("WorkingDir")
  @Override
  public @Nullable String workingDir() {
    return workingDir;
  }

  /**
   * @return The value of the {@code entrypoint} attribute
   */
  @JsonProperty("Entrypoint")
  @Override
  public @Nullable List<String> entrypoint() {
    return entrypoint;
  }

  /**
   * @return The value of the {@code networkDisabled} attribute
   */
  @JsonProperty("NetworkDisabled")
  @Deprecated
  @Override
  public @Nullable Boolean networkDisabled() {
    return networkDisabled;
  }

  /**
   * @return The value of the {@code onBuild} attribute
   */
  @JsonProperty("OnBuild")
  @Override
  public @Nullable List<String> onBuild() {
    return onBuild;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("Labels")
  @Override
  public @Nullable Map<String, String> labels() {
    return labels;
  }

  /**
   * @return The value of the {@code macAddress} attribute
   */
  @JsonProperty("MacAddress")
  @Deprecated
  @Override
  public @Nullable String macAddress() {
    return macAddress;
  }

  /**
   * @return The value of the {@code hostConfig} attribute
   */
  @JsonProperty("HostConfig")
  @Override
  public @Nullable HostConfig hostConfig() {
    return hostConfig;
  }

  /**
   * @return The value of the {@code stopSignal} attribute
   */
  @JsonProperty("StopSignal")
  @Override
  public @Nullable String stopSignal() {
    return stopSignal;
  }

  /**
   * @return The value of the {@code healthcheck} attribute
   */
  @JsonProperty("Healthcheck")
  @Override
  public @Nullable Healthcheck healthcheck() {
    return healthcheck;
  }

  /**
   * @return The value of the {@code networkingConfig} attribute
   */
  @JsonProperty("NetworkingConfig")
  @Override
  public @Nullable NetworkingConfig networkingConfig() {
    return networkingConfig;
  }

  /**
   * @return The computed-at-construction value of the {@code toBuilder} attribute
   */
  @JsonProperty(value = "toBuilder")
  @JsonIgnore
  @Override
  public ImageConfig.Builder toBuilder() {
    return toBuilder;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#hostname() hostname} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hostname (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withHostname(@Nullable String value) {
    if (Objects.equals(this.hostname, value)) return this;
    return new ImmutableImageConfig(
        value,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#domainname() domainname} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for domainname (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withDomainname(@Nullable String value) {
    if (Objects.equals(this.domainname, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        value,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#user() user} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageConfig withUser(@Nullable String value) {
    if (Objects.equals(this.user, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        value,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#attachStdin() attachStdin} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attachStdin (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withAttachStdin(@Nullable Boolean value) {
    if (Objects.equals(this.attachStdin, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        value,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#attachStdout() attachStdout} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attachStdout (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withAttachStdout(@Nullable Boolean value) {
    if (Objects.equals(this.attachStdout, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        value,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#attachStderr() attachStderr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attachStderr (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withAttachStderr(@Nullable Boolean value) {
    if (Objects.equals(this.attachStderr, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        value,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#portSpecs() portSpecs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableImageConfig withPortSpecs(@Nullable String... elements) {
    if (elements == null) {
      if (this.portSpecs == null) return this;
      return new ImmutableImageConfig(
          this.hostname,
          this.domainname,
          this.user,
          this.attachStdin,
          this.attachStdout,
          this.attachStderr,
          null,
          this.exposedPorts,
          this.tty,
          this.openStdin,
          this.stdinOnce,
          this.env,
          this.cmd,
          this.image,
          this.volumes,
          this.workingDir,
          this.entrypoint,
          this.networkDisabled,
          this.onBuild,
          this.labels,
          this.macAddress,
          this.hostConfig,
          this.stopSignal,
          this.healthcheck,
          this.networkingConfig);
    }
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        newValue,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#portSpecs() portSpecs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of portSpecs elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableImageConfig withPortSpecs(@Nullable Iterable<String> elements) {
    if (this.portSpecs == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        newValue,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#exposedPorts() exposedPorts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableImageConfig withExposedPorts(@Nullable String... elements) {
    if (elements == null) {
      if (this.exposedPorts == null) return this;
      return new ImmutableImageConfig(
          this.hostname,
          this.domainname,
          this.user,
          this.attachStdin,
          this.attachStdout,
          this.attachStderr,
          this.portSpecs,
          null,
          this.tty,
          this.openStdin,
          this.stdinOnce,
          this.env,
          this.cmd,
          this.image,
          this.volumes,
          this.workingDir,
          this.entrypoint,
          this.networkDisabled,
          this.onBuild,
          this.labels,
          this.macAddress,
          this.hostConfig,
          this.stopSignal,
          this.healthcheck,
          this.networkingConfig);
    }
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        newValue,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#exposedPorts() exposedPorts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of exposedPorts elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableImageConfig withExposedPorts(@Nullable Iterable<String> elements) {
    if (this.exposedPorts == elements) return this;
    @Nullable Set<String> newValue = elements == null ? null : createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        newValue,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#tty() tty} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tty (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withTty(@Nullable Boolean value) {
    if (Objects.equals(this.tty, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        value,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#openStdin() openStdin} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for openStdin (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withOpenStdin(@Nullable Boolean value) {
    if (Objects.equals(this.openStdin, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        value,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#stdinOnce() stdinOnce} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stdinOnce (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withStdinOnce(@Nullable Boolean value) {
    if (Objects.equals(this.stdinOnce, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        value,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#env() env}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableImageConfig withEnv(@Nullable String... elements) {
    if (elements == null) {
      if (this.env == null) return this;
      return new ImmutableImageConfig(
          this.hostname,
          this.domainname,
          this.user,
          this.attachStdin,
          this.attachStdout,
          this.attachStderr,
          this.portSpecs,
          this.exposedPorts,
          this.tty,
          this.openStdin,
          this.stdinOnce,
          null,
          this.cmd,
          this.image,
          this.volumes,
          this.workingDir,
          this.entrypoint,
          this.networkDisabled,
          this.onBuild,
          this.labels,
          this.macAddress,
          this.hostConfig,
          this.stopSignal,
          this.healthcheck,
          this.networkingConfig);
    }
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        newValue,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#env() env}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of env elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableImageConfig withEnv(@Nullable Iterable<String> elements) {
    if (this.env == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        newValue,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#cmd() cmd}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableImageConfig withCmd(@Nullable String... elements) {
    if (elements == null) {
      if (this.cmd == null) return this;
      return new ImmutableImageConfig(
          this.hostname,
          this.domainname,
          this.user,
          this.attachStdin,
          this.attachStdout,
          this.attachStderr,
          this.portSpecs,
          this.exposedPorts,
          this.tty,
          this.openStdin,
          this.stdinOnce,
          this.env,
          null,
          this.image,
          this.volumes,
          this.workingDir,
          this.entrypoint,
          this.networkDisabled,
          this.onBuild,
          this.labels,
          this.macAddress,
          this.hostConfig,
          this.stopSignal,
          this.healthcheck,
          this.networkingConfig);
    }
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        newValue,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#cmd() cmd}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of cmd elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableImageConfig withCmd(@Nullable Iterable<String> elements) {
    if (this.cmd == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        newValue,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#image() image} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for image (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withImage(@Nullable String value) {
    if (Objects.equals(this.image, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        value,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#volumes() volumes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableImageConfig withVolumes(@Nullable String... elements) {
    if (elements == null) {
      if (this.volumes == null) return this;
      return new ImmutableImageConfig(
          this.hostname,
          this.domainname,
          this.user,
          this.attachStdin,
          this.attachStdout,
          this.attachStderr,
          this.portSpecs,
          this.exposedPorts,
          this.tty,
          this.openStdin,
          this.stdinOnce,
          this.env,
          this.cmd,
          this.image,
          null,
          this.workingDir,
          this.entrypoint,
          this.networkDisabled,
          this.onBuild,
          this.labels,
          this.macAddress,
          this.hostConfig,
          this.stopSignal,
          this.healthcheck,
          this.networkingConfig);
    }
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        newValue,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#volumes() volumes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of volumes elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableImageConfig withVolumes(@Nullable Iterable<String> elements) {
    if (this.volumes == elements) return this;
    @Nullable Set<String> newValue = elements == null ? null : createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        newValue,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#workingDir() workingDir} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workingDir (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageConfig withWorkingDir(@Nullable String value) {
    if (Objects.equals(this.workingDir, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        value,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#entrypoint() entrypoint}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableImageConfig withEntrypoint(@Nullable String... elements) {
    if (elements == null) {
      if (this.entrypoint == null) return this;
      return new ImmutableImageConfig(
          this.hostname,
          this.domainname,
          this.user,
          this.attachStdin,
          this.attachStdout,
          this.attachStderr,
          this.portSpecs,
          this.exposedPorts,
          this.tty,
          this.openStdin,
          this.stdinOnce,
          this.env,
          this.cmd,
          this.image,
          this.volumes,
          this.workingDir,
          null,
          this.networkDisabled,
          this.onBuild,
          this.labels,
          this.macAddress,
          this.hostConfig,
          this.stopSignal,
          this.healthcheck,
          this.networkingConfig);
    }
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        newValue,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#entrypoint() entrypoint}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entrypoint elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableImageConfig withEntrypoint(@Nullable Iterable<String> elements) {
    if (this.entrypoint == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        newValue,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#networkDisabled() networkDisabled} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for networkDisabled (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withNetworkDisabled(@Nullable Boolean value) {
    if (Objects.equals(this.networkDisabled, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        value,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#onBuild() onBuild}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableImageConfig withOnBuild(@Nullable String... elements) {
    if (elements == null) {
      if (this.onBuild == null) return this;
      return new ImmutableImageConfig(
          this.hostname,
          this.domainname,
          this.user,
          this.attachStdin,
          this.attachStdout,
          this.attachStderr,
          this.portSpecs,
          this.exposedPorts,
          this.tty,
          this.openStdin,
          this.stdinOnce,
          this.env,
          this.cmd,
          this.image,
          this.volumes,
          this.workingDir,
          this.entrypoint,
          this.networkDisabled,
          null,
          this.labels,
          this.macAddress,
          this.hostConfig,
          this.stopSignal,
          this.healthcheck,
          this.networkingConfig);
    }
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        newValue,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ImageConfig#onBuild() onBuild}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of onBuild elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableImageConfig withOnBuild(@Nullable Iterable<String> elements) {
    if (this.onBuild == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        newValue,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by replacing the {@link ImageConfig#labels() labels} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the labels map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableImageConfig withLabels(@Nullable Map<String, ? extends String> entries) {
    if (this.labels == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        newValue,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#macAddress() macAddress} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for macAddress (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageConfig withMacAddress(@Nullable String value) {
    if (Objects.equals(this.macAddress, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        value,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#hostConfig() hostConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hostConfig (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageConfig withHostConfig(@Nullable HostConfig value) {
    if (this.hostConfig == value) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        value,
        this.stopSignal,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#stopSignal() stopSignal} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stopSignal (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageConfig withStopSignal(@Nullable String value) {
    if (Objects.equals(this.stopSignal, value)) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        value,
        this.healthcheck,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#healthcheck() healthcheck} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for healthcheck (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageConfig withHealthcheck(@Nullable Healthcheck value) {
    if (this.healthcheck == value) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        value,
        this.networkingConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageConfig#networkingConfig() networkingConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for networkingConfig (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageConfig withNetworkingConfig(@Nullable NetworkingConfig value) {
    if (this.networkingConfig == value) return this;
    return new ImmutableImageConfig(
        this.hostname,
        this.domainname,
        this.user,
        this.attachStdin,
        this.attachStdout,
        this.attachStderr,
        this.portSpecs,
        this.exposedPorts,
        this.tty,
        this.openStdin,
        this.stdinOnce,
        this.env,
        this.cmd,
        this.image,
        this.volumes,
        this.workingDir,
        this.entrypoint,
        this.networkDisabled,
        this.onBuild,
        this.labels,
        this.macAddress,
        this.hostConfig,
        this.stopSignal,
        this.healthcheck,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableImageConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableImageConfig
        && equalsByValue((ImmutableImageConfig) another);
  }

  private boolean equalsByValue(ImmutableImageConfig another) {
    return Objects.equals(hostname, another.hostname)
        && Objects.equals(domainname, another.domainname)
        && Objects.equals(user, another.user)
        && Objects.equals(attachStdin, another.attachStdin)
        && Objects.equals(attachStdout, another.attachStdout)
        && Objects.equals(attachStderr, another.attachStderr)
        && Objects.equals(portSpecs, another.portSpecs)
        && Objects.equals(exposedPorts, another.exposedPorts)
        && Objects.equals(tty, another.tty)
        && Objects.equals(openStdin, another.openStdin)
        && Objects.equals(stdinOnce, another.stdinOnce)
        && Objects.equals(env, another.env)
        && Objects.equals(cmd, another.cmd)
        && Objects.equals(image, another.image)
        && Objects.equals(volumes, another.volumes)
        && Objects.equals(workingDir, another.workingDir)
        && Objects.equals(entrypoint, another.entrypoint)
        && Objects.equals(networkDisabled, another.networkDisabled)
        && Objects.equals(onBuild, another.onBuild)
        && Objects.equals(labels, another.labels)
        && Objects.equals(macAddress, another.macAddress)
        && Objects.equals(hostConfig, another.hostConfig)
        && Objects.equals(stopSignal, another.stopSignal)
        && Objects.equals(healthcheck, another.healthcheck)
        && Objects.equals(networkingConfig, another.networkingConfig);
  }

  /**
   * Computes a hash code from attributes: {@code hostname}, {@code domainname}, {@code user}, {@code attachStdin}, {@code attachStdout}, {@code attachStderr}, {@code portSpecs}, {@code exposedPorts}, {@code tty}, {@code openStdin}, {@code stdinOnce}, {@code env}, {@code cmd}, {@code image}, {@code volumes}, {@code workingDir}, {@code entrypoint}, {@code networkDisabled}, {@code onBuild}, {@code labels}, {@code macAddress}, {@code hostConfig}, {@code stopSignal}, {@code healthcheck}, {@code networkingConfig}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(hostname);
    h += (h << 5) + Objects.hashCode(domainname);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(attachStdin);
    h += (h << 5) + Objects.hashCode(attachStdout);
    h += (h << 5) + Objects.hashCode(attachStderr);
    h += (h << 5) + Objects.hashCode(portSpecs);
    h += (h << 5) + Objects.hashCode(exposedPorts);
    h += (h << 5) + Objects.hashCode(tty);
    h += (h << 5) + Objects.hashCode(openStdin);
    h += (h << 5) + Objects.hashCode(stdinOnce);
    h += (h << 5) + Objects.hashCode(env);
    h += (h << 5) + Objects.hashCode(cmd);
    h += (h << 5) + Objects.hashCode(image);
    h += (h << 5) + Objects.hashCode(volumes);
    h += (h << 5) + Objects.hashCode(workingDir);
    h += (h << 5) + Objects.hashCode(entrypoint);
    h += (h << 5) + Objects.hashCode(networkDisabled);
    h += (h << 5) + Objects.hashCode(onBuild);
    h += (h << 5) + Objects.hashCode(labels);
    h += (h << 5) + Objects.hashCode(macAddress);
    h += (h << 5) + Objects.hashCode(hostConfig);
    h += (h << 5) + Objects.hashCode(stopSignal);
    h += (h << 5) + Objects.hashCode(healthcheck);
    h += (h << 5) + Objects.hashCode(networkingConfig);
    return h;
  }

  /**
   * Prints the immutable value {@code ImageConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ImageConfig{"
        + "hostname=" + hostname
        + ", domainname=" + domainname
        + ", user=" + user
        + ", attachStdin=" + attachStdin
        + ", attachStdout=" + attachStdout
        + ", attachStderr=" + attachStderr
        + ", portSpecs=" + portSpecs
        + ", exposedPorts=" + exposedPorts
        + ", tty=" + tty
        + ", openStdin=" + openStdin
        + ", stdinOnce=" + stdinOnce
        + ", env=" + env
        + ", cmd=" + cmd
        + ", image=" + image
        + ", volumes=" + volumes
        + ", workingDir=" + workingDir
        + ", entrypoint=" + entrypoint
        + ", networkDisabled=" + networkDisabled
        + ", onBuild=" + onBuild
        + ", labels=" + labels
        + ", macAddress=" + macAddress
        + ", hostConfig=" + hostConfig
        + ", stopSignal=" + stopSignal
        + ", healthcheck=" + healthcheck
        + ", networkingConfig=" + networkingConfig
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ImageConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ImageConfig instance
   */
  public static ImmutableImageConfig copyOf(ImageConfig instance) {
    if (instance instanceof ImmutableImageConfig) {
      return (ImmutableImageConfig) instance;
    }
    return ImmutableImageConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableImageConfig ImmutableImageConfig}.
   * <pre>
   * ImmutableImageConfig.builder()
   *    .hostname(String | null) // nullable {@link ImageConfig#hostname() hostname}
   *    .domainname(String | null) // nullable {@link ImageConfig#domainname() domainname}
   *    .user(String | null) // nullable {@link ImageConfig#user() user}
   *    .attachStdin(Boolean | null) // nullable {@link ImageConfig#attachStdin() attachStdin}
   *    .attachStdout(Boolean | null) // nullable {@link ImageConfig#attachStdout() attachStdout}
   *    .attachStderr(Boolean | null) // nullable {@link ImageConfig#attachStderr() attachStderr}
   *    .portSpecs(List&lt;String&gt; | null) // nullable {@link ImageConfig#portSpecs() portSpecs}
   *    .exposedPorts(Set&lt;String&gt; | null) // nullable {@link ImageConfig#exposedPorts() exposedPorts}
   *    .tty(Boolean | null) // nullable {@link ImageConfig#tty() tty}
   *    .openStdin(Boolean | null) // nullable {@link ImageConfig#openStdin() openStdin}
   *    .stdinOnce(Boolean | null) // nullable {@link ImageConfig#stdinOnce() stdinOnce}
   *    .env(List&lt;String&gt; | null) // nullable {@link ImageConfig#env() env}
   *    .cmd(List&lt;String&gt; | null) // nullable {@link ImageConfig#cmd() cmd}
   *    .image(String | null) // nullable {@link ImageConfig#image() image}
   *    .volumes(Set&lt;String&gt; | null) // nullable {@link ImageConfig#volumes() volumes}
   *    .workingDir(String | null) // nullable {@link ImageConfig#workingDir() workingDir}
   *    .entrypoint(List&lt;String&gt; | null) // nullable {@link ImageConfig#entrypoint() entrypoint}
   *    .networkDisabled(Boolean | null) // nullable {@link ImageConfig#networkDisabled() networkDisabled}
   *    .onBuild(List&lt;String&gt; | null) // nullable {@link ImageConfig#onBuild() onBuild}
   *    .labels(Map&lt;String, String&gt; | null) // nullable {@link ImageConfig#labels() labels}
   *    .macAddress(String | null) // nullable {@link ImageConfig#macAddress() macAddress}
   *    .hostConfig(org.mandas.docker.client.messages.HostConfig | null) // nullable {@link ImageConfig#hostConfig() hostConfig}
   *    .stopSignal(String | null) // nullable {@link ImageConfig#stopSignal() stopSignal}
   *    .healthcheck(org.mandas.docker.client.messages.Healthcheck | null) // nullable {@link ImageConfig#healthcheck() healthcheck}
   *    .networkingConfig(org.mandas.docker.client.messages.NetworkingConfig | null) // nullable {@link ImageConfig#networkingConfig() networkingConfig}
   *    .build();
   * </pre>
   * @return A new ImmutableImageConfig builder
   */
  public static ImmutableImageConfig.Builder builder() {
    return new ImmutableImageConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableImageConfig ImmutableImageConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements ImageConfig.Builder {
    private String hostname;
    private String domainname;
    private String user;
    private Boolean attachStdin;
    private Boolean attachStdout;
    private Boolean attachStderr;
    private List<String> portSpecs = null;
    private List<String> exposedPorts = null;
    private Boolean tty;
    private Boolean openStdin;
    private Boolean stdinOnce;
    private List<String> env = null;
    private List<String> cmd = null;
    private String image;
    private List<String> volumes = null;
    private String workingDir;
    private List<String> entrypoint = null;
    private Boolean networkDisabled;
    private List<String> onBuild = null;
    private Map<String, String> labels = null;
    private String macAddress;
    private HostConfig hostConfig;
    private String stopSignal;
    private Healthcheck healthcheck;
    private NetworkingConfig networkingConfig;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ImageConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ImageConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String hostnameValue = instance.hostname();
      if (hostnameValue != null) {
        hostname(hostnameValue);
      }
      @Nullable String domainnameValue = instance.domainname();
      if (domainnameValue != null) {
        domainname(domainnameValue);
      }
      @Nullable String userValue = instance.user();
      if (userValue != null) {
        user(userValue);
      }
      @Nullable Boolean attachStdinValue = instance.attachStdin();
      if (attachStdinValue != null) {
        attachStdin(attachStdinValue);
      }
      @Nullable Boolean attachStdoutValue = instance.attachStdout();
      if (attachStdoutValue != null) {
        attachStdout(attachStdoutValue);
      }
      @Nullable Boolean attachStderrValue = instance.attachStderr();
      if (attachStderrValue != null) {
        attachStderr(attachStderrValue);
      }
      @Nullable List<String> portSpecsValue = instance.portSpecs();
      if (portSpecsValue != null) {
        addAllPortSpecs(portSpecsValue);
      }
      @Nullable Set<String> exposedPortsValue = instance.exposedPorts();
      if (exposedPortsValue != null) {
        addAllExposedPorts(exposedPortsValue);
      }
      @Nullable Boolean ttyValue = instance.tty();
      if (ttyValue != null) {
        tty(ttyValue);
      }
      @Nullable Boolean openStdinValue = instance.openStdin();
      if (openStdinValue != null) {
        openStdin(openStdinValue);
      }
      @Nullable Boolean stdinOnceValue = instance.stdinOnce();
      if (stdinOnceValue != null) {
        stdinOnce(stdinOnceValue);
      }
      @Nullable List<String> envValue = instance.env();
      if (envValue != null) {
        addAllEnv(envValue);
      }
      @Nullable List<String> cmdValue = instance.cmd();
      if (cmdValue != null) {
        addAllCmd(cmdValue);
      }
      @Nullable String imageValue = instance.image();
      if (imageValue != null) {
        image(imageValue);
      }
      @Nullable Set<String> volumesValue = instance.volumes();
      if (volumesValue != null) {
        addAllVolumes(volumesValue);
      }
      @Nullable String workingDirValue = instance.workingDir();
      if (workingDirValue != null) {
        workingDir(workingDirValue);
      }
      @Nullable List<String> entrypointValue = instance.entrypoint();
      if (entrypointValue != null) {
        addAllEntrypoint(entrypointValue);
      }
      @Nullable Boolean networkDisabledValue = instance.networkDisabled();
      if (networkDisabledValue != null) {
        networkDisabled(networkDisabledValue);
      }
      @Nullable List<String> onBuildValue = instance.onBuild();
      if (onBuildValue != null) {
        addAllOnBuild(onBuildValue);
      }
      @Nullable Map<String, String> labelsValue = instance.labels();
      if (labelsValue != null) {
        putAllLabels(labelsValue);
      }
      @Nullable String macAddressValue = instance.macAddress();
      if (macAddressValue != null) {
        macAddress(macAddressValue);
      }
      @Nullable HostConfig hostConfigValue = instance.hostConfig();
      if (hostConfigValue != null) {
        hostConfig(hostConfigValue);
      }
      @Nullable String stopSignalValue = instance.stopSignal();
      if (stopSignalValue != null) {
        stopSignal(stopSignalValue);
      }
      @Nullable Healthcheck healthcheckValue = instance.healthcheck();
      if (healthcheckValue != null) {
        healthcheck(healthcheckValue);
      }
      @Nullable NetworkingConfig networkingConfigValue = instance.networkingConfig();
      if (networkingConfigValue != null) {
        networkingConfig(networkingConfigValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#hostname() hostname} attribute.
     * @param hostname The value for hostname (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Hostname")
    @Deprecated
    public final Builder hostname(@Nullable String hostname) {
      this.hostname = hostname;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#domainname() domainname} attribute.
     * @param domainname The value for domainname (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Domainname")
    @Deprecated
    public final Builder domainname(@Nullable String domainname) {
      this.domainname = domainname;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#user() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("User")
    public final Builder user(@Nullable String user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#attachStdin() attachStdin} attribute.
     * @param attachStdin The value for attachStdin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("AttachStdin")
    @Deprecated
    public final Builder attachStdin(@Nullable Boolean attachStdin) {
      this.attachStdin = attachStdin;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#attachStdout() attachStdout} attribute.
     * @param attachStdout The value for attachStdout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("AttachStdout")
    @Deprecated
    public final Builder attachStdout(@Nullable Boolean attachStdout) {
      this.attachStdout = attachStdout;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#attachStderr() attachStderr} attribute.
     * @param attachStderr The value for attachStderr (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("AttachStderr")
    @Deprecated
    public final Builder attachStderr(@Nullable Boolean attachStderr) {
      this.attachStderr = attachStderr;
      return this;
    }

    /**
     * Adds one element to {@link ImageConfig#portSpecs() portSpecs} list.
     * @param element A portSpecs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder portSpec(String element) {
      if (this.portSpecs == null) {
        this.portSpecs = new ArrayList<String>();
      }
      this.portSpecs.add(Objects.requireNonNull(element, "portSpecs element"));
      return this;
    }

    /**
     * Adds elements to {@link ImageConfig#portSpecs() portSpecs} list.
     * @param elements An array of portSpecs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder portSpecs(String... elements) {
      if (this.portSpecs == null) {
        this.portSpecs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.portSpecs.add(Objects.requireNonNull(element, "portSpecs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ImageConfig#portSpecs() portSpecs} list.
     * @param elements An iterable of portSpecs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("PortSpecs")
    public final Builder portSpecs(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.portSpecs = null;
        return this;
      }
      this.portSpecs = new ArrayList<String>();
      return addAllPortSpecs(elements);
    }

    /**
     * Adds elements to {@link ImageConfig#portSpecs() portSpecs} list.
     * @param elements An iterable of portSpecs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPortSpecs(Iterable<String> elements) {
      Objects.requireNonNull(elements, "portSpecs element");
      if (this.portSpecs == null) {
        this.portSpecs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.portSpecs.add(Objects.requireNonNull(element, "portSpecs element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ImageConfig#exposedPorts() exposedPorts} set.
     * @param element A exposedPorts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder exposedPort(String element) {
      if (this.exposedPorts == null) {
        this.exposedPorts = new ArrayList<String>();
      }
      this.exposedPorts.add(Objects.requireNonNull(element, "exposedPorts element"));
      return this;
    }

    /**
     * Adds elements to {@link ImageConfig#exposedPorts() exposedPorts} set.
     * @param elements An array of exposedPorts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder exposedPorts(String... elements) {
      if (this.exposedPorts == null) {
        this.exposedPorts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.exposedPorts.add(Objects.requireNonNull(element, "exposedPorts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ImageConfig#exposedPorts() exposedPorts} set.
     * @param elements An iterable of exposedPorts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ExposedPorts")
    @JsonSerialize(using = ObjectMapperProvider.SetSerializer.class)
    @JsonDeserialize(using = ObjectMapperProvider.SetDeserializer.class)
    public final Builder exposedPorts(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.exposedPorts = null;
        return this;
      }
      this.exposedPorts = new ArrayList<String>();
      return addAllExposedPorts(elements);
    }

    /**
     * Adds elements to {@link ImageConfig#exposedPorts() exposedPorts} set.
     * @param elements An iterable of exposedPorts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExposedPorts(Iterable<String> elements) {
      Objects.requireNonNull(elements, "exposedPorts element");
      if (this.exposedPorts == null) {
        this.exposedPorts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.exposedPorts.add(Objects.requireNonNull(element, "exposedPorts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#tty() tty} attribute.
     * @param tty The value for tty (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Tty")
    @Deprecated
    public final Builder tty(@Nullable Boolean tty) {
      this.tty = tty;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#openStdin() openStdin} attribute.
     * @param openStdin The value for openStdin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OpenStdin")
    @Deprecated
    public final Builder openStdin(@Nullable Boolean openStdin) {
      this.openStdin = openStdin;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#stdinOnce() stdinOnce} attribute.
     * @param stdinOnce The value for stdinOnce (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("StdinOnce")
    @Deprecated
    public final Builder stdinOnce(@Nullable Boolean stdinOnce) {
      this.stdinOnce = stdinOnce;
      return this;
    }

    /**
     * Adds one element to {@link ImageConfig#env() env} list.
     * @param element A env element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder env(String element) {
      if (this.env == null) {
        this.env = new ArrayList<String>();
      }
      this.env.add(Objects.requireNonNull(element, "env element"));
      return this;
    }

    /**
     * Adds elements to {@link ImageConfig#env() env} list.
     * @param elements An array of env elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder env(String... elements) {
      if (this.env == null) {
        this.env = new ArrayList<String>();
      }
      for (String element : elements) {
        this.env.add(Objects.requireNonNull(element, "env element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ImageConfig#env() env} list.
     * @param elements An iterable of env elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Env")
    public final Builder env(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.env = null;
        return this;
      }
      this.env = new ArrayList<String>();
      return addAllEnv(elements);
    }

    /**
     * Adds elements to {@link ImageConfig#env() env} list.
     * @param elements An iterable of env elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEnv(Iterable<String> elements) {
      Objects.requireNonNull(elements, "env element");
      if (this.env == null) {
        this.env = new ArrayList<String>();
      }
      for (String element : elements) {
        this.env.add(Objects.requireNonNull(element, "env element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ImageConfig#cmd() cmd} list.
     * @param element A cmd element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cmd(String element) {
      if (this.cmd == null) {
        this.cmd = new ArrayList<String>();
      }
      this.cmd.add(Objects.requireNonNull(element, "cmd element"));
      return this;
    }

    /**
     * Adds elements to {@link ImageConfig#cmd() cmd} list.
     * @param elements An array of cmd elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cmd(String... elements) {
      if (this.cmd == null) {
        this.cmd = new ArrayList<String>();
      }
      for (String element : elements) {
        this.cmd.add(Objects.requireNonNull(element, "cmd element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ImageConfig#cmd() cmd} list.
     * @param elements An iterable of cmd elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Cmd")
    public final Builder cmd(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.cmd = null;
        return this;
      }
      this.cmd = new ArrayList<String>();
      return addAllCmd(elements);
    }

    /**
     * Adds elements to {@link ImageConfig#cmd() cmd} list.
     * @param elements An iterable of cmd elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCmd(Iterable<String> elements) {
      Objects.requireNonNull(elements, "cmd element");
      if (this.cmd == null) {
        this.cmd = new ArrayList<String>();
      }
      for (String element : elements) {
        this.cmd.add(Objects.requireNonNull(element, "cmd element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#image() image} attribute.
     * @param image The value for image (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Image")
    @Deprecated
    public final Builder image(@Nullable String image) {
      this.image = image;
      return this;
    }

    /**
     * Adds one element to {@link ImageConfig#volumes() volumes} set.
     * @param element A volumes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volume(String element) {
      if (this.volumes == null) {
        this.volumes = new ArrayList<String>();
      }
      this.volumes.add(Objects.requireNonNull(element, "volumes element"));
      return this;
    }

    /**
     * Adds elements to {@link ImageConfig#volumes() volumes} set.
     * @param elements An array of volumes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volumes(String... elements) {
      if (this.volumes == null) {
        this.volumes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.volumes.add(Objects.requireNonNull(element, "volumes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ImageConfig#volumes() volumes} set.
     * @param elements An iterable of volumes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Volumes")
    @JsonSerialize(using = ObjectMapperProvider.SetSerializer.class)
    @JsonDeserialize(using = ObjectMapperProvider.SetDeserializer.class)
    public final Builder volumes(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.volumes = null;
        return this;
      }
      this.volumes = new ArrayList<String>();
      return addAllVolumes(elements);
    }

    /**
     * Adds elements to {@link ImageConfig#volumes() volumes} set.
     * @param elements An iterable of volumes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVolumes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "volumes element");
      if (this.volumes == null) {
        this.volumes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.volumes.add(Objects.requireNonNull(element, "volumes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#workingDir() workingDir} attribute.
     * @param workingDir The value for workingDir (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("WorkingDir")
    public final Builder workingDir(@Nullable String workingDir) {
      this.workingDir = workingDir;
      return this;
    }

    /**
     * Adds one element to {@link ImageConfig#entrypoint() entrypoint} list.
     * @param element A entrypoint element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder entrypoint(String element) {
      if (this.entrypoint == null) {
        this.entrypoint = new ArrayList<String>();
      }
      this.entrypoint.add(Objects.requireNonNull(element, "entrypoint element"));
      return this;
    }

    /**
     * Adds elements to {@link ImageConfig#entrypoint() entrypoint} list.
     * @param elements An array of entrypoint elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder entrypoint(String... elements) {
      if (this.entrypoint == null) {
        this.entrypoint = new ArrayList<String>();
      }
      for (String element : elements) {
        this.entrypoint.add(Objects.requireNonNull(element, "entrypoint element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ImageConfig#entrypoint() entrypoint} list.
     * @param elements An iterable of entrypoint elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Entrypoint")
    public final Builder entrypoint(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.entrypoint = null;
        return this;
      }
      this.entrypoint = new ArrayList<String>();
      return addAllEntrypoint(elements);
    }

    /**
     * Adds elements to {@link ImageConfig#entrypoint() entrypoint} list.
     * @param elements An iterable of entrypoint elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEntrypoint(Iterable<String> elements) {
      Objects.requireNonNull(elements, "entrypoint element");
      if (this.entrypoint == null) {
        this.entrypoint = new ArrayList<String>();
      }
      for (String element : elements) {
        this.entrypoint.add(Objects.requireNonNull(element, "entrypoint element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#networkDisabled() networkDisabled} attribute.
     * @param networkDisabled The value for networkDisabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NetworkDisabled")
    @Deprecated
    public final Builder networkDisabled(@Nullable Boolean networkDisabled) {
      this.networkDisabled = networkDisabled;
      return this;
    }

    /**
     * Adds one element to {@link ImageConfig#onBuild() onBuild} list.
     * @param element A onBuild element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder onBuild(String element) {
      if (this.onBuild == null) {
        this.onBuild = new ArrayList<String>();
      }
      this.onBuild.add(Objects.requireNonNull(element, "onBuild element"));
      return this;
    }

    /**
     * Adds elements to {@link ImageConfig#onBuild() onBuild} list.
     * @param elements An array of onBuild elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder onBuild(String... elements) {
      if (this.onBuild == null) {
        this.onBuild = new ArrayList<String>();
      }
      for (String element : elements) {
        this.onBuild.add(Objects.requireNonNull(element, "onBuild element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ImageConfig#onBuild() onBuild} list.
     * @param elements An iterable of onBuild elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OnBuild")
    public final Builder onBuild(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.onBuild = null;
        return this;
      }
      this.onBuild = new ArrayList<String>();
      return addAllOnBuild(elements);
    }

    /**
     * Adds elements to {@link ImageConfig#onBuild() onBuild} list.
     * @param elements An iterable of onBuild elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOnBuild(Iterable<String> elements) {
      Objects.requireNonNull(elements, "onBuild element");
      if (this.onBuild == null) {
        this.onBuild = new ArrayList<String>();
      }
      for (String element : elements) {
        this.onBuild.add(Objects.requireNonNull(element, "onBuild element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link ImageConfig#labels() labels} map.
     * @param key The key in the labels map
     * @param value The associated value in the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabel(String key, String value) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      this.labels.put(
          Objects.requireNonNull(key, "labels key"),
          Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link ImageConfig#labels() labels} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.labels.put(
          Objects.requireNonNull(k, "labels key"),
          Objects.requireNonNull(v, v == null ? "labels value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ImageConfig#labels() labels} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Labels")
    public final Builder labels(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.labels = null;
        return this;
      }
      this.labels = new LinkedHashMap<String, String>();
      return putAllLabels(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ImageConfig#labels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLabels(Map<String, ? extends String> entries) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.labels.put(
            Objects.requireNonNull(k, "labels key"),
            Objects.requireNonNull(v, v == null ? "labels value for key: " + k : null));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#macAddress() macAddress} attribute.
     * @param macAddress The value for macAddress (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MacAddress")
    @Deprecated
    public final Builder macAddress(@Nullable String macAddress) {
      this.macAddress = macAddress;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#hostConfig() hostConfig} attribute.
     * @param hostConfig The value for hostConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HostConfig")
    public final Builder hostConfig(@Nullable HostConfig hostConfig) {
      this.hostConfig = hostConfig;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#stopSignal() stopSignal} attribute.
     * @param stopSignal The value for stopSignal (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("StopSignal")
    public final Builder stopSignal(@Nullable String stopSignal) {
      this.stopSignal = stopSignal;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#healthcheck() healthcheck} attribute.
     * @param healthcheck The value for healthcheck (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Healthcheck")
    public final Builder healthcheck(@Nullable Healthcheck healthcheck) {
      this.healthcheck = healthcheck;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageConfig#networkingConfig() networkingConfig} attribute.
     * @param networkingConfig The value for networkingConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NetworkingConfig")
    public final Builder networkingConfig(@Nullable NetworkingConfig networkingConfig) {
      this.networkingConfig = networkingConfig;
      return this;
    }

    /**
     * Builds a new {@link ImmutableImageConfig ImmutableImageConfig}.
     * @return An immutable instance of ImageConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableImageConfig build() {
      return new ImmutableImageConfig(
          hostname,
          domainname,
          user,
          attachStdin,
          attachStdout,
          attachStderr,
          portSpecs == null ? null : createUnmodifiableList(true, portSpecs),
          exposedPorts == null ? null : createUnmodifiableSet(exposedPorts),
          tty,
          openStdin,
          stdinOnce,
          env == null ? null : createUnmodifiableList(true, env),
          cmd == null ? null : createUnmodifiableList(true, cmd),
          image,
          volumes == null ? null : createUnmodifiableSet(volumes),
          workingDir,
          entrypoint == null ? null : createUnmodifiableList(true, entrypoint),
          networkDisabled,
          onBuild == null ? null : createUnmodifiableList(true, onBuild),
          labels == null ? null : createUnmodifiableMap(false, false, labels),
          macAddress,
          hostConfig,
          stopSignal,
          healthcheck,
          networkingConfig);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size() * 4 / 3 + 1);
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
