/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.utils;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;

public class ThreadPool {
    private static final int MAX_WORKERS = 5;
    private static ThreadPool instance;
    private static int clientsCount;
    public static final int OPTION_AGGRESSIVE = 1;
    public static final int OPTION_NONE = 0;
    private static Constructor tssConstructor;
    private volatile boolean running = true;
    private volatile int workers = 0;
    private volatile int working = 0;
    private volatile int spawned;
    private final int options;
    private List workUnits = new ArrayList();
    private Object lock = new Object();
    private int maxWorkers;
    private Long threadStackSize = new Long(0L);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        clientsCount = 0;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Thread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[4];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.ThreadGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.Runnable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz4;
            classArray[3] = Long.TYPE;
            tssConstructor = clazz.getConstructor(classArray);
        }
        catch (Throwable t) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.tigris.mtoolkit.iagent.internal.utils.ThreadPool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DebugUtils.info(clazz, "VM doesn't support controlling the threads stack size", t);
        }
    }

    public ThreadPool(int maxWorkers, int options) {
        this.maxWorkers = maxWorkers;
        this.options = options;
        String stackSizeOption = System.getProperty("iagent.threads.stackSize");
        if (stackSizeOption != null) {
            try {
                this.threadStackSize = new Long(stackSizeOption);
            }
            catch (NumberFormatException numberFormatException) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("org.tigris.mtoolkit.iagent.internal.utils.ThreadPool");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DebugUtils.error(clazz, "Thread stack option has invalid value: " + this.threadStackSize + ". It will be ignored.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static synchronized ThreadPool getPool() {
        if (instance == null) {
            instance = new ThreadPool(5, 0);
        }
        ++clientsCount;
        return instance;
    }

    public static synchronized void releasePool(ThreadPool pool) {
        if (pool == null) {
            throw new IllegalArgumentException();
        }
        if (instance == pool && --clientsCount == 0) {
            instance.stop();
            instance = null;
        }
    }

    public boolean isEmpty() {
        return this.workUnits.isEmpty() && this.working == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        Object object = this.lock;
        synchronized (object) {
            while ((!this.workUnits.isEmpty() || this.working != 0) && this.running) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(Runnable runnable) {
        if (!this.running) {
            throw new IllegalStateException();
        }
        if (runnable == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.workUnits.add(runnable);
            this.lock.notify();
            boolean isAggressive = (this.options & 1) != 0;
            if (this.workers == (isAggressive ? this.working + this.spawned : this.working) && this.workers < this.maxWorkers) {
                ++this.spawned;
                Worker worker = new Worker();
                Thread th = ThreadPool.createThread(worker, this.threadStackSize);
                worker.start(th);
            }
        }
    }

    private static Thread createThread(Runnable runnable, Long threadStackSize) {
        if (tssConstructor != null) {
            try {
                Object[] objectArray = new Object[4];
                objectArray[1] = runnable;
                objectArray[2] = "Uninitialized mToolkit Worker";
                objectArray[3] = threadStackSize;
                return (Thread)tssConstructor.newInstance(objectArray);
            }
            catch (Throwable t) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("org.tigris.mtoolkit.iagent.internal.utils.ThreadPool");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DebugUtils.error(clazz, "Failed to create thread with specified stack size", t);
            }
        }
        return new Thread(runnable);
    }

    static /* synthetic */ int access$3(ThreadPool threadPool) {
        return threadPool.spawned;
    }

    static /* synthetic */ void access$4(ThreadPool threadPool, int n) {
        threadPool.spawned = n;
    }

    static /* synthetic */ List access$5(ThreadPool threadPool) {
        return threadPool.workUnits;
    }

    static /* synthetic */ boolean access$6(ThreadPool threadPool) {
        return threadPool.running;
    }

    static /* synthetic */ int access$7(ThreadPool threadPool) {
        return threadPool.working;
    }

    static /* synthetic */ void access$8(ThreadPool threadPool, int n) {
        threadPool.working = n;
    }

    private class Worker
    implements Runnable {
        private final int workerId;
        private boolean initialized;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Worker() {
            Object object = ThreadPool.this.lock;
            synchronized (object) {
                ThreadPool threadPool2 = ThreadPool.this;
                int n = threadPool2.workers;
                threadPool2.workers = n + 1;
                this.workerId = n;
            }
        }

        public void start(Thread thread) {
            thread.setName("mToolkit Worker #" + this.workerId);
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                var2_2 = ThreadPool.access$0(ThreadPool.this);
                synchronized (var2_2) {
                    if (!this.initialized) {
                        this.initialized = true;
                        v0 = ThreadPool.this;
                        ThreadPool.access$4(v0, ThreadPool.access$3(v0) - 1);
                    }
                    while (true) {
                        if (!ThreadPool.access$5(ThreadPool.this).isEmpty() || !ThreadPool.access$6(ThreadPool.this)) {
                            if (!ThreadPool.access$5(ThreadPool.this).isEmpty()) break;
                            v1 = ThreadPool.this;
                            ThreadPool.access$2(v1, ThreadPool.access$1(v1) - 1);
                            return;
                        }
                        try {
                            ThreadPool.access$0(ThreadPool.this).wait(1000L);
                        }
                        catch (InterruptedException v2) {}
                    }
                    unit = (Runnable)ThreadPool.access$5(ThreadPool.this).remove(0);
                    v3 = ThreadPool.this;
                    ThreadPool.access$8(v3, ThreadPool.access$7(v3) + 1);
                }
                try {
                    try {
                        unit.run();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable var4_6) {
                    var3_4 = null;
                    var5_5 = ThreadPool.access$0(ThreadPool.this);
                    synchronized (var5_5) {
                        ThreadPool.access$0(ThreadPool.this).notifyAll();
                        v5 = ThreadPool.this;
                        ThreadPool.access$8(v5, ThreadPool.access$7(v5) - 1);
                        throw var4_6;
                    }
                }
                {
                    var3_4 = null;
                }
                var5_5 = ThreadPool.access$0(ThreadPool.this);
                synchronized (var5_5) {
                    ** try [egrp 4[TRYBLOCK] [7 : 186->215)] { 
lbl49:
                    // 1 sources

                    ThreadPool.access$0(ThreadPool.this).notifyAll();
                    v7 = ThreadPool.this;
                    ThreadPool.access$8(v7, ThreadPool.access$7(v7) - 1);
                }
            }
lbl-1000:
            // 1 sources

            {
                catch (Throwable v8) {
                    throw v8;
                }
            }
        }
    }
}

