/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.service.listing.provider.dto;

import java.util.Objects;
import java.util.Set;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;

public class InterfaceNamesDTO {
    private final Set<String> interfaceNames;

    public InterfaceNamesDTO(Set<String> interfaceNames) {
        this.interfaceNames = interfaceNames;
    }

    public void validate() throws KuraException {
        if (this.interfaceNames == null) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{"interfaceNames cannot be null"});
        }
        if (this.interfaceNames.isEmpty()) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{"interfaceNames cannot be empty"});
        }
        if (this.interfaceNames.stream().anyMatch(Objects::isNull)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{"interfaceNames elements cannot be null"});
        }
        if (this.interfaceNames.stream().anyMatch(i -> i.trim().isEmpty())) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{"interfaceNames elements cannot be empty"});
        }
    }

    public Set<String> getInterfacesIds() {
        return this.interfaceNames;
    }
}

