/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.position;

import java.util.HashMap;
import java.util.Map;

public enum GNSSType {
    UNKNOWN("Unknown"),
    OTHER("Other"),
    BEIDOU("Beidou"),
    GALILEO("Galileo"),
    GLONASS("Glonass"),
    GPS("Gps"),
    IRNSS("IRNSS"),
    QZSS("QZSS");

    private String value;
    private static Map<String, GNSSType> valuesMap;

    static {
        valuesMap = new HashMap<String, GNSSType>();
        GNSSType[] gNSSTypeArray = GNSSType.values();
        int n = gNSSTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GNSSType type = gNSSTypeArray[n2];
            valuesMap.put(type.getValue(), type);
            ++n2;
        }
    }

    private GNSSType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static GNSSType fromValue(String value) {
        return valuesMap.get(value);
    }
}

