/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.drivers.assets;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.SelectionCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.kura.web.client.configuration.Configurations;
import org.eclipse.kura.web.client.configuration.HasConfiguration;
import org.eclipse.kura.web.client.ui.AbstractServicesUi;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetModel;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetModelImpl;
import org.eclipse.kura.web.client.ui.drivers.assets.BooleanInputCell;
import org.eclipse.kura.web.client.ui.drivers.assets.DriversAndAssetsRPC;
import org.eclipse.kura.web.client.ui.wires.ValidationData;
import org.eclipse.kura.web.client.ui.wires.ValidationInputCell;
import org.eclipse.kura.web.client.util.DownloadHelper;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.request.RequestContext;
import org.eclipse.kura.web.client.util.request.RequestQueue;
import org.eclipse.kura.web.shared.AssetConstants;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtComponentService;
import org.eclipse.kura.web.shared.service.GwtComponentServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.FieldSet;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.gwtbootstrap3.client.ui.html.Strong;

public class AssetConfigurationUi
extends AbstractServicesUi
implements HasConfiguration {
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtComponentServiceAsync gwtComponentService = (GwtComponentServiceAsync)GWT.create(GwtComponentService.class);
    @UiField
    Button btnAdd;
    @UiField
    Button btnRemove;
    @UiField
    Button btnDownload;
    @UiField
    Button btnUpload;
    @UiField
    SimplePager channelPager;
    @UiField
    Panel channelPanel;
    @UiField
    CellTable<AssetModel.ChannelModel> channelTable;
    @UiField
    Strong channelTitle;
    @UiField
    FieldSet fields;
    @UiField
    Modal newChannelModal;
    @UiField
    FormLabel newChannelNameLabel;
    @UiField
    FormLabel newChannelNameError;
    @UiField
    TextBox newChannelNameInput;
    @UiField
    Button btnCreateNewChannel;
    @UiField
    Button btnCancelCreatingNewChannel;
    @UiField
    Modal uploadModal;
    @UiField
    FormPanel uploadForm;
    @UiField
    Button uploadCancel;
    @UiField
    Button uploadUpload;
    @UiField
    FileUpload filePath;
    @UiField
    CheckBox appendCheck;
    @UiField
    Hidden xsrfTokenField;
    @UiField
    Hidden assetPidField;
    @UiField
    Hidden driverPidField;
    @UiField
    Hidden appendCheckField;
    private static final String INVALID_CLASS_NAME = "error-text-box";
    private static final int MAXIMUM_PAGE_SIZE = 5;
    private static AssetConfigurationUiBinder uiBinder = (AssetConfigurationUiBinder)GWT.create(AssetConfigurationUiBinder.class);
    private final ListDataProvider<AssetModel.ChannelModel> channelsDataProvider = new ListDataProvider();
    private final SingleSelectionModel<AssetModel.ChannelModel> selectionModel = new SingleSelectionModel();
    private static final String SERVLET_URL = "/" + GWT.getModuleName() + "/file/asset";
    private final Set<String> nonValidatedCells;
    private boolean dirty;
    private AssetModel model;
    private final Widget associatedView;
    private final Configurations configurations;
    private HasConfiguration.Listener listener;

    public AssetConfigurationUi(AssetModel assetModel, Widget associatedView, Configurations configurations) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.model = assetModel;
        this.configurations = configurations;
        this.fields.clear();
        this.channelPager.setPageSize(5);
        this.channelPager.setDisplay(this.channelTable);
        this.channelTable.setSelectionModel(this.selectionModel);
        this.channelsDataProvider.addDataDisplay(this.channelTable);
        this.channelPanel.setVisible(false);
        this.btnRemove.setEnabled(false);
        this.associatedView = associatedView;
        this.nonValidatedCells = new HashSet<String>();
        this.btnDownload.setEnabled(true);
        this.btnDownload.addClickHandler(event -> RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(this::downloadChannels))));
        this.btnUpload.addClickHandler(event -> this.uploadAndApply());
        this.uploadUpload.addClickHandler(event -> RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> {
            this.xsrfTokenField.setValue(token.getToken());
            this.assetPidField.setValue(this.model.getAssetPid());
            this.driverPidField.setValue(this.model.getConfiguration().getParameterValue(AssetConstants.ASSET_DRIVER_PROP.value()));
            this.appendCheckField.setValue(this.appendCheck.getValue().toString());
            this.uploadForm.submit();
            this.uploadModal.hide();
        }))));
        this.uploadCancel.addClickHandler(event -> this.uploadModal.hide());
        this.btnAdd.addClickHandler(event -> {
            this.newChannelNameInput.setText(this.getNewChannelName());
            this.newChannelModal.show();
        });
        this.selectionModel.addSelectionChangeHandler(event -> this.btnRemove.setEnabled(this.selectionModel.getSelectedObject() != null));
        this.uploadForm.addSubmitCompleteHandler(event -> {
            String htmlResponse = event.getResults();
            if (htmlResponse == null || htmlResponse.isEmpty()) {
                RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> RequestQueue.submit(context1 -> this.getConfiguration((GwtXSRFToken)token, context1)))));
            } else {
                EntryClassUi.hideWaitModal();
                logger.log(Level.SEVERE, String.valueOf(MSGS.information()) + ": " + MSGS.fileUploadFailure());
                FailureHandler.handle(new Exception(htmlResponse));
            }
        });
        this.setModel(assetModel);
        this.initNewChannelModal();
    }

    private void getConfiguration(GwtXSRFToken token, RequestContext context) {
        this.gwtComponentService.findFilteredComponentConfiguration(token, this.model.getAssetPid(), context.callback(result -> {
            GwtConfigComponent newConfiguration = (GwtConfigComponent)result.get(0);
            DriversAndAssetsRPC.loadStaticInfo(result1 -> {
                this.model = new AssetModelImpl(newConfiguration, this.configurations.getChannelDescriptor(this.model.getConfiguration().getParameterValue(AssetConstants.ASSET_DRIVER_PROP.value())), this.configurations.getBaseChannelDescriptor());
                EntryClassUi.hideWaitModal();
                this.renderForm();
            });
        }));
    }

    public void setModel(AssetModel model) {
        this.model = model;
        this.channelTitle.setText(MSGS.channelTableTitle(model.getConfiguration().getParameterValue(AssetConstants.ASSET_DRIVER_PROP.value())));
        this.renderForm();
        this.channelTable.redraw();
        this.setDirty(false);
    }

    @Override
    public void renderForm() {
        this.fields.clear();
        GwtConfigComponent nonChannelFields = new GwtConfigComponent();
        for (GwtConfigParameter param : this.model.getConfiguration().getParameters()) {
            String[] tokens = param.getId().split(AssetConstants.CHANNEL_PROPERTY_SEPARATOR.value());
            boolean isChannelData = tokens.length == 2;
            boolean isDriverField = param.getId().equals(AssetConstants.ASSET_DRIVER_PROP.value());
            if (isChannelData || isDriverField) continue;
            nonChannelFields.getParameters().add(param);
            if (param.getCardinality() == 0 || param.getCardinality() == 1 || param.getCardinality() == -1) {
                FormGroup formGroup = new FormGroup();
                this.renderConfigParameter(param, true, formGroup);
                continue;
            }
            this.renderMultiFieldConfigParameter(param);
        }
        this.configurableComponent = nonChannelFields;
        this.initTable();
    }

    private void initTable() {
        int columnCount = this.channelTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            this.channelTable.removeColumn(0);
            ++i;
        }
        for (GwtConfigParameter param : this.model.getChannelDescriptor().getParameters()) {
            this.channelTable.addColumn(this.getColumnFromParam(param, param.getId().equals(AssetConstants.NAME.value())), (Header)new TextHeader(param.getName()));
        }
        this.channelsDataProvider.setList(this.model.getChannels());
        this.channelsDataProvider.refresh();
        this.channelPanel.setVisible(true);
    }

    @Override
    public void setDirty(boolean flag) {
        boolean isDirtyStateChanged = flag ^ this.dirty;
        this.dirty = flag;
        this.btnDownload.setEnabled(!this.dirty);
        if (this.listener != null) {
            if (isDirtyStateChanged) {
                this.listener.onDirtyStateChanged(this);
            }
            if (this.isValid()) {
                this.listener.onConfigurationChanged(this);
            }
        }
    }

    @Override
    protected void renderBooleanField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderBooleanField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderChoiceField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderChoiceField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderPasswordField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderPasswordField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderTextField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderTextField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void reset() {
    }

    private Column<AssetModel.ChannelModel, String> getColumnFromParam(GwtConfigParameter param, boolean isReadOnly) {
        Map<String, String> options = param.getOptions();
        if (options != null && options.size() > 0) {
            return this.getSelectionInputColumn(param, isReadOnly);
        }
        return this.getInputCellColumn(param, isReadOnly);
    }

    private Column<AssetModel.ChannelModel, String> getInputCellColumn(final GwtConfigParameter param, boolean isReadOnly) {
        final String id = param.getId();
        Object cell = isReadOnly ? new TextCell() : (param.getType() == GwtConfigParameter.GwtConfigParameterType.BOOLEAN ? new BooleanInputCell() : new ValidationInputCell());
        Column<AssetModel.ChannelModel, String> result = new Column<AssetModel.ChannelModel, String>((Cell)cell){

            public String getValue(AssetModel.ChannelModel object) {
                String result = object.getValue(id);
                if (result != null) {
                    return result;
                }
                return param.isRequired() ? param.getDefault() : null;
            }
        };
        if (!isReadOnly) {
            result.setFieldUpdater((arg_0, arg_1, arg_2) -> this.lambda$16(param, (AbstractCell)cell, arg_0, arg_1, arg_2));
        }
        if (param.getType() == GwtConfigParameter.GwtConfigParameterType.BOOLEAN) {
            result.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
        }
        return result;
    }

    private Column<AssetModel.ChannelModel, String> getSelectionInputColumn(final GwtConfigParameter param, boolean isReadOnly) {
        final String id = param.getId();
        final Map<String, String> labelsToValues = param.getOptions();
        ArrayList<Map.Entry<String, String>> sortedLabelsToValues = new ArrayList<Map.Entry<String, String>>(labelsToValues.entrySet());
        Collections.sort(sortedLabelsToValues, DROPDOWN_LABEL_COMPARATOR);
        final ArrayList<String> labels = new ArrayList<String>();
        final HashMap<String, String> valuesToLabels = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : sortedLabelsToValues) {
            labels.add(entry.getKey());
            valuesToLabels.put(entry.getValue(), entry.getKey());
        }
        SelectionCell cell = new SelectionCell(new ArrayList(labels));
        Column<AssetModel.ChannelModel, String> result = new Column<AssetModel.ChannelModel, String>((Cell)cell){

            public String getValue(AssetModel.ChannelModel object) {
                String result = object.getValue(id);
                if (result == null) {
                    String defaultValue = param.getDefault();
                    result = defaultValue != null ? defaultValue : (String)labelsToValues.get(labels.get(0));
                    object.setValue(id, result);
                }
                return (String)valuesToLabels.get(result);
            }
        };
        if (!isReadOnly) {
            result.setFieldUpdater((index, object, label) -> {
                this.setDirty(true);
                object.setValue(param.getId(), (String)labelsToValues.get(label));
                this.channelTable.redraw();
            });
        }
        return result;
    }

    private void initNewChannelModal() {
        this.newChannelModal.setTitle(MSGS.wiresCreateNewChannel());
        this.newChannelNameLabel.setText(MSGS.wiresCreateNewChannelName());
        this.btnCreateNewChannel.setText(MSGS.addButton());
        this.btnCancelCreatingNewChannel.setText(MSGS.cancelButton());
        this.newChannelNameInput.addKeyUpHandler(event -> {
            ValidationData isChannelNameValid = this.validateChannelName(this.newChannelNameInput.getValue().trim());
            if (isChannelNameValid.isInvalid()) {
                this.newChannelNameInput.addStyleName(INVALID_CLASS_NAME);
                this.newChannelNameError.setText(isChannelNameValid.getValue());
                return;
            }
            this.newChannelNameError.setText("");
            this.newChannelNameInput.removeStyleName(INVALID_CLASS_NAME);
        });
        this.btnCreateNewChannel.addClickHandler(event -> {
            String newChannelName = this.newChannelNameInput.getValue().trim();
            ValidationData isChannelNameValid = this.validateChannelName(newChannelName);
            if (isChannelNameValid.isInvalid()) {
                return;
            }
            this.model.createNewChannel(newChannelName);
            this.channelsDataProvider.setList(this.model.getChannels());
            this.channelsDataProvider.refresh();
            this.channelPager.lastPage();
            this.setDirty(true);
            this.newChannelModal.hide();
        });
        this.btnRemove.addClickHandler(event -> {
            AssetModel.ChannelModel ci = (AssetModel.ChannelModel)this.selectionModel.getSelectedObject();
            this.model.deleteChannel(ci.getChannelName());
            this.channelsDataProvider.setList(this.model.getChannels());
            this.channelsDataProvider.refresh();
            this.btnRemove.setEnabled(false);
            this.setDirty(true);
        });
    }

    private ValidationData validateChannelName(String channelName) {
        ValidationData result = new ValidationData();
        if (channelName.isEmpty()) {
            result.setInvalid(true);
            result.setValue(MSGS.wiresChannelNameEmpty());
            return result;
        }
        String prohibitedChars = AssetConstants.CHANNEL_NAME_PROHIBITED_CHARS.value();
        int i = 0;
        while (i < prohibitedChars.length()) {
            char prohibitedChar = prohibitedChars.charAt(i);
            if (channelName.indexOf(prohibitedChar) != -1) {
                result.setInvalid(true);
                result.setValue(String.valueOf(MSGS.wiresChannelNameInvalidCharacters()) + " '" + prohibitedChar + '\'');
                return result;
            }
            ++i;
        }
        if (channelName.indexOf(32) != -1) {
            result.setInvalid(true);
            result.setValue(MSGS.wiresChannelNameNoSpaces());
            return result;
        }
        if (this.model.getChannelNames().contains(channelName)) {
            result.setInvalid(true);
            result.setValue(MSGS.wiresChannelNameAlreadyPresent());
            return result;
        }
        result.setInvalid(false);
        return result;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private String getNewChannelName() {
        String result;
        block3: {
            int suffix;
            block2: {
                suffix = 1;
                result = null;
                if (!true) break block2;
                result = String.valueOf(MSGS.wiresChannel()) + suffix;
                if (!this.model.getChannelNames().contains(result)) break block3;
            }
            do {
                ++suffix;
                result = String.valueOf(MSGS.wiresChannel()) + suffix;
            } while (this.model.getChannelNames().contains(result));
        }
        return result;
    }

    @Override
    public void setListener(HasConfiguration.Listener listener) {
        this.listener = listener;
        listener.onConfigurationChanged(this);
    }

    public Widget getAssociatedView() {
        return this.associatedView;
    }

    protected void updateNonChannelFields() {
        for (Widget w : this.fields) {
            if (!(w instanceof FormGroup)) continue;
            FormGroup fg = (FormGroup)w;
            this.fillUpdatedConfiguration(fg);
        }
    }

    @Override
    public GwtConfigComponent getConfiguration() {
        this.updateNonChannelFields();
        return this.model.getConfiguration();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isValid() {
        return this.nonValidatedCells.isEmpty() && super.isValid();
    }

    @Override
    public void clearDirtyState() {
        this.dirty = false;
        this.btnDownload.setEnabled(true);
    }

    @Override
    public void markAsDirty() {
        this.setDirty(true);
    }

    private void downloadChannels(GwtXSRFToken token) {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append("/assetsUpDownload?assetPid=").append(this.model.getAssetPid()).append("&driverPid=").append(this.model.getConfiguration().getParameterValue(AssetConstants.ASSET_DRIVER_PROP.value()));
        DownloadHelper.instance().startDownload(token, sbUrl.toString());
    }

    private void uploadAndApply() {
        this.uploadModal.show();
        this.uploadModal.setTitle(MSGS.upload());
        this.uploadForm.setEncoding("multipart/form-data");
        this.uploadForm.setMethod("post");
        this.uploadForm.setAction(SERVLET_URL);
        this.filePath.setName("uploadedFile");
        this.xsrfTokenField.setID("xsrfToken");
        this.xsrfTokenField.setName("xsrfToken");
        this.xsrfTokenField.setValue("");
        this.assetPidField.setID("assetPid");
        this.assetPidField.setName("assetPid");
        this.assetPidField.setValue("");
        this.driverPidField.setID("driverPid");
        this.driverPidField.setName("driverPid");
        this.driverPidField.setValue("");
        this.appendCheck.setName("appendCheck");
        this.appendCheck.setValue(Boolean.valueOf(false));
        this.appendCheckField.setID("doReplace");
        this.appendCheckField.setName("doReplace");
        this.appendCheckField.setValue("");
    }

    private /* synthetic */ void lambda$16(GwtConfigParameter gwtConfigParameter, AbstractCell abstractCell, int index, AssetModel.ChannelModel object, String value) {
        if (!this.isValid(gwtConfigParameter, value)) {
            ValidationData viewData = (ValidationData)((ValidationInputCell)abstractCell).getViewData(object);
            viewData.setInvalid(true);
            this.nonValidatedCells.add(object.getChannelName());
            this.channelTable.redraw();
            return;
        }
        this.nonValidatedCells.remove(object.getChannelName());
        this.setDirty(true);
        this.channelTable.redraw();
        object.setValue(gwtConfigParameter.getId(), value);
    }

    static interface AssetConfigurationUiBinder
    extends UiBinder<Widget, AssetConfigurationUi> {
    }
}

