/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.mbsa;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tigris.mtoolkit.iagent.internal.mbsa.DataFormater;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.mbsa.MBSAClient;
import org.tigris.mtoolkit.iagent.mbsa.MBSACommand;
import org.tigris.mtoolkit.iagent.mbsa.MBSAException;
import org.tigris.mtoolkit.iagent.mbsa.MBSAResult;

public class MBSAClientImpl
implements MBSAClient {
    private static final byte SUPPORTED_VERSION = 2;
    private InputStream input;
    private OutputStream output;
    private byte protocolVersion = 1;
    private int msgId = 1;

    public MBSAClientImpl(InputStream input, OutputStream output) throws MBSAException {
        this.input = input;
        this.output = output;
        this.pingWithVersion();
    }

    public void close() {
        try {
            this.input.close();
        }
        catch (IOException iOException) {}
        try {
            this.output.close();
        }
        catch (IOException iOException) {}
    }

    private void pingWithVersion() throws MBSAException {
        this.debug("[pingWithVersion] Sending an extended ping command");
        MBSACommand cmd = new MBSACommand(0x12121212);
        cmd.writeByte((byte)2);
        cmd.done();
        try {
            MBSAResult result = this.send(cmd);
            if (result.getStatus() == 0 && result.available() > 0) {
                this.protocolVersion = result.readByte();
                this.debug("[pingWithVersion] Remote peer supports protocol " + this.protocolVersion);
            }
        }
        catch (IOException e) {
            this.close();
            this.info("[pingWithVersion] Failed to do the initial handshake", e);
            throw new MBSAException(301, "MBSA session initial handshake failed", e);
        }
    }

    public MBSAResult send(MBSACommand command) throws MBSAException {
        this.debug("[send] >>> " + command);
        try {
            return this.sendAndReceive(command);
        }
        catch (IOException e) {
            this.close();
            throw new MBSAException(302, "Command execution failed", e);
        }
        catch (MBSAException e) {
            if (e.getCode() == 302) {
                this.close();
            }
            throw e;
        }
    }

    private MBSAResult sendAndReceive(MBSACommand command) throws IOException, MBSAException {
        int msgId = this.nextMessageId();
        this.sendCmd(command, this.output, msgId);
        MBSAResult result = this.readResult(this.input);
        this.validateResult(result, msgId);
        return result;
    }

    private void validateResult(MBSAResult req, int msgId) throws MBSAException {
        this.debug("[matchResult] >>> msgId: " + msgId + "; req: " + req + "; version: " + this.protocolVersion);
        switch (this.protocolVersion) {
            case 1: {
                if (req.getId() == msgId) break;
            }
            default: {
                if ((req.getId() & Integer.MAX_VALUE) != msgId) {
                    throw new MBSAException(302, "Protocol error: received response is not expected");
                }
                if ((req.getId() & Integer.MIN_VALUE) != 0) break;
                throw new MBSAException(302, "Protocol error: expected response but received command");
            }
        }
    }

    private void sendCmd(MBSACommand cmd, OutputStream os, int msgId) throws IOException {
        cmd.validate();
        this.debug("[sendCmd] Send command msgId: " + msgId + " >>> " + cmd);
        DataFormater.writeInt(os, msgId);
        cmd.writeTo(os);
        os.flush();
    }

    private MBSAResult readResult(InputStream is) throws IOException {
        this.debug("[readResult] >>> is: " + is);
        int msgId = DataFormater.readInt(is);
        int cmdId = DataFormater.readInt(is);
        int cmdLength = DataFormater.readInt(is);
        byte[] data = new byte[cmdLength];
        int readed = is.read(data);
        while (readed < cmdLength) {
            readed += is.read(data, readed, cmdLength - readed);
        }
        MBSAResult result = new MBSAResult(msgId, cmdId, data);
        this.debug("[readResult] <<< " + result);
        return result;
    }

    private synchronized int nextMessageId() {
        return this.msgId++;
    }

    private final void debug(String message) {
        DebugUtils.debug(this, message);
    }

    private final void info(String message, Throwable t) {
        DebugUtils.info(this, message, t);
    }
}

