/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.net.wifi.WifiAccessPoint;
import org.eclipse.kura.net.wifi.WifiMode;
import org.eclipse.kura.net.wifi.WifiSecurity;

public class WifiAccessPointImpl
implements WifiAccessPoint {
    private final String ssid;
    private byte[] hardwareAddress;
    private long frequency;
    private WifiMode mode;
    private List<Long> bitrate;
    private int strength;
    private EnumSet<WifiSecurity> wpaSecurity;
    private EnumSet<WifiSecurity> rsnSecurity;
    private List<String> capabilities;

    public WifiAccessPointImpl(String ssid) {
        this.ssid = ssid;
    }

    public String getSSID() {
        return this.ssid;
    }

    public byte[] getHardwareAddress() {
        return this.hardwareAddress;
    }

    public void setHardwareAddress(byte[] hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public WifiMode getMode() {
        return this.mode;
    }

    public void setMode(WifiMode mode) {
        this.mode = mode;
    }

    public List<Long> getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(List<Long> bitrate) {
        this.bitrate = bitrate;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public EnumSet<WifiSecurity> getWpaSecurity() {
        return this.wpaSecurity;
    }

    public void setWpaSecurity(EnumSet<WifiSecurity> wpaSecurity) {
        this.wpaSecurity = wpaSecurity;
    }

    public EnumSet<WifiSecurity> getRsnSecurity() {
        return this.rsnSecurity;
    }

    public void setRsnSecurity(EnumSet<WifiSecurity> rsnSecurity) {
        this.rsnSecurity = rsnSecurity;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ssid=").append(this.ssid);
        if (this.hardwareAddress != null && this.hardwareAddress.length == 6) {
            sb.append(" :: hardwareAddress=").append(NetworkUtil.macToString(this.hardwareAddress));
        }
        sb.append(" :: frequency=").append(this.frequency).append(" :: mode=").append(this.mode);
        if (this.bitrate != null && this.bitrate.size() > 0) {
            sb.append(" :: bitrate=");
            for (Long rate : this.bitrate) {
                sb.append(rate).append(" ");
            }
        }
        sb.append(" :: strength=").append(this.strength);
        if (this.wpaSecurity != null && this.wpaSecurity.size() > 0) {
            sb.append(" :: wpaSecurity=");
            for (WifiSecurity security : this.wpaSecurity) {
                sb.append(security).append(" ");
            }
        }
        if (this.rsnSecurity != null && this.rsnSecurity.size() > 0) {
            sb.append(" :: rsnSecurity=");
            for (WifiSecurity security : this.rsnSecurity) {
                sb.append(security).append(" ");
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bitrate == null ? 0 : this.bitrate.hashCode());
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * result + (int)(this.frequency ^ this.frequency >>> 32);
        result = 31 * result + Arrays.hashCode(this.hardwareAddress);
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.rsnSecurity == null ? 0 : this.rsnSecurity.hashCode());
        result = 31 * result + (this.ssid == null ? 0 : this.ssid.hashCode());
        result = 31 * result + this.strength;
        result = 31 * result + (this.wpaSecurity == null ? 0 : this.wpaSecurity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WifiAccessPointImpl)) {
            return false;
        }
        WifiAccessPointImpl other = (WifiAccessPointImpl)obj;
        if (this.bitrate == null ? other.bitrate != null : !this.bitrate.equals(other.bitrate)) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        if (this.frequency != other.frequency) {
            return false;
        }
        if (!Arrays.equals(this.hardwareAddress, other.hardwareAddress)) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.rsnSecurity == null ? other.rsnSecurity != null : !this.rsnSecurity.equals(other.rsnSecurity)) {
            return false;
        }
        if (this.ssid == null ? other.ssid != null : !this.ssid.equals(other.ssid)) {
            return false;
        }
        if (this.strength != other.strength) {
            return false;
        }
        return !(this.wpaSecurity == null ? other.wpaSecurity != null : !this.wpaSecurity.equals(other.wpaSecurity));
    }
}

