/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.NettyUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MoquetteIdleTimeoutHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MoquetteIdleTimeoutHandler.class);

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState e = ((IdleStateEvent)evt).state();
            if (e == IdleState.READER_IDLE) {
                LOG.info("Firing channel inactive event. MqttClientId = {}.", (Object)NettyUtils.clientID(ctx.channel()));
                ctx.close().addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Firing Netty event CId = {}, eventClass = {}", (Object)NettyUtils.clientID(ctx.channel()), (Object)evt.getClass().getName());
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

