/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.sirius.diagram.ui.tools.api.part.DiagramEditPartService;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusDiagramImageGenerator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class GenDocDiagramEditPartService
extends DiagramEditPartService {
    public boolean isTooBig(DiagramEditPart diagramEP, ImageFileFormat format) {
        DiagramGenerator gen = this.getDiagramGenerator(diagramEP, format);
        Rectangle rect = gen.calculateImageRectangle(diagramEP.getPrimaryEditParts());
        double factor = this.getExportResolutionFactor(diagramEP, (SiriusDiagramImageGenerator)gen);
        return (double)rect.height * factor * ((double)rect.width * factor) > (double)this.getMaximumTotalSize() && format != ImageFileFormat.SVG;
    }

    public List getDiagramPartInfo(DiagramEditPart diagramEditPart) {
        DiagramGenerator gen = this.getDiagramGenerator(diagramEditPart, ImageFileFormat.JPG);
        return gen.getDiagramPartInfo();
    }

    public double getExportResolutionFactor(DiagramEditPart diagramEP) {
        DiagramGenerator gen = this.getDiagramGenerator(diagramEP, ImageFileFormat.JPG);
        return super.getExportResolutionFactor(diagramEP, (SiriusDiagramImageGenerator)gen);
    }

    public Rectangle getImageDimension(DiagramEditPart diagramEP) {
        return this.getDiagramGenerator(diagramEP, ImageFileFormat.JPG).calculateImageRectangle(diagramEP.getPrimaryEditParts());
    }

    protected void saveToFile(IPath destination, Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) throws CoreException {
        IStatus fileModificationStatus = this.createFile(destination);
        if (!fileModificationStatus.isOK()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream stream = new FileOutputStream(destination.toOSString());){
                this.saveToOutputStream(stream, image, imageFormat, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SiriusPlugin.getDefault().error(e.getMessage(), (Throwable)e);
            Status status = new Status(4, "exportToFile", 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        this.refreshLocal(destination);
    }

    private IStatus createFile(IPath destination) throws CoreException {
        File osFile;
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null && !file.exists() && !(osFile = new File(destination.toOSString())).exists()) {
            ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
            file.create((InputStream)input, false, null);
        }
        if (file != null) {
            return FileModificationValidator.approveFileModification((IFile[])new IFile[]{file});
        }
        return Status.OK_STATUS;
    }

    private void refreshLocal(IPath destination) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null) {
            file.refreshLocal(0, null);
        }
    }

    private void saveToOutputStream(OutputStream stream, Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) {
        monitor.worked(1);
        ImageData imageData = image.getImageData();
        if (imageFormat.equals((Object)ImageFileFormat.GIF)) {
            imageData = this.createImageData(image);
        }
        monitor.worked(1);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.logicalScreenHeight = image.getBounds().width;
        imageLoader.logicalScreenHeight = image.getBounds().height;
        if (imageFormat.equals((Object)ImageFileFormat.JPG)) {
            imageLoader.compression = 100;
        }
        imageLoader.save(stream, imageFormat.getOrdinal());
        monitor.worked(1);
    }

    private ImageData createImageData(Image image) {
        ImageData imageData = image.getImageData();
        if (imageData.depth <= 8) {
            return imageData;
        }
        ImageData newImageData = this.get8BitPaletteImageData(imageData);
        if (newImageData == null) {
            newImageData = this.getWebSafePalletteImageData(imageData);
        }
        return newImageData;
    }

    private ImageData get8BitPaletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] colours = new RGB[256];
        PaletteData newPaletteData = new PaletteData(colours);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (colours[newPixel] == null) {
                            colours[newPixel] = colour;
                            break;
                        }
                        if (colours[newPixel].equals((Object)colour)) break;
                        ++newPixel;
                    }
                    if (newPixel >= 256) {
                        return null;
                    }
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return newImageData;
    }

    private ImageData getWebSafePalletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] webSafePallette = this.getWebSafePallette();
        PaletteData newPaletteData = new PaletteData(webSafePallette);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    RGB webSafeColour = this.getWebSafeColour(colour);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (webSafePallette[newPixel].equals((Object)webSafeColour)) break;
                        ++newPixel;
                    }
                    Assert.isTrue((newPixel < 216 ? 1 : 0) != 0);
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        return newImageData;
    }

    private RGB getWebSafeColour(RGB colour) {
        int red = Math.round((colour.red + 25) / 51) * 51;
        int green = Math.round((colour.green + 25) / 51) * 51;
        int blue = Math.round((colour.blue + 25) / 51) * 51;
        return new RGB(red, green, blue);
    }

    private RGB[] getWebSafePallette() {
        RGB[] colours = new RGB[256];
        int i = 0;
        int red = 0;
        while (red <= 255) {
            int green = 0;
            while (green <= 255) {
                int blue = 0;
                while (blue <= 255) {
                    RGB colour = new RGB(red, green, blue);
                    colours[i++] = colour;
                    blue += 51;
                }
                green += 51;
            }
            red += 51;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return colours;
    }
}

