/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.tools.ext.types;

import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.polarsys.kitalpha.richtext.widget.tools.dialogs.FilteredElementTreeSelectionDialog;
import org.polarsys.kitalpha.richtext.widget.tools.ext.types.AbstractModelOpenLink;
import org.polarsys.kitalpha.richtext.widget.tools.intf.LinkHandler;
import org.polarsys.kitalpha.richtext.widget.tools.messages.Messages;
import org.polarsys.kitalpha.richtext.widget.tools.utils.MDERichTextToolsHelper;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Tuple;

public class ModelElementLinkHandler
extends AbstractModelOpenLink
implements LinkHandler {
    public Tuple<String, String> getLink(String linkType, String basePath, Object object) {
        Tuple<String, String> path = null;
        if (object instanceof EObject) {
            EObject modelElement = (EObject)object;
            AdapterFactoryLabelProvider labelProvider = MDERichTextToolsHelper.getLabelProvider((EObject)modelElement);
            AdapterFactoryContentProvider contentProvider = MDERichTextToolsHelper.getContentProvider((EObject)modelElement);
            if (labelProvider != null && contentProvider != null) {
                Object result;
                EObject root;
                FilteredElementTreeSelectionDialog dialog = new FilteredElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                dialog.setTitle(Messages.RichTextWidget_Dialog_Title_Model_Element_Selection);
                dialog.setMessage(Messages.RichTextWidget_Dialog_Title_Selection_Model_Element);
                if (modelElement instanceof DRepresentationDescriptor) {
                    diagram = (DRepresentationDescriptor)modelElement;
                    root = EcoreUtil.getRootContainer((EObject)diagram.getTarget());
                } else if (modelElement instanceof DRepresentation && modelElement instanceof DSemanticDecorator) {
                    diagram = (DSemanticDecorator)modelElement;
                    root = EcoreUtil.getRootContainer((EObject)diagram.getTarget());
                } else {
                    root = EcoreUtil.getRootContainer((EObject)modelElement);
                }
                dialog.setInput((Object)root.eResource());
                if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof EObject) {
                    String link = EcoreUtil.getURI((EObject)((EObject)result)).toString();
                    path = this.getTuple(link, result);
                }
            }
        }
        return path;
    }

    protected Tuple<String, String> getTuple(String link, Object object) {
        String result = null;
        String label = null;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            label = MDERichTextToolsHelper.getName((EObject)eObject);
            Resource eResource = eObject.eResource();
            if (eResource instanceof XMLResource) {
                result = ((XMLResource)eResource).getID(eObject);
            }
            if (result == null && (result = EcoreUtil.getURI((EObject)eObject).fragment()) != null) {
                return new Tuple((Object)result, (Object)label);
            }
        }
        if (result == null) {
            result = link;
        }
        return new Tuple((Object)result, (Object)label);
    }

    public String encode(String url, String urlDisplayName) {
        String replaced = MDERichTextToolsHelper.encodeWhiteSpaces((String)StringEscapeUtils.escapeHtml((String)urlDisplayName));
        return "<a href=\"hlink://" + url + "\">" + replaced + "</a>";
    }

    public String decode(String url, String basePath) {
        url = url.replaceFirst("hlink://", "");
        url = url.replaceAll("/", "");
        return url;
    }
}

