/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.services.helpers.ViewpointHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.predicate.exceptions.EvaluationException;
import org.polarsys.kitalpha.ad.viewpoint.predicate.factories.FactoryProvider;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.ContextProvider;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.TransitionEngine;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.ad.viewpoint.ui.internal.actions.ViewpointUIContextProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.provider.AFContextProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.OpenViewAction;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.SelectionListener2;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewpointManagerContentProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewpointManagerLabelProvider;
import org.polarsys.kitalpha.model.common.commands.registry.WorkflowType;
import org.polarsys.kitalpha.model.common.commands.runner.ModelCommandRunner;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.IViewpointTreeDescription;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.ViewpointTreeContainer;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class ViewpointManagerView
extends ViewPart {
    private static final String ERROR_LABEL = "Error";
    private static final String DISPLAY_VIEWPOINT_ACTION = "Display.Viewpoint";
    private ResourceSet context;
    private TableViewer viewer;
    private MyAction activateAction;
    private MyAction desacticateAction;
    private Action referenceAction;
    private Action unReferenceAction;
    private Action refreshAction;
    private Action showHiddenViewpointAction;
    private OpenViewAction openViewAction;
    private ViewpointManager.OverallListener vpListener = new ViewpointManager.OverallListener(){

        public void hasBeenDeactivated(Object ctx, Resource vp) {
            ViewpointManagerView.this.init();
        }

        public void hasBeenActivated(Object ctx, Resource vp) {
            ViewpointManagerView.this.init();
        }

        public void hasBeenFiltered(Object ctx, Resource vp) {
            ViewpointManagerView.this.init();
        }

        public void hasBeenDisplayed(Object ctx, Resource vp) {
            ViewpointManagerView.this.init();
        }
    };
    private final IResourceChangeListener wsListener = event -> {
        IResourceDelta delta = event.getDelta();
        IResource resource = event.getResource();
        int type = event.getType();
        if ((type == 4 || type == 2) && resource instanceof IProject) {
            this.delayedInit();
        } else if (type == 1) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                resource = childDelta.getResource();
                if (resource instanceof IProject) {
                    this.delayedInit();
                    break;
                }
                ++n2;
            }
        }
    };
    private final ViewpointManagerLabelProvider labelProvider = new ViewpointManagerLabelProvider();

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout clayout = new GridLayout();
        clayout.numColumns = 3;
        clayout.marginWidth = 2;
        clayout.marginHeight = 2;
        clayout.horizontalSpacing = 0;
        clayout.verticalSpacing = 0;
        composite.setLayout((Layout)clayout);
        Label imgLabel = new Label(composite, 0);
        Label textLabel = new Label(composite, 0);
        imgLabel.setLayoutData((Object)new GridData());
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        textLabel.setLayoutData((Object)layoutData);
        imgLabel.setImage(Activator.getDefault().getImage("icons/warning.png"));
        textLabel.setText(Messages.ViewpointManagerView_default_label);
        this.createViewer(composite);
        this.init();
        ViewpointManager.addOverallListener((ViewpointManager.OverallListener)this.vpListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.wsListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)new SelectionListener(textLabel, imgLabel));
    }

    public void createViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout clayout = new GridLayout();
        clayout.horizontalSpacing = 0;
        clayout.verticalSpacing = 0;
        clayout.marginWidth = 2;
        clayout.marginHeight = 2;
        composite.setLayout((Layout)clayout);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        composite.setLayoutData((Object)layoutData);
        this.viewer = new TableViewer(composite, 68356);
        this.viewer.getControl().setFont(composite.getFont());
        TableViewerSorter comparator = new TableViewerSorter();
        this.viewer.setComparator((ViewerComparator)comparator);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        this.viewer.getControl().setLayoutData((Object)data);
        Table table = this.viewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableViewerColumn nameColumn = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 250, true));
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setResizable(true);
        TableViewerColumn versionColumn = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 150, true));
        versionColumn.getColumn().setText("Version");
        versionColumn.getColumn().setResizable(true);
        TableViewerColumn stateColumn = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
        stateColumn.getColumn().setText("State");
        stateColumn.getColumn().setResizable(true);
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn col = table.getColumn(i);
            col.addSelectionListener((org.eclipse.swt.events.SelectionListener)new HeaderSelectionListener(comparator, i));
            ++i;
        }
        table.setSortColumn(nameColumn.getColumn());
        table.setSortDirection(1024);
        this.viewer.setContentProvider((IContentProvider)new ViewpointManagerContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.viewer.addSelectionChangedListener(event -> this.updateActions((IStructuredSelection)event.getSelection()));
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (((ViewpointManager.Description)element).shloudBeHidden()) {
                    return ViewpointManagerView.this.showHiddenViewpointAction.isChecked();
                }
                return true;
            }
        });
    }

    private void delayedInit() {
        new RefreshJob().schedule(1000L);
    }

    private void init() {
        new RefreshJob().schedule();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(event -> this.openViewAction.run());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(manager));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.referenceAction);
        manager.add((IAction)this.unReferenceAction);
        if (this.activateAction.isVisible() && this.desacticateAction.isVisible()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.activateAction);
            manager.add((IAction)this.desacticateAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openViewAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showHiddenViewpointAction);
    }

    protected void updateActions(IStructuredSelection selection) {
        int size;
        int n = size = selection == null ? 0 : selection.size();
        if (size == 1 && !this.isTeamContext()) {
            ViewpointManager.Description res = (ViewpointManager.Description)selection.getFirstElement();
            if (this.context != null) {
                boolean used = ViewpointManager.getInstance((ResourceSet)this.context).isUsed(res.getId());
                boolean canChangeState = ViewpointManager.canChangeState((String)res.getId());
                boolean canChangeActivation = ViewpointManager.canChangeActivation((String)res.getId());
                this.referenceAction.setEnabled(!used && canChangeState);
                this.unReferenceAction.setEnabled(used && canChangeState);
                if (used) {
                    boolean filtered = ViewpointManager.getInstance((ResourceSet)this.context).isFiltered(res.getId());
                    this.activateAction.setEnabled(filtered && canChangeState);
                    this.desacticateAction.setEnabled(!filtered && canChangeState);
                } else {
                    this.activateAction.setEnabled(false);
                    this.desacticateAction.setEnabled(false);
                }
                this.activateAction.setVisible(canChangeActivation);
                this.desacticateAction.setVisible(canChangeActivation);
            }
            this.openViewAction.setResource(ViewpointManager.getViewpoint((String)res.getId()));
        } else {
            this.referenceAction.setEnabled(false);
            this.unReferenceAction.setEnabled(false);
            this.activateAction.setEnabled(false);
            this.desacticateAction.setEnabled(false);
            this.openViewAction.setResource(null);
        }
    }

    private boolean isTeamContext() {
        if (this.context != null) {
            for (org.eclipse.emf.ecore.resource.Resource re : this.context.getResources()) {
                if (!"cdo".equals(re.getURI().scheme())) continue;
                return true;
            }
        }
        return false;
    }

    private void makeActions() {
        this.showHiddenViewpointAction = new Action("", 2){

            public void run() {
                ViewpointManagerView.this.viewer.refresh();
            }
        };
        this.showHiddenViewpointAction.setText("Show all viewpoints");
        this.showHiddenViewpointAction.setToolTipText("Show all viewpoints");
        this.showHiddenViewpointAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/displayAll.png"));
        this.referenceAction = new Action(){

            public void run() {
                IStructuredSelection ss = (IStructuredSelection)ViewpointManagerView.this.viewer.getSelection();
                int size = ss.size();
                if (size != 1 || ViewpointManagerView.this.context == null) {
                    return;
                }
                ViewpointManager.Description res = (ViewpointManager.Description)ss.getFirstElement();
                ViewpointManager vpMgr = ViewpointManager.getInstance((ResourceSet)ViewpointManagerView.this.context);
                if (vpMgr.isReferenced(res.getId())) {
                    return;
                }
                try {
                    vpMgr.reference(res.getId());
                }
                catch (ViewpointActivationException | EvaluationException e) {
                    MessageDialog.openError((Shell)ViewpointManagerView.this.getSite().getShell(), (String)ViewpointManagerView.ERROR_LABEL, (String)e.getMessage());
                    AD_Log.getDefault().logError(e);
                }
            }
        };
        this.referenceAction.setText("Reference");
        this.referenceAction.setToolTipText("Reference this viewpoint");
        this.referenceAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/reference.gif"));
        this.unReferenceAction = new Action(){

            public void run() {
                block11: {
                    String id;
                    IStructuredSelection ss = (IStructuredSelection)ViewpointManagerView.this.viewer.getSelection();
                    int size = ss.size();
                    if (size != 1 || ViewpointManagerView.this.context == null) {
                        return;
                    }
                    ViewpointManager.Description res = (ViewpointManager.Description)ss.getFirstElement();
                    ViewpointManager vpMgr = ViewpointManager.getInstance((ResourceSet)ViewpointManagerView.this.context);
                    if (!vpMgr.isReferenced(id = res.getId())) {
                        return;
                    }
                    Shell site = ViewpointManagerView.this.getSite().getShell();
                    try {
                        boolean dirty = false;
                        org.eclipse.emf.ecore.resource.Resource airdResource = null;
                        for (org.eclipse.emf.ecore.resource.Resource r : ViewpointManagerView.this.context.getResources()) {
                            URI uri = r.getURI();
                            if (!uri.isPlatformResource()) continue;
                            dirty |= r.isModified();
                            if (airdResource != null || "afm".equals(uri.fileExtension())) continue;
                            airdResource = r;
                        }
                        String title = "Unreference viewpoint " + res.getLabel();
                        if (dirty) {
                            MessageDialog.openInformation((Shell)site, (String)title, (String)"You must save the model before unreferencing the viewpoint.");
                            return;
                        }
                        if (airdResource == null) {
                            MessageDialog.openError((Shell)site, (String)title, (String)"Cannot locate resource to work on.");
                            return;
                        }
                        if (!MessageDialog.openQuestion((Shell)site, (String)title, (String)"Viewpoint Detachment is required. Proceed ?")) {
                            return;
                        }
                        ViewpointUIContextProvider contextProvider = new ViewpointUIContextProvider(res.getId(), vpMgr);
                        TransitionEngine transitionEngine = FactoryProvider.getTransitionFactory().createTransitionEngine(res.getId(), "Unreference.Viewpoint", (ContextProvider)contextProvider);
                        if (transitionEngine.eval()) {
                            ModelScrutinyRegistry analysis = Scrutineer.startScrutiny((org.eclipse.emf.ecore.resource.Resource)airdResource);
                            ModelScrutinyRegistry.RegistryElement vpReg = analysis.getRegistryElement("org.polarsys.kitalpha.model.common.scrutiny.contrib.scrutiny.viewpoints");
                            Collection finders = vpReg.getFinders();
                            for (IScrutinize s : finders) {
                                ViewpointTreeContainer vps = (ViewpointTreeContainer)s.getAnalysisResult();
                                for (IViewpointTreeDescription root : vps.getRoots()) {
                                    this.unselect(root, id);
                                }
                            }
                            ModelCommandRunner commandRunner = new ModelCommandRunner();
                            commandRunner.run(analysis, airdResource, EnumSet.of(WorkflowType.ALL, WorkflowType.DETACHMENT), (IProgressMonitor)new NullProgressMonitor());
                            break block11;
                        }
                        String message = ViewpointHelper.buildDiagnosticMessage((TransitionEngine)transitionEngine, (boolean)false, (String)("Cannot Unreference viewpoint: " + res.getId()));
                        throw new ViewpointActivationException(message);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)site, (String)ViewpointManagerView.ERROR_LABEL, (String)e.getMessage());
                        Activator.getDefault().logError(e);
                    }
                }
            }

            private void unselect(IViewpointTreeDescription iViewpointTreeDescription, String vpid) {
                String viewpointId = iViewpointTreeDescription.getViewpointId();
                if (vpid.equals(viewpointId)) {
                    iViewpointTreeDescription.setAsCandidateToKeep(false);
                    iViewpointTreeDescription.updateCandidates(false);
                    return;
                }
                Collection children = iViewpointTreeDescription.getChildren();
                if (children != null && !children.isEmpty()) {
                    for (IViewpointTreeDescription vpd : children) {
                        this.unselect(vpd, vpid);
                    }
                }
            }
        };
        this.unReferenceAction.setText("Unreference");
        this.unReferenceAction.setToolTipText("Unreference the viewpoint");
        this.unReferenceAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/unreference.gif"));
        this.activateAction = new MyAction(this){

            public void run() {
                IStructuredSelection ss = (IStructuredSelection)viewer.getSelection();
                int size = ss.size();
                if (size != 1 || context == null) {
                    return;
                }
                ViewpointManager.Description res = (ViewpointManager.Description)ss.getFirstElement();
                ViewpointManager vpMgr = ViewpointManager.getInstance((ResourceSet)context);
                if (!vpMgr.isReferenced(res.getId())) {
                    return;
                }
                try {
                    vpMgr.setActivationState(res.getId(), true);
                }
                catch (ViewpointActivationException e) {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)ViewpointManagerView.ERROR_LABEL, (String)e.getMessage());
                    Activator.getDefault().logError(e);
                }
            }
        };
        this.activateAction.setText("Activate");
        this.activateAction.setToolTipText("Activate the viewpoint");
        this.activateAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/activate.gif"));
        this.desacticateAction = new MyAction(this){

            public void run() {
                IStructuredSelection ss = (IStructuredSelection)viewer.getSelection();
                int size = ss.size();
                if (size != 1 || context == null) {
                    return;
                }
                ViewpointManager.Description res = (ViewpointManager.Description)ss.getFirstElement();
                ViewpointManager vpMgr = ViewpointManager.getInstance((ResourceSet)context);
                if (!vpMgr.isReferenced(res.getId())) {
                    return;
                }
                try {
                    vpMgr.setActivationState(res.getId(), false);
                }
                catch (ViewpointActivationException e) {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)ViewpointManagerView.ERROR_LABEL, (String)e.getMessage());
                    Activator.getDefault().logError(e);
                }
            }
        };
        this.desacticateAction.setText("Desactivate");
        this.desacticateAction.setToolTipText("Desactiavte the viewpoint");
        this.desacticateAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/deactivate.gif"));
        this.refreshAction = new Action(){

            public void run() {
                ViewpointManagerView.this.init();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh the view");
        this.refreshAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/refresh.gif"));
        this.openViewAction = new OpenViewAction();
        this.openViewAction.setText("Show view");
        this.openViewAction.setToolTipText("Show the viewpoint view");
        this.openViewAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/VP.gif"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        ViewpointManager.removeOverallListener((ViewpointManager.OverallListener)this.vpListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.wsListener);
    }

    private final class HeaderSelectionListener
    extends SelectionListener2 {
        private final TableViewerSorter comparator;
        private final int columnIndex;

        private HeaderSelectionListener(TableViewerSorter comparator, int columnIndex) {
            this.comparator = comparator;
            this.columnIndex = columnIndex;
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            int lastSortColumn = this.comparator.getSortColumn();
            boolean lastAscending = this.comparator.isAscending();
            if (lastSortColumn == this.columnIndex) {
                this.comparator.setAscending(!lastAscending);
            } else {
                this.comparator.setAscending(true);
                this.comparator.setSortColumn(this.columnIndex);
            }
            ViewpointManagerView.this.viewer.refresh();
        }
    }

    private class MyAction
    extends Action {
        private boolean visible = false;

        private MyAction() {
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }

    private final class RefreshJob
    extends Job {
        private RefreshJob() {
            super("Refresh ViewpointManager view");
        }

        protected IStatus run(IProgressMonitor monitor) {
            ViewpointManager.Description[] availableViewpoints = this.getFilteredViewpoints();
            if (ViewpointManagerView.this.viewer != null && ViewpointManagerView.this.viewer.getControl() != null && !ViewpointManagerView.this.viewer.getControl().isDisposed()) {
                ViewpointManagerView.this.getSite().getShell().getDisplay().asyncExec(() -> {
                    ViewpointManagerView.this.viewer.setInput((Object)availableViewpoints);
                    ViewpointManagerView.this.updateActions(null);
                });
            }
            return Status.OK_STATUS;
        }

        private ViewpointManager.Description[] getFilteredViewpoints() {
            ViewpointManager.Description[] viewpointDescriptions = ViewpointManager.getAvailableViewpointDescriptions();
            ArrayList<ViewpointManager.Description> result = new ArrayList<ViewpointManager.Description>();
            ViewpointManager.Description[] descriptionArray = viewpointDescriptions;
            int n = viewpointDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ViewpointManager.Description description = descriptionArray[n2];
                ViewpointUIContextProvider displayContextProvider = new ViewpointUIContextProvider(description.getId(), ViewpointManager.getInstance((ResourceSet)ViewpointManagerView.this.context));
                TransitionEngine transitionEngine = FactoryProvider.getTransitionFactory().createTransitionEngine(description.getId(), ViewpointManagerView.DISPLAY_VIEWPOINT_ACTION, (ContextProvider)displayContextProvider);
                try {
                    if (transitionEngine.eval()) {
                        result.add(description);
                    }
                }
                catch (EvaluationException e) {
                    AD_Log.getDefault().logWarning((Throwable)e);
                }
                ++n2;
            }
            return result.toArray(new ViewpointManager.Description[result.size()]);
        }
    }

    private final class SelectionListener
    implements ISelectionListener {
        private final Label textLabel;
        private final Label imgLabel;

        private SelectionListener(Label textLabel, Label imgLabel) {
            this.textLabel = textLabel;
            this.imgLabel = imgLabel;
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ViewpointManagerView.this.context = this.analyseChange(part, selection);
            if (!this.textLabel.isDisposed() && !this.imgLabel.isDisposed()) {
                this.imgLabel.setImage(ViewpointManagerView.this.context == null ? Activator.getDefault().getImage("icons/warning.png") : null);
                this.textLabel.setText(this.computeLabel());
            }
            if (ViewpointManagerView.this.viewer != null && !ViewpointManagerView.this.viewer.getControl().isDisposed()) {
                ViewpointManagerView.this.updateActions(null);
                ViewpointManagerView.this.labelProvider.setContext(ViewpointManagerView.this.context);
                ViewpointManagerView.this.viewer.refresh();
            }
        }

        private String computeLabel() {
            if (ViewpointManagerView.this.context == null) {
                return Messages.ViewpointManagerView_default_label;
            }
            if (ViewpointManagerView.this.context.getResources().isEmpty()) {
                return "";
            }
            String segment = ((org.eclipse.emf.ecore.resource.Resource)ViewpointManagerView.this.context.getResources().get(0)).getURI().segment(1);
            try {
                segment = URLDecoder.decode(segment, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AD_Log.getDefault().logWarning((Throwable)e);
            }
            return "Project " + segment;
        }

        private ResourceSet analyseChange(IWorkbenchPart part, ISelection selection) {
            for (AFContextProvider prov : AFContextProvider.INSTANCE.getProviders()) {
                ResourceSet computeContext = prov.computeContext(part, selection);
                if (computeContext == null) continue;
                return computeContext;
            }
            return null;
        }
    }

    private final class TableViewerSorter
    extends ViewerComparator {
        private int sortColumn = 0;
        private boolean ascending = true;

        private TableViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ITableLabelProvider prov = (ITableLabelProvider)((TableViewer)viewer).getLabelProvider();
            String name1 = prov.getColumnText(e1, this.sortColumn);
            String name2 = prov.getColumnText(e2, this.sortColumn);
            if (this.ascending) {
                return this.getComparator().compare(name1, name2);
            }
            return this.getComparator().compare(name2, name1);
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public void setSortColumn(int sortColumn) {
            this.sortColumn = sortColumn;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }
}

