/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class LambdaExpressionsFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private static boolean fConversionRemovesAnnotations;

    private static boolean areSameIdentifiers(MethodDeclaration node, List<Expression> arguments) {
        int i = 0;
        while (i < node.parameters().size()) {
            Expression expression = ASTNodes.getUnparenthesedExpression(arguments.get(i));
            if (!(expression instanceof SimpleName) || !LambdaExpressionsFixCore.isSameIdentifier(node, i, (SimpleName)expression)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isSameIdentifier(MethodDeclaration node, int i, SimpleName argument) {
        SingleVariableDeclaration decl = (SingleVariableDeclaration)node.parameters().get(i);
        return decl.getName().getIdentifier().equals(argument.getIdentifier());
    }

    public static MethodInvocationStatus checkMethodInvocation(MethodDeclaration visited, MethodInvocation methodInvocation) {
        SimpleName calledObject;
        Expression calledExpression = methodInvocation.getExpression();
        List arguments = methodInvocation.arguments();
        MethodRefStatus actionType = MethodRefStatus.NO_REF;
        ITypeBinding classBinding = null;
        if (visited.parameters().size() == arguments.size()) {
            if (LambdaExpressionsFixCore.areSameIdentifiers(visited, arguments)) {
                AbstractTypeDeclaration enclosingType;
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                ITypeBinding calledType = null;
                if (methodBinding != null) {
                    calledType = methodBinding.getDeclaringClass();
                } else if (calledExpression != null) {
                    calledType = calledExpression.resolveTypeBinding();
                } else {
                    ITypeBinding enclosingTypeBinding;
                    enclosingType = ASTNodes.getTypedAncestor((ASTNode)visited, AbstractTypeDeclaration.class);
                    if (enclosingType != null && (enclosingTypeBinding = enclosingType.resolveBinding()) != null) {
                        List argumentTypes = methodInvocation.typeArguments();
                        String[] parameterTypeNames = new String[methodInvocation.arguments().size()];
                        int i = 0;
                        while (i < argumentTypes.size()) {
                            Type argumentType = (Type)argumentTypes.get(i);
                            if (argumentType.resolveBinding() == null) {
                                return null;
                            }
                            parameterTypeNames[i] = argumentType.resolveBinding().getQualifiedName();
                            ++i;
                        }
                        IMethodBinding[] iMethodBindingArray = enclosingTypeBinding.getDeclaredMethods();
                        int n = iMethodBindingArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethodBinding declaredMethods = iMethodBindingArray[n2];
                            if (ASTNodes.usesGivenSignature(declaredMethods, enclosingTypeBinding.getQualifiedName(), methodInvocation.getName().getIdentifier(), parameterTypeNames)) {
                                calledType = enclosingTypeBinding;
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                if (Boolean.TRUE.equals(ASTNodes.isStatic(methodInvocation)) && calledType != null) {
                    boolean valid = true;
                    if (!arguments.isEmpty() && ((Expression)arguments.get(0)).resolveTypeBinding() != null && ((Expression)arguments.get(0)).resolveTypeBinding().isSubTypeCompatible(calledType)) {
                        String[] remainingParams = new String[arguments.size() - 1];
                        int i = 0;
                        while (i < arguments.size() - 1) {
                            ITypeBinding resolveTypeBinding = ((Expression)arguments.get(i + 1)).resolveTypeBinding();
                            if (resolveTypeBinding == null) {
                                valid = false;
                                break;
                            }
                            remainingParams[i] = resolveTypeBinding.getQualifiedName();
                            ++i;
                        }
                        if (valid) {
                            IMethodBinding[] iMethodBindingArray = calledType.getDeclaredMethods();
                            int n = iMethodBindingArray.length;
                            int resolveTypeBinding = 0;
                            while (resolveTypeBinding < n) {
                                IMethodBinding declaredMethodBinding = iMethodBindingArray[resolveTypeBinding];
                                if (!Modifier.isStatic((int)declaredMethodBinding.getModifiers()) && ASTNodes.usesGivenSignature(declaredMethodBinding, calledType.getQualifiedName(), methodInvocation.getName().getIdentifier(), remainingParams)) {
                                    valid = false;
                                    break;
                                }
                                ++resolveTypeBinding;
                            }
                        }
                    }
                    if (valid) {
                        actionType = MethodRefStatus.TYPE_REF;
                        classBinding = calledType;
                    }
                }
                if (actionType != MethodRefStatus.TYPE_REF) {
                    FieldAccess fieldAccess;
                    if (calledExpression == null) {
                        if (calledType != null && (enclosingType = Bindings.getBindingOfParentType(visited.getParent().getParent())) != null && Bindings.isSuperType(calledType, (ITypeBinding)enclosingType)) {
                            actionType = MethodRefStatus.METHOD_REF;
                        }
                    } else if (calledExpression instanceof StringLiteral || calledExpression instanceof NumberLiteral || calledExpression instanceof ThisExpression) {
                        actionType = MethodRefStatus.METHOD_REF;
                    } else if (calledExpression instanceof FieldAccess) {
                        fieldAccess = (FieldAccess)calledExpression;
                        if (fieldAccess.resolveFieldBinding() != null && fieldAccess.resolveFieldBinding().isEffectivelyFinal()) {
                            actionType = MethodRefStatus.METHOD_REF;
                        }
                    } else if (calledExpression instanceof SuperFieldAccess && (fieldAccess = (SuperFieldAccess)calledExpression).resolveFieldBinding() != null && fieldAccess.resolveFieldBinding().isEffectivelyFinal()) {
                        actionType = MethodRefStatus.METHOD_REF;
                    }
                }
            }
        } else if (calledExpression instanceof SimpleName && visited.parameters().size() == arguments.size() + 1 && LambdaExpressionsFixCore.isSameIdentifier(visited, 0, calledObject = (SimpleName)calledExpression)) {
            boolean valid = true;
            int i = 0;
            while (i < arguments.size()) {
                Expression expression = ASTNodes.getUnparenthesedExpression((Expression)arguments.get(i));
                if (!(expression instanceof SimpleName) || !LambdaExpressionsFixCore.isSameIdentifier(visited, i + 1, (SimpleName)expression)) {
                    valid = false;
                    break;
                }
                ++i;
            }
            if (valid) {
                ITypeBinding klass = null;
                if (calledExpression.resolveTypeBinding() != null) {
                    klass = calledExpression.resolveTypeBinding();
                } else if (methodInvocation.resolveMethodBinding() != null && methodInvocation.resolveMethodBinding().getDeclaringClass() != null) {
                    klass = methodInvocation.resolveMethodBinding().getDeclaringClass();
                }
                if (klass != null) {
                    String[] cumulativeParams = new String[arguments.size() + 1];
                    cumulativeParams[0] = klass.getQualifiedName();
                    int i2 = 0;
                    while (i2 < arguments.size()) {
                        ITypeBinding resolveTypeBinding = ((Expression)arguments.get(i2)).resolveTypeBinding();
                        if (resolveTypeBinding == null) {
                            valid = false;
                            break;
                        }
                        cumulativeParams[i2 + 1] = resolveTypeBinding.getQualifiedName();
                        ++i2;
                    }
                    if (valid) {
                        IMethodBinding[] iMethodBindingArray = klass.getDeclaredMethods();
                        int n = iMethodBindingArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IMethodBinding declaredMethodBinding = iMethodBindingArray[n3];
                            if (Modifier.isStatic((int)declaredMethodBinding.getModifiers()) && ASTNodes.usesGivenSignature(declaredMethodBinding, klass.getQualifiedName(), methodInvocation.getName().getIdentifier(), cumulativeParams)) {
                                valid = false;
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (valid) {
                        actionType = MethodRefStatus.TYPE_REF;
                        classBinding = klass;
                    }
                }
            }
        }
        return new MethodInvocationStatus(actionType, classBinding);
    }

    private static Type copyType(CompilationUnitRewrite cuRewrite, AST ast, ASTNode node, ITypeBinding typeBinding) {
        ITypeBinding[] bounds;
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(node, importRewrite);
        ITypeBinding modifiedType = typeBinding.getTypeParameters().length == 0 ? (typeBinding.isCapture() ? ((bounds = typeBinding.getTypeBounds()).length > 0 ? bounds[0] : typeBinding.getErasure()) : typeBinding.getErasure()) : typeBinding;
        return ASTNodeFactory.newCreationType(ast, modifiedType, importRewrite, importContext);
    }

    public static LambdaExpressionsFixCore createConvertToLambdaFix(ClassInstanceCreation cic) {
        CompilationUnit root = (CompilationUnit)cic.getRoot();
        if (!LambdaExpressionsFixCore.isFunctionalAnonymous(cic)) {
            return null;
        }
        CreateLambdaOperation op = new CreateLambdaOperation(Collections.singletonList(cic), true);
        String message = fConversionRemovesAnnotations ? FixMessages.LambdaExpressionsFix_convert_to_lambda_expression_removes_annotations : FixMessages.LambdaExpressionsFix_convert_to_lambda_expression;
        return new LambdaExpressionsFixCore(message, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
    }

    public static IProposableFix createConvertToAnonymousClassCreationsFix(LambdaExpression lambda) {
        if (lambda.resolveTypeBinding() == null || lambda.resolveTypeBinding().getFunctionalInterfaceMethod() == null) {
            return null;
        }
        CreateAnonymousClassCreationOperation op = new CreateAnonymousClassCreationOperation(Collections.singletonList(lambda));
        CompilationUnit root = (CompilationUnit)lambda.getRoot();
        return new LambdaExpressionsFixCore(FixMessages.LambdaExpressionsFix_convert_to_anonymous_class_creation, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean useLambda, boolean useAnonymous, boolean simplifyLambda) {
        if (useLambda) {
            ArrayList<ClassInstanceCreation> convertibleNodes = FunctionalAnonymousClassesFinder.perform((ASTNode)compilationUnit);
            if (convertibleNodes.isEmpty()) {
                return null;
            }
            Collections.reverse(convertibleNodes);
            CreateLambdaOperation op = new CreateLambdaOperation(convertibleNodes, simplifyLambda);
            return new LambdaExpressionsFixCore(FixMessages.LambdaExpressionsFix_convert_to_lambda_expression, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
        }
        if (useAnonymous) {
            ArrayList<LambdaExpression> convertibleNodes = LambdaExpressionsFinder.perform((ASTNode)compilationUnit);
            if (convertibleNodes.isEmpty()) {
                return null;
            }
            Collections.reverse(convertibleNodes);
            CreateAnonymousClassCreationOperation op = new CreateAnonymousClassCreationOperation(convertibleNodes);
            return new LambdaExpressionsFixCore(FixMessages.LambdaExpressionsFix_convert_to_anonymous_class_creation, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
        }
        return null;
    }

    public LambdaExpressionsFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static boolean isFunctionalAnonymous(ClassInstanceCreation node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        if (typeBinding == null) {
            return false;
        }
        ITypeBinding[] interfaces = typeBinding.getInterfaces();
        if (interfaces.length != 1) {
            return false;
        }
        if (interfaces[0].getFunctionalInterfaceMethod() == null || interfaces[0].getFunctionalInterfaceMethod().isGenericMethod()) {
            return false;
        }
        AnonymousClassDeclaration anonymTypeDecl = node.getAnonymousClassDeclaration();
        if (anonymTypeDecl == null || anonymTypeDecl.resolveBinding() == null) {
            return false;
        }
        List bodyDeclarations = anonymTypeDecl.bodyDeclarations();
        if (bodyDeclarations.size() != 1) {
            return false;
        }
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(0);
        if (!(bodyDeclaration instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)bodyDeclaration;
        IMethodBinding methodBinding = methodDecl.resolveBinding();
        if (methodBinding == null) {
            return false;
        }
        if (methodBinding.isGenericMethod()) {
            return false;
        }
        int modifiers = methodBinding.getModifiers();
        if (Modifier.isSynchronized((int)modifiers) || Modifier.isStrictfp((int)modifiers)) {
            return false;
        }
        if (SuperThisReferenceFinder.hasReference(methodDecl)) {
            return false;
        }
        if (FinalFieldAccessInFieldDeclarationFinder.hasReference(methodDecl)) {
            return false;
        }
        if (ASTNodes.getTargetType((Expression)node) == null) {
            return false;
        }
        if (MethodRecursionFinder.isRecursiveLocal(methodDecl)) {
            return false;
        }
        LambdaExpressionsFixCore.checkAnnotationsRemoval(methodBinding);
        return true;
    }

    public static void checkAnnotationsRemoval(IMethodBinding methodBinding) {
        IAnnotationBinding[] declarationAnnotations;
        fConversionRemovesAnnotations = false;
        IAnnotationBinding[] iAnnotationBindingArray = declarationAnnotations = methodBinding.getAnnotations();
        int n = declarationAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            String qualifiedName;
            IAnnotationBinding declarationAnnotation = iAnnotationBindingArray[n2];
            ITypeBinding annotationType = declarationAnnotation.getAnnotationType();
            if (annotationType != null && !"java.lang.Override".equals(qualifiedName = annotationType.getQualifiedName()) && !"java.lang.Deprecated".equals(qualifiedName)) {
                fConversionRemovesAnnotations = true;
                return;
            }
            ++n2;
        }
    }

    public static final class AnnotationsFinder
    extends ASTVisitor {
        public static boolean hasAnnotations(SingleVariableDeclaration methodParameter) {
            try {
                AnnotationsFinder finder = new AnnotationsFinder();
                methodParameter.accept((ASTVisitor)finder);
            }
            catch (AbortSearchException e) {
                return true;
            }
            return false;
        }

        public boolean visit(MarkerAnnotation node) {
            throw new AbortSearchException();
        }

        public boolean visit(NormalAnnotation node) {
            throw new AbortSearchException();
        }

        public boolean visit(SingleMemberAnnotation node) {
            throw new AbortSearchException();
        }
    }

    public static class CreateAnonymousClassCreationOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation
    implements IAnonymousClassCreationOperation {
        private final List<LambdaExpression> fExpressions;

        public CreateAnonymousClassCreationOperation(List<LambdaExpression> changedNodes) {
            this.fExpressions = changedNodes;
        }

        @Override
        public MethodDeclaration getMethodDeclaration(ICompilationUnit cu, ASTRewrite rewrite, ImportRewrite rewrites, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String[] parameterNames, ITypeBinding targetType, boolean inInterface, ASTNode astNode) throws CoreException {
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu);
            MethodDeclaration methodDeclaration = StubUtility2Core.createImplementationStubCore(cu, rewrite, rewrites, context, binding, parameterNames, targetType, settings, inInterface, astNode, false);
            return methodDeclaration;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            this.rewriteAST(this, cuRewrite, model);
        }

        public void rewriteAST(IAnonymousClassCreationOperation op, CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = rewrite.getAST();
            for (LambdaExpression lambdaExpression : this.fExpressions) {
                Block block;
                ASTNode lambdaBody;
                TextEditGroup group = this.createTextEditGroup(FixMessages.LambdaExpressionsFix_convert_to_anonymous_class_creation, cuRewrite);
                ITypeBinding lambdaTypeBinding = lambdaExpression.resolveTypeBinding();
                IMethodBinding methodBinding = lambdaTypeBinding.getFunctionalInterfaceMethod();
                List parameters = lambdaExpression.parameters();
                String[] parameterNames = new String[parameters.size()];
                int i = 0;
                while (i < parameterNames.length) {
                    parameterNames[i] = ((VariableDeclaration)parameters.get(i)).getName().getIdentifier();
                    ++i;
                }
                ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext((ASTNode)lambdaExpression, importRewrite);
                MethodDeclaration methodDeclaration = op.getMethodDeclaration(cuRewrite.getCu(), rewrite, importRewrite, importContext, methodBinding, parameterNames, lambdaTypeBinding, false, (ASTNode)lambdaExpression);
                ASTNode parentType = ASTResolving.findParentType((ASTNode)lambdaExpression);
                ITypeBinding parentTypeBinding = null;
                if (parentType instanceof AbstractTypeDeclaration) {
                    parentTypeBinding = ((AbstractTypeDeclaration)parentType).resolveBinding();
                } else if (parentType instanceof AnonymousClassDeclaration) {
                    parentTypeBinding = ((AnonymousClassDeclaration)parentType).resolveBinding();
                }
                if (parentTypeBinding != null && (parentTypeBinding = Bindings.normalizeTypeBinding(parentTypeBinding)) != null) {
                    SuperThisQualifier.perform(lambdaExpression, parentTypeBinding.getTypeDeclaration(), cuRewrite, group);
                }
                if ((lambdaBody = lambdaExpression.getBody()) instanceof Block) {
                    block = (Block)ASTNodes.getCopyOrReplacement(rewrite, lambdaBody, group);
                } else {
                    block = ast.newBlock();
                    List statements = block.statements();
                    ITypeBinding returnType = methodBinding.getReturnType();
                    Expression copyTarget = (Expression)ASTNodes.getCopyOrReplacement(rewrite, lambdaBody, group);
                    if (Bindings.isVoidType(returnType)) {
                        ExpressionStatement newExpressionStatement = ast.newExpressionStatement(copyTarget);
                        statements.add(newExpressionStatement);
                    } else {
                        ReturnStatement returnStatement = ast.newReturnStatement();
                        returnStatement.setExpression(copyTarget);
                        statements.add(returnStatement);
                    }
                }
                methodDeclaration.setBody(block);
                AnonymousClassDeclaration anonymousClassDeclaration = ast.newAnonymousClassDeclaration();
                List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
                bodyDeclarations.add(methodDeclaration);
                Type creationType = ASTNodeFactory.newCreationType(ast, lambdaTypeBinding, importRewrite, importContext);
                ClassInstanceCreation classInstanceCreation = ast.newClassInstanceCreation();
                classInstanceCreation.setType(creationType);
                classInstanceCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
                LambdaExpression toReplace = lambdaExpression;
                if (lambdaExpression.getLocationInParent() == CastExpression.EXPRESSION_PROPERTY && lambdaTypeBinding.isEqualTo((IBinding)((CastExpression)lambdaExpression.getParent()).resolveTypeBinding())) {
                    toReplace = lambdaExpression.getParent();
                }
                rewrite.replace((ASTNode)toReplace, (ASTNode)classInstanceCreation, group);
            }
        }
    }

    public static class CreateLambdaOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final List<ClassInstanceCreation> fExpressions;
        private final boolean fSimplifyLambda;

        public CreateLambdaOperation(List<ClassInstanceCreation> expressions, boolean simplifyLambda) {
            this.fExpressions = expressions;
            this.fSimplifyLambda = simplifyLambda;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            final ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRemover importRemover = cuRewrite.getImportRemover();
            final AST ast = rewrite.getAST();
            HashMap<ClassInstanceCreation, HashSet<String>> cicToNewNames = new HashMap<ClassInstanceCreation, HashSet<String>>();
            int i = 0;
            while (i < this.fExpressions.size()) {
                final ClassInstanceCreation classInstanceCreation = this.fExpressions.get(i);
                AnonymousClassDeclaration anonymTypeDecl = classInstanceCreation.getAnonymousClassDeclaration();
                List bodyDeclarations = anonymTypeDecl.bodyDeclarations();
                Object object = bodyDeclarations.get(0);
                if (object instanceof MethodDeclaration) {
                    HashSet<String> excludedNames = new HashSet<String>();
                    if (i != 0) {
                        for (ClassInstanceCreation convertedCic : this.fExpressions.subList(0, i)) {
                            if (!ASTNodes.isParent((ASTNode)convertedCic, (ASTNode)classInstanceCreation)) continue;
                            excludedNames.addAll((Collection)cicToNewNames.get(convertedCic));
                        }
                    }
                    final MethodDeclaration methodDeclaration = (MethodDeclaration)object;
                    final TextEditGroup group = this.createTextEditGroup(FixMessages.LambdaExpressionsFix_convert_to_lambda_expression, cuRewrite);
                    HashSet<String> newNames = this.makeNamesUnique(excludedNames, methodDeclaration, rewrite, group);
                    cicToNewNames.put(classInstanceCreation, new HashSet<String>(newNames));
                    List methodParameters = methodDeclaration.parameters();
                    Block body = methodDeclaration.getBody();
                    List statements = body.statements();
                    Block lambdaBody = body;
                    if (statements.size() == 1) {
                        int extendedLength;
                        Statement statement = (Statement)statements.get(0);
                        CompilationUnit root = cuRewrite.getRoot();
                        int extendedStart = root.getExtendedStartPosition((ASTNode)statement);
                        if (extendedStart + (extendedLength = root.getExtendedLength((ASTNode)statement)) <= statement.getStartPosition() + statement.getLength()) {
                            Expression returnExpression;
                            if (statement instanceof ExpressionStatement) {
                                lambdaBody = ((ExpressionStatement)statement).getExpression();
                            } else if (statement instanceof ReturnStatement && (returnExpression = ((ReturnStatement)statement).getExpression()) != null) {
                                lambdaBody = returnExpression;
                            }
                        }
                    }
                    boolean createExplicitlyTypedParameters = false;
                    for (SingleVariableDeclaration methodParameter : methodParameters) {
                        if (!AnnotationsFinder.hasAnnotations(methodParameter)) continue;
                        createExplicitlyTypedParameters = true;
                        break;
                    }
                    CreationReference cicReplacement = null;
                    if (this.fSimplifyLambda) {
                        if (lambdaBody instanceof MethodInvocation) {
                            MethodInvocation methodInvocation = (MethodInvocation)lambdaBody;
                            MethodInvocationStatus methodInvocationCheck = LambdaExpressionsFixCore.checkMethodInvocation(methodDeclaration, methodInvocation);
                            if (methodInvocationCheck != null) {
                                if (methodInvocationCheck.status() == MethodRefStatus.METHOD_REF) {
                                    ExpressionMethodReference methodRef = ast.newExpressionMethodReference();
                                    if (methodInvocation.getExpression() != null) {
                                        methodRef.setExpression(ASTNodes.createMoveTarget(rewrite, methodInvocation.getExpression()));
                                    } else {
                                        methodRef.setExpression((Expression)ast.newThisExpression());
                                    }
                                    methodRef.setName(ASTNodes.createMoveTarget(rewrite, methodInvocation.getName()));
                                    cicReplacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)methodRef, (Expression)classInstanceCreation);
                                } else if (methodInvocationCheck.status() == MethodRefStatus.TYPE_REF) {
                                    TypeMethodReference typeMethodRef = ast.newTypeMethodReference();
                                    typeMethodRef.setType(LambdaExpressionsFixCore.copyType(cuRewrite, ast, (ASTNode)methodInvocation, methodInvocationCheck.classBinding()));
                                    typeMethodRef.setName(ASTNodes.createMoveTarget(rewrite, methodInvocation.getName()));
                                    cicReplacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)typeMethodRef, (Expression)classInstanceCreation);
                                }
                            }
                        } else if (lambdaBody instanceof ClassInstanceCreation) {
                            ClassInstanceCreation invokedClassInstanceCreation = (ClassInstanceCreation)lambdaBody;
                            List arguments = invokedClassInstanceCreation.arguments();
                            if (methodDeclaration.parameters().size() == arguments.size() && LambdaExpressionsFixCore.areSameIdentifiers(methodDeclaration, arguments) && classInstanceCreation.getAnonymousClassDeclaration() == null) {
                                CreationReference creationRef = ast.newCreationReference();
                                creationRef.setType(LambdaExpressionsFixCore.copyType(cuRewrite, ast, (ASTNode)classInstanceCreation, classInstanceCreation.resolveTypeBinding()));
                                cicReplacement = creationRef;
                            }
                        } else if (lambdaBody instanceof SuperMethodInvocation) {
                            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)lambdaBody;
                            List arguments = superMethodInvocation.arguments();
                            if (methodDeclaration.parameters().size() == arguments.size() && LambdaExpressionsFixCore.areSameIdentifiers(methodDeclaration, arguments)) {
                                SuperMethodReference superMethodRef = ast.newSuperMethodReference();
                                superMethodRef.setName(ASTNodes.createMoveTarget(rewrite, superMethodInvocation.getName()));
                                cicReplacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)superMethodRef, (Expression)classInstanceCreation);
                            }
                        } else if (lambdaBody instanceof InstanceofExpression) {
                            InstanceofExpression instanceofExpression = (InstanceofExpression)lambdaBody;
                            Expression leftOp = instanceofExpression.getLeftOperand();
                            if (methodDeclaration.parameters().size() == 1 && LambdaExpressionsFixCore.areSameIdentifiers(methodDeclaration, List.of(leftOp))) {
                                ExpressionMethodReference instanceofMethodReference = ast.newExpressionMethodReference();
                                TypeLiteral typeLiteral = ast.newTypeLiteral();
                                typeLiteral.setType(LambdaExpressionsFixCore.copyType(cuRewrite, ast, (ASTNode)instanceofExpression, instanceofExpression.getRightOperand().resolveBinding()));
                                instanceofMethodReference.setName(ast.newSimpleName("isInstance"));
                                instanceofMethodReference.setExpression((Expression)typeLiteral);
                                cicReplacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)instanceofMethodReference, (Expression)classInstanceCreation);
                            }
                        }
                    }
                    if (cicReplacement == null) {
                        FieldDeclaration fieldDeclaration;
                        TypeDeclaration declarationClass;
                        VariableDeclarationFragment actualFragment;
                        LambdaExpression lambdaExpression = ast.newLambdaExpression();
                        List lambdaParameters = lambdaExpression.parameters();
                        lambdaExpression.setParentheses(createExplicitlyTypedParameters || methodParameters.size() != 1);
                        for (SingleVariableDeclaration methodParameter : methodParameters) {
                            if (createExplicitlyTypedParameters) {
                                lambdaParameters.add((SingleVariableDeclaration)rewrite.createCopyTarget((ASTNode)methodParameter));
                                importRemover.registerRetainedNode((ASTNode)methodParameter);
                                continue;
                            }
                            VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
                            lambdaParameter.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodParameter.getName()));
                            lambdaParameters.add(lambdaParameter);
                        }
                        final HashSet<ITypeBinding> inheritedTypes = new HashSet<ITypeBinding>();
                        CreateLambdaOperation.collectInheritedTypes(anonymTypeDecl.resolveBinding(), inheritedTypes);
                        ASTVisitor inheritedFieldsVisitor = new ASTVisitor(){

                            public boolean visit(SimpleName node) {
                                IVariableBinding variableBinding;
                                if (!(node.getParent() instanceof QualifiedName && node.getLocationInParent() == QualifiedName.NAME_PROPERTY || node.getParent() instanceof FieldAccess && node.getLocationInParent() == FieldAccess.NAME_PROPERTY || node.getParent() instanceof SuperFieldAccess && node.getLocationInParent() == SuperFieldAccess.NAME_PROPERTY || node.resolveBinding() == null || node.resolveBinding().getKind() != 3 || (variableBinding = (IVariableBinding)node.resolveBinding()) == null || (variableBinding.getModifiers() & 8) == 0 || !variableBinding.isField() || !inheritedTypes.contains(variableBinding.getDeclaringClass()))) {
                                    ITypeBinding cicBinding = classInstanceCreation.getType().resolveBinding();
                                    if (cicBinding != null) {
                                        Name replacement = ast.newName(cicBinding.getName() + "." + node.getFullyQualifiedName());
                                        rewrite.replace((ASTNode)node, (ASTNode)replacement, group);
                                    }
                                    return false;
                                }
                                return true;
                            }
                        };
                        lambdaBody.accept(inheritedFieldsVisitor);
                        ASTNode fragment = ASTNodes.getFirstAncestorOrNull((ASTNode)classInstanceCreation, VariableDeclarationFragment.class, BodyDeclaration.class);
                        if (fragment instanceof VariableDeclarationFragment && (actualFragment = (VariableDeclarationFragment)fragment).getParent() instanceof FieldDeclaration && (declarationClass = ASTNodes.getFirstAncestorOrNull((ASTNode)(fieldDeclaration = (FieldDeclaration)actualFragment.getParent()), TypeDeclaration.class)) != null) {
                            final TypeDeclaration typeDeclaration = declarationClass;
                            final ArrayList<FieldDeclaration> nextFields = new ArrayList<FieldDeclaration>(typeDeclaration.getFields().length);
                            boolean isBefore = true;
                            FieldDeclaration[] fieldDeclarationArray = typeDeclaration.getFields();
                            int n = fieldDeclarationArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                FieldDeclaration oneField = fieldDeclarationArray[n2];
                                if (oneField == fieldDeclaration) {
                                    isBefore = false;
                                }
                                if (!isBefore) {
                                    nextFields.add(oneField);
                                }
                                ++n2;
                            }
                            ASTVisitor visitor = new ASTVisitor(){

                                public boolean visit(MethodInvocation node) {
                                    ITypeBinding fieldType = fieldDeclaration.getType().resolveBinding();
                                    ASTNode declaration = ASTNodes.findDeclaration((IBinding)node.resolveMethodBinding(), (ASTNode)declarationClass);
                                    if (node.getExpression() == null && fieldType != null && methodDeclaration == declaration) {
                                        QualifiedName replacement;
                                        if ((fieldDeclaration.getModifiers() & 8) != 0) {
                                            SimpleName copyOfClassName = (SimpleName)rewrite.createCopyTarget((ASTNode)typeDeclaration.getName());
                                            replacement = ast.newQualifiedName((Name)copyOfClassName, (SimpleName)rewrite.createCopyTarget((ASTNode)actualFragment.getName()));
                                        } else {
                                            FieldAccess newFieldAccess = ast.newFieldAccess();
                                            newFieldAccess.setExpression((Expression)ast.newThisExpression());
                                            newFieldAccess.setName((SimpleName)rewrite.createCopyTarget((ASTNode)actualFragment.getName()));
                                            replacement = newFieldAccess;
                                        }
                                        rewrite.set((ASTNode)node, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)replacement, group);
                                        return false;
                                    }
                                    return true;
                                }

                                public boolean visit(SimpleName node) {
                                    FieldDeclaration currentField;
                                    ASTNode declaration;
                                    if (!(node.getParent() instanceof QualifiedName && node.getLocationInParent() == QualifiedName.NAME_PROPERTY || node.getParent() instanceof FieldAccess && node.getLocationInParent() == FieldAccess.NAME_PROPERTY || node.getParent() instanceof SuperFieldAccess && node.getLocationInParent() == SuperFieldAccess.NAME_PROPERTY || !((declaration = ASTNodes.findDeclaration(node.resolveBinding(), (ASTNode)declarationClass)) instanceof VariableDeclarationFragment) || !(declaration.getParent() instanceof FieldDeclaration) || !nextFields.contains(currentField = (FieldDeclaration)declaration.getParent()))) {
                                        if ((currentField.getModifiers() & 8) != 0) {
                                            SimpleName copyOfClassName = (SimpleName)rewrite.createCopyTarget((ASTNode)typeDeclaration.getName());
                                            QualifiedName replacement = ast.newQualifiedName((Name)copyOfClassName, ASTNodes.createMoveTarget(rewrite, node));
                                            rewrite.replace((ASTNode)node, (ASTNode)replacement, group);
                                        } else {
                                            FieldAccess newFieldAccess = ast.newFieldAccess();
                                            newFieldAccess.setExpression((Expression)ast.newThisExpression());
                                            newFieldAccess.setName(ASTNodes.createMoveTarget(rewrite, node));
                                            rewrite.replace((ASTNode)node, (ASTNode)newFieldAccess, group);
                                        }
                                        return false;
                                    }
                                    return true;
                                }

                                public boolean visit(ThisExpression node) {
                                    Name qualifier = node.getQualifier();
                                    if (qualifier != null && qualifier.resolveBinding() != null && qualifier.resolveBinding().getKind() == 2 && Objects.equals(qualifier.resolveBinding(), typeDeclaration.resolveBinding())) {
                                        rewrite.remove((ASTNode)qualifier, group);
                                    }
                                    return true;
                                }
                            };
                            lambdaBody.accept(visitor);
                        }
                        lambdaExpression.setBody(ASTNodes.getCopyOrReplacement(rewrite, (ASTNode)lambdaBody, group));
                        cicReplacement = lambdaExpression;
                    }
                    ITypeBinding targetTypeBinding = ASTNodes.getTargetType((Expression)classInstanceCreation);
                    if (this.needCastForWildcardArgument(classInstanceCreation) || ASTNodes.isTargetAmbiguous((Expression)classInstanceCreation, ASTNodes.isExplicitlyTypedLambda(cicReplacement)) || targetTypeBinding.getFunctionalInterfaceMethod() == null) {
                        CastExpression cast = ast.newCastExpression();
                        cast.setExpression(cicReplacement);
                        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)classInstanceCreation, importRewrite);
                        Type castType = importRewrite.addImport(classInstanceCreation.getType().resolveBinding(), ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.CAST);
                        cast.setType(castType);
                        importRemover.registerAddedImports(castType);
                        cicReplacement = cast;
                    }
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)classInstanceCreation, cicReplacement, group);
                    importRemover.registerRemovedNode((ASTNode)classInstanceCreation);
                    importRemover.registerRetainedNode((ASTNode)lambdaBody);
                }
                ++i;
            }
        }

        private boolean needCastForWildcardArgument(ClassInstanceCreation classInstanceCreation) {
            if (classInstanceCreation.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY) {
                MethodInvocation parent = (MethodInvocation)classInstanceCreation.getParent();
                List arguments = parent.arguments();
                IMethodBinding methodBinding = parent.resolveMethodBinding();
                if (methodBinding != null) {
                    ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
                    int index = -1;
                    int i = 0;
                    while (i < arguments.size()) {
                        if (arguments.get(i) == classInstanceCreation) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index >= 0) {
                        ITypeBinding parameterTypeBinding = null;
                        parameterTypeBinding = index < parameterTypes.length ? parameterTypes[index] : parameterTypes[parameterTypes.length - 1].getComponentType();
                        ITypeBinding classInstanceParameterizedType = classInstanceCreation.getType().resolveBinding();
                        ITypeBinding[] classInstanceTypeArguments = classInstanceParameterizedType.getTypeArguments();
                        ITypeBinding[] typeArguments = parameterTypeBinding.getTypeArguments();
                        int i2 = 0;
                        while (i2 < typeArguments.length) {
                            ITypeBinding typeArgument = typeArguments[i2];
                            if (typeArgument.isWildcardType()) {
                                ITypeBinding classInstanceTypeArgument;
                                ITypeBinding bound = typeArgument.getBound();
                                if (bound == null) {
                                    bound = typeArgument.getErasure();
                                }
                                if (!bound.isSubTypeCompatible(classInstanceTypeArgument = classInstanceTypeArguments[i2])) {
                                    return true;
                                }
                            }
                            ++i2;
                        }
                    }
                }
            }
            return false;
        }

        private Expression castMethodRefIfNeeded(CompilationUnitRewrite cuRewrite, AST ast, Expression methodRef, Expression visited) {
            boolean needCast = false;
            Expression replacementNode = methodRef;
            if (visited.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY) {
                MethodInvocation parent = (MethodInvocation)visited.getParent();
                List args = parent.arguments();
                IMethodBinding parentBinding = parent.resolveMethodBinding();
                if (parentBinding != null) {
                    ITypeBinding parentTypeBinding = parentBinding.getDeclaringClass();
                    while (parentTypeBinding != null) {
                        IMethodBinding[] parentTypeMethods;
                        IMethodBinding[] iMethodBindingArray = parentTypeMethods = parentTypeBinding.getDeclaredMethods();
                        int n = parentTypeMethods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethodBinding parentTypeMethod = iMethodBindingArray[n2];
                            if (parentTypeMethod.getName().equals(parentBinding.getName()) && parentTypeMethod.getParameterTypes().length == args.size() && !parentTypeMethod.isEqualTo((IBinding)parentBinding)) {
                                needCast = true;
                                break;
                            }
                            ++n2;
                        }
                        if (needCast) break;
                        parentTypeBinding = parentTypeBinding.getSuperclass();
                    }
                    if (needCast) {
                        for (Expression arg : args) {
                            if (arg != visited) continue;
                            CastExpression cast = ast.newCastExpression();
                            cast.setExpression(methodRef);
                            ITypeBinding argTypeBinding = arg.resolveTypeBinding();
                            if (argTypeBinding == null) {
                                return replacementNode;
                            }
                            ImportRewrite importRewriter = cuRewrite.getImportRewrite();
                            Type argType = importRewriter.addImport(argTypeBinding, ast);
                            cast.setType(argType);
                            replacementNode = cast;
                        }
                    }
                }
            }
            return replacementNode;
        }

        private static void collectInheritedTypes(ITypeBinding anonymType, Set<ITypeBinding> inheritedTypes) {
            if (anonymType != null) {
                ITypeBinding[] interfaces;
                ITypeBinding motherType = anonymType.getSuperclass();
                if (motherType != null) {
                    inheritedTypes.add(motherType);
                    CreateLambdaOperation.collectInheritedTypes(motherType, inheritedTypes);
                }
                if ((interfaces = anonymType.getInterfaces()) != null && interfaces.length > 0) {
                    Collections.addAll(inheritedTypes, interfaces);
                    ITypeBinding[] iTypeBindingArray = interfaces;
                    int n = interfaces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeBinding iTypeBinding = iTypeBindingArray[n2];
                        CreateLambdaOperation.collectInheritedTypes(iTypeBinding, inheritedTypes);
                        ++n2;
                    }
                }
            }
        }

        private HashSet<String> makeNamesUnique(HashSet<String> namesFromUpperScope, MethodDeclaration methodDeclaration, ASTRewrite rewrite, TextEditGroup group) {
            HashSet<String> newNames = new HashSet<String>();
            namesFromUpperScope.addAll(ASTNodes.getVisibleLocalVariablesInScope((ASTNode)methodDeclaration));
            List<SimpleName> simpleNamesInMethod = this.getNamesInMethod(methodDeclaration);
            ArrayList<String> namesInMethod = new ArrayList<String>();
            for (SimpleName name : simpleNamesInMethod) {
                namesInMethod.add(name.getIdentifier());
            }
            int i = 0;
            while (i < simpleNamesInMethod.size()) {
                SimpleName name = simpleNamesInMethod.get(i);
                String identifier = (String)namesInMethod.get(i);
                if (namesFromUpperScope.contains(identifier)) {
                    SimpleName[] references;
                    String newIdentifier = this.createName(identifier, namesFromUpperScope, namesInMethod, newNames);
                    namesFromUpperScope.add(newIdentifier);
                    newNames.add(newIdentifier);
                    SimpleName[] simpleNameArray = references = LinkedNodeFinder.findByNode(name.getRoot(), name);
                    int n = references.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SimpleName ref = simpleNameArray[n2];
                        rewrite.set((ASTNode)ref, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)newIdentifier, group);
                        ++n2;
                    }
                }
                ++i;
            }
            return newNames;
        }

        private List<SimpleName> getNamesInMethod(MethodDeclaration methodDeclaration) {
            class NamesCollector
            extends HierarchicalASTVisitor {
                private int fTypeCounter;
                private List<SimpleName> fNames = new ArrayList<SimpleName>();

                NamesCollector() {
                }

                @Override
                public boolean visit(AbstractTypeDeclaration node) {
                    if (this.fTypeCounter++ == 0) {
                        this.fNames.add(node.getName());
                    }
                    return true;
                }

                @Override
                public void endVisit(AbstractTypeDeclaration node) {
                    --this.fTypeCounter;
                }

                @Override
                public boolean visit(AnonymousClassDeclaration node) {
                    ++this.fTypeCounter;
                    return true;
                }

                @Override
                public void endVisit(AnonymousClassDeclaration node) {
                    --this.fTypeCounter;
                }

                @Override
                public boolean visit(VariableDeclaration node) {
                    if (this.fTypeCounter == 0) {
                        this.fNames.add(node.getName());
                    }
                    return true;
                }
            }
            NamesCollector namesCollector = new NamesCollector();
            methodDeclaration.accept((ASTVisitor)namesCollector);
            return namesCollector.fNames;
        }

        private String createName(String candidate, HashSet<String> excludedNames, List<String> namesInMethod, HashSet<String> newNames) {
            int i = 1;
            Object result = candidate;
            while (excludedNames.contains(result) || newNames.contains(result) || namesInMethod.contains(result)) {
                result = candidate + i++;
            }
            return result;
        }
    }

    public static final class FinalFieldAccessInFieldDeclarationFinder
    extends HierarchicalASTVisitor {
        private MethodDeclaration fMethodDeclaration;
        private ASTNode fFieldDeclaration;

        static boolean hasReference(MethodDeclaration node) {
            FinalFieldAccessInFieldDeclarationFinder finder;
            block3: {
                try {
                    finder = new FinalFieldAccessInFieldDeclarationFinder();
                    finder.fMethodDeclaration = node;
                    finder.fFieldDeclaration = finder.findFieldDeclaration((ASTNode)node);
                    if (finder.fFieldDeclaration != null) break block3;
                    return false;
                }
                catch (AbortSearchException e) {
                    return true;
                }
            }
            node.accept((ASTVisitor)finder);
            return false;
        }

        private ASTNode findFieldDeclaration(ASTNode node) {
            while (node != null) {
                if (node instanceof FieldDeclaration) {
                    return node;
                }
                if (node instanceof AbstractTypeDeclaration) {
                    return null;
                }
                node = node.getParent();
            }
            return null;
        }

        @Override
        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(BodyDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(MethodDeclaration node) {
            return node == this.fMethodDeclaration;
        }

        private void checkForUninitializedFinalReference(IBinding binding) {
            ASTNode decl;
            int modifiers;
            if (binding instanceof IVariableBinding && ((modifiers = binding.getModifiers()) & 0x10) == 16 && ((IVariableBinding)binding).isField() && (decl = ((CompilationUnit)this.fMethodDeclaration.getRoot()).findDeclaringNode(binding)) instanceof VariableDeclaration && ((VariableDeclaration)decl).getInitializer() == null) {
                throw new AbortSearchException();
            }
        }

        @Override
        public boolean visit(SuperFieldAccess node) {
            IVariableBinding binding = node.resolveFieldBinding();
            if (binding == null) {
                return true;
            }
            IVariableBinding decl = binding.getVariableDeclaration();
            this.checkForUninitializedFinalReference((IBinding)decl);
            return true;
        }

        @Override
        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            this.checkForUninitializedFinalReference(binding);
            return true;
        }

        @Override
        public boolean visit(QualifiedName node) {
            IBinding binding = node.resolveBinding();
            this.checkForUninitializedFinalReference(binding);
            return true;
        }

        @Override
        public boolean visit(FieldAccess node) {
            IVariableBinding binding = node.resolveFieldBinding();
            if (binding == null) {
                return true;
            }
            IVariableBinding decl = binding.getVariableDeclaration();
            this.checkForUninitializedFinalReference((IBinding)decl);
            return true;
        }
    }

    public static final class FunctionalAnonymousClassesFinder
    extends ASTVisitor {
        private final ArrayList<ClassInstanceCreation> fNodes = new ArrayList();

        public static ArrayList<ClassInstanceCreation> perform(ASTNode node) {
            FunctionalAnonymousClassesFinder finder = new FunctionalAnonymousClassesFinder();
            node.accept((ASTVisitor)finder);
            return finder.fNodes;
        }

        public boolean visit(ClassInstanceCreation node) {
            if (LambdaExpressionsFixCore.isFunctionalAnonymous(node) && !fConversionRemovesAnnotations) {
                this.fNodes.add(node);
            }
            return true;
        }
    }

    public static interface IAnonymousClassCreationOperation {
        public MethodDeclaration getMethodDeclaration(ICompilationUnit var1, ASTRewrite var2, ImportRewrite var3, ImportRewrite.ImportRewriteContext var4, IMethodBinding var5, String[] var6, ITypeBinding var7, boolean var8, ASTNode var9) throws CoreException;
    }

    public static final class LambdaExpressionsFinder
    extends ASTVisitor {
        private final ArrayList<LambdaExpression> fNodes = new ArrayList();

        public static ArrayList<LambdaExpression> perform(ASTNode node) {
            LambdaExpressionsFinder finder = new LambdaExpressionsFinder();
            node.accept((ASTVisitor)finder);
            return finder.fNodes;
        }

        public boolean visit(LambdaExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            if (typeBinding != null && typeBinding.getFunctionalInterfaceMethod() != null) {
                this.fNodes.add(node);
            }
            return true;
        }
    }

    private record MethodInvocationStatus(MethodRefStatus status, ITypeBinding classBinding) {
    }

    private static final class MethodRecursionFinder
    extends HierarchicalASTVisitor {
        private MethodDeclaration fMethodDeclaration;
        private IMethodBinding fMethodBinding;
        private ASTNode fFieldDeclaration;

        private MethodRecursionFinder() {
        }

        private static boolean isRecursiveLocal(MethodDeclaration node) {
            MethodRecursionFinder finder;
            block5: {
                block4: {
                    try {
                        finder = new MethodRecursionFinder();
                        finder.fMethodDeclaration = node;
                        finder.fFieldDeclaration = finder.findFieldDeclaration((ASTNode)node);
                        if (finder.fFieldDeclaration == null) break block4;
                        return false;
                    }
                    catch (AbortSearchException e) {
                        return true;
                    }
                }
                finder.fMethodBinding = finder.fMethodDeclaration.resolveBinding();
                if (finder.fMethodBinding != null) break block5;
                return false;
            }
            node.accept((ASTVisitor)finder);
            return false;
        }

        private ASTNode findFieldDeclaration(ASTNode node) {
            ASTNode originalNode = node;
            while (node != null) {
                if (node instanceof FieldDeclaration) {
                    return node;
                }
                if (node instanceof AbstractTypeDeclaration) {
                    return null;
                }
                if (node instanceof MethodDeclaration && node != originalNode) {
                    return null;
                }
                node = node.getParent();
            }
            return null;
        }

        @Override
        public boolean visit(MethodInvocation node) {
            IMethodBinding binding;
            if (node.getExpression() == null && (binding = node.resolveMethodBinding()) != null && binding.isEqualTo((IBinding)this.fMethodBinding)) {
                throw new AbortSearchException();
            }
            return true;
        }
    }

    private static enum MethodRefStatus {
        NO_REF,
        TYPE_REF,
        METHOD_REF;

    }

    public static final class SuperThisQualifier
    extends HierarchicalASTVisitor {
        private ITypeBinding fQualifierTypeBinding;
        private ImportRewrite fImportRewrite;
        private ASTRewrite fASTRewrite;
        private TextEditGroup fGroup;

        public static void perform(LambdaExpression lambdaExpression, ITypeBinding parentTypeBinding, CompilationUnitRewrite cuRewrite, TextEditGroup group) {
            SuperThisQualifier qualifier = new SuperThisQualifier();
            qualifier.fQualifierTypeBinding = parentTypeBinding;
            qualifier.fImportRewrite = cuRewrite.getImportRewrite();
            qualifier.fASTRewrite = cuRewrite.getASTRewrite();
            qualifier.fGroup = group;
            lambdaExpression.accept((ASTVisitor)qualifier);
        }

        public Name getQualifierTypeName() {
            String typeName = this.fImportRewrite.addImport(this.fQualifierTypeBinding);
            return this.fASTRewrite.getAST().newName(typeName);
        }

        @Override
        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(BodyDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(SuperFieldAccess node) {
            if (node.getQualifier() == null) {
                this.fASTRewrite.set((ASTNode)node, (StructuralPropertyDescriptor)SuperFieldAccess.QUALIFIER_PROPERTY, (Object)this.getQualifierTypeName(), this.fGroup);
            }
            return true;
        }

        @Override
        public boolean visit(SuperMethodInvocation node) {
            if (node.getQualifier() == null) {
                this.fASTRewrite.set((ASTNode)node, (StructuralPropertyDescriptor)SuperMethodInvocation.QUALIFIER_PROPERTY, (Object)this.getQualifierTypeName(), this.fGroup);
            }
            return true;
        }

        @Override
        public boolean visit(ThisExpression node) {
            if (node.getQualifier() == null) {
                this.fASTRewrite.set((ASTNode)node, (StructuralPropertyDescriptor)ThisExpression.QUALIFIER_PROPERTY, (Object)this.getQualifierTypeName(), this.fGroup);
            }
            return true;
        }
    }

    public static final class SuperThisReferenceFinder
    extends HierarchicalASTVisitor {
        private ITypeBinding fFunctionalInterface;
        private MethodDeclaration fMethodDeclaration;

        static boolean hasReference(MethodDeclaration node) {
            try {
                SuperThisReferenceFinder finder = new SuperThisReferenceFinder();
                ClassInstanceCreation cic = (ClassInstanceCreation)node.getParent().getParent();
                finder.fFunctionalInterface = cic.getType().resolveBinding();
                finder.fMethodDeclaration = node;
                node.accept((ASTVisitor)finder);
            }
            catch (AbortSearchException e) {
                return true;
            }
            return false;
        }

        @Override
        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(BodyDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(MethodDeclaration node) {
            return node == this.fMethodDeclaration;
        }

        @Override
        public boolean visit(ThisExpression node) {
            if (node.getQualifier() == null) {
                throw new AbortSearchException();
            }
            return true;
        }

        @Override
        public boolean visit(SuperMethodInvocation node) {
            if (node.getQualifier() == null) {
                throw new AbortSearchException();
            }
            IBinding qualifierType = node.getQualifier().resolveBinding();
            if (qualifierType instanceof ITypeBinding && ((ITypeBinding)qualifierType).isInterface()) {
                throw new AbortSearchException();
            }
            return true;
        }

        @Override
        public boolean visit(SuperFieldAccess node) {
            if (node.getQualifier() == null) {
                throw new AbortSearchException();
            }
            return true;
        }

        @Override
        public boolean visit(MethodInvocation node) {
            IMethodBinding binding = node.resolveMethodBinding();
            if (binding != null && !JdtFlags.isStatic(binding) && node.getExpression() == null && Bindings.isSuperType(binding.getDeclaringClass(), this.fFunctionalInterface, false)) {
                throw new AbortSearchException();
            }
            return true;
        }
    }
}

