/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.snapshot.TextFileSnapshotWs;
import org.eclipse.handly.snapshot.TextFileStoreSnapshot;

public final class TextFileBufferSnapshot
extends Snapshot {
    private static final ConcurrentMap<ITextFileBuffer, Collection<TextFileBufferSnapshot>> bufferSnapshots = new ConcurrentHashMap<ITextFileBuffer, Collection<TextFileBufferSnapshot>>();
    private static final IFileBufferListener bufferListener = new IFileBufferListener(){

        public void bufferCreated(IFileBuffer buffer) {
        }

        public void bufferDisposed(IFileBuffer buffer) {
            TextFileBufferSnapshot.onBufferDisposed((ITextFileBuffer)buffer);
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            TextFileBufferSnapshot.onBufferStateChanged((ITextFileBuffer)buffer, isDirty);
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }
    };
    private volatile Snapshot delegate;

    public TextFileBufferSnapshot(ITextFileBuffer buffer, ITextFileBufferManager bufferManager) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        if (bufferManager == null) {
            throw new IllegalArgumentException();
        }
        if (!buffer.isDirty() && buffer.isSynchronized()) {
            this.delegate = TextFileBufferSnapshot.getFileSnapshot(buffer);
        } else {
            this.delegate = new DocumentSnapshot(buffer.getDocument());
            TextFileBufferSnapshot.trackSnapshot(buffer, this);
            bufferManager.addFileBufferListener(bufferListener);
        }
    }

    @Override
    public String getContents() {
        Snapshot d = this.delegate;
        if (d == null) {
            return null;
        }
        return d.getContents();
    }

    @Override
    protected Boolean predictEquality(Snapshot other) {
        Snapshot d = this.delegate;
        if (d == null) {
            return false;
        }
        return other.predictEquality(d);
    }

    private boolean bufferSaved(Snapshot fileSnapshot) {
        Snapshot d = this.delegate;
        if (d == null || !d.isEqualTo(fileSnapshot)) {
            return false;
        }
        this.delegate = fileSnapshot;
        return true;
    }

    private void bufferDisposed() {
        this.delegate = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trackSnapshot(ITextFileBuffer buffer, TextFileBufferSnapshot snapshot) {
        Collection snapshots;
        Collection collection = snapshots = bufferSnapshots.computeIfAbsent(buffer, k -> Collections.newSetFromMap(new WeakHashMap()));
        synchronized (collection) {
            snapshots.add(snapshot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onBufferStateChanged(ITextFileBuffer buffer, boolean isDirty) {
        if (isDirty || !buffer.isSynchronized()) {
            return;
        }
        Collection snapshots = (Collection)bufferSnapshots.get(buffer);
        if (snapshots == null) {
            return;
        }
        Collection collection = snapshots;
        synchronized (collection) {
            if (snapshots.isEmpty()) {
                return;
            }
            Snapshot fileSnapshot = TextFileBufferSnapshot.getFileSnapshot(buffer);
            Iterator it = snapshots.iterator();
            while (it.hasNext()) {
                TextFileBufferSnapshot snapshot = (TextFileBufferSnapshot)it.next();
                if (!snapshot.bufferSaved(fileSnapshot)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onBufferDisposed(ITextFileBuffer buffer) {
        Collection snapshots = (Collection)bufferSnapshots.remove(buffer);
        if (snapshots == null) {
            return;
        }
        Collection collection = snapshots;
        synchronized (collection) {
            for (TextFileBufferSnapshot snapshot : snapshots) {
                snapshot.bufferDisposed();
            }
        }
    }

    private static Snapshot getFileSnapshot(ITextFileBuffer buffer) {
        IFile file = TextFileBufferSnapshot.getFile((IFileBuffer)buffer);
        if (file != null) {
            return new TextFileSnapshotWs(file);
        }
        return new TextFileStoreSnapshot(buffer.getFileStore(), Charset.forName(buffer.getEncoding()));
    }

    private static IFile getFile(IFileBuffer buffer) {
        if (buffer.computeCommitRule() != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(buffer.getLocation());
        }
        return null;
    }
}

