/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.SaveMode;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.refactoring.Messages;
import org.eclipse.handly.refactoring.UndoSourceFileChange;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;

public class SourceFileChange
extends TextEditBasedChange {
    private static final TextEditBasedChangeGroup[] ALL_EDITS = new TextEditBasedChangeGroup[0];
    private ISourceFile sourceFile;
    private TextEdit edit;
    private ISnapshot base;
    private SaveMode saveMode = SaveMode.KEEP_SAVED_STATE;
    private TextEditCopier copier;

    public SourceFileChange(String name, ISourceFile sourceFile) {
        this(name, sourceFile, (TextEdit)new MultiTextEdit());
    }

    public SourceFileChange(String name, ISourceFile sourceFile, TextEdit edit) {
        super(name);
        this.sourceFile = sourceFile;
        if (this.sourceFile == null) {
            throw new IllegalArgumentException();
        }
        this.edit = edit;
        if (this.edit == null) {
            throw new IllegalArgumentException();
        }
        String fileName = Elements.getName(sourceFile);
        if (fileName != null) {
            this.setTextType(new Path(fileName).getFileExtension());
        }
    }

    public TextEdit getEdit() {
        return this.edit;
    }

    public void addEdit(TextEdit edit) {
        SourceFileChange.insert(this.edit, edit);
    }

    public void addEdits(TextEdit[] edits) {
        TextEdit[] textEditArray = edits;
        int n = edits.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit edit = textEditArray[n2];
            this.addEdit(edit);
            ++n2;
        }
    }

    public void addGroupedEdits(TextEditBasedChangeGroup group) {
        this.addEdits(group.getTextEdits());
        this.addChangeGroup(group);
    }

    public void addGroupedEdits(TextEditGroup group) {
        this.addEdits(group.getTextEdits());
        this.addTextEditGroup(group);
    }

    public void setBase(ISnapshot base) {
        this.base = base;
    }

    public ISnapshot getBase() {
        return this.base;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.base == null) {
            return result;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (IBuffer buffer = Elements.getBuffer(this.sourceFile, Contexts.EMPTY_CONTEXT, pm);){
            if (!this.base.isEqualTo(buffer.getSnapshot())) {
                result.addFatalError(MessageFormat.format(Messages.SourceFileChange_Cannot_apply_stale_change__0, Elements.toDisplayString(this.sourceFile, Contexts.EMPTY_CONTEXT)));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IBuffer buffer = Elements.getBuffer(this.sourceFile, Contexts.EMPTY_CONTEXT, (IProgressMonitor)subMonitor.split(1));){
            IBufferChange undoChange;
            BufferChangeWithExcludes change = new BufferChangeWithExcludes(this.edit);
            change.setExcludes(this.getDisabledEdits());
            change.setBase(this.base);
            change.setStyle(3);
            change.setSaveMode(this.saveMode);
            try {
                undoChange = buffer.applyChange(change, (IProgressMonitor)subMonitor.split(1, 10));
            }
            catch (StaleSnapshotException e) {
                throw new CoreException(Activator.createErrorStatus(MessageFormat.format(Messages.SourceFileChange_Cannot_apply_stale_change__0, Elements.toDisplayString(this.sourceFile, Contexts.EMPTY_CONTEXT)), e));
            }
            return new UndoSourceFileChange(this.getName(), this.sourceFile, undoChange);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Object getModifiedElement() {
        return this.sourceFile;
    }

    public Object[] getAffectedObjects() {
        IFile file = Elements.getFile(this.sourceFile);
        if (file == null) {
            return null;
        }
        return new Object[]{file};
    }

    public String getCurrentContent(IProgressMonitor pm) throws CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IBuffer buffer = Elements.getBuffer(this.sourceFile, Contexts.EMPTY_CONTEXT, pm);){
            return buffer.getDocument().get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getCurrentContent(IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        if (region == null) {
            throw new IllegalArgumentException();
        }
        if (expandRegionToFullLine && surroundingLines < 0) {
            throw new IllegalArgumentException();
        }
        String content = this.getCurrentContent(pm);
        if (content.length() < region.getOffset() + region.getLength()) {
            throw new IllegalArgumentException();
        }
        return this.getDocumentContent((IDocument)new Document(content), region, expandRegionToFullLine, surroundingLines);
    }

    public String getPreviewContent(IProgressMonitor pm) throws CoreException {
        return this.getPreviewDocument(pm).get();
    }

    public String getPreviewContent(TextEditBasedChangeGroup[] changeGroups, IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        IRegion changeRegion = this.getRegion(changeGroups);
        if (region.getOffset() > changeRegion.getOffset() || region.getOffset() + region.getLength() < changeRegion.getOffset() + changeRegion.getLength()) {
            throw new IllegalArgumentException();
        }
        TextEdit root = this.getEdit();
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = changeGroups;
        int n = changeGroups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit[] edits;
            TextEditBasedChangeGroup group = textEditBasedChangeGroupArray[n2];
            TextEdit[] textEditArray = edits = group.getTextEdits();
            int n3 = edits.length;
            int n4 = 0;
            while (n4 < n3) {
                TextEdit edit = textEditArray[n4];
                if (root != edit.getRoot()) {
                    throw new IllegalArgumentException();
                }
                ++n4;
            }
            ++n2;
        }
        Preview preview = this.getPreview(changeGroups, pm);
        int delta = preview.changeRegion == null ? -changeRegion.getLength() : preview.changeRegion.getLength() - changeRegion.getLength();
        return this.getDocumentContent(preview.document, (IRegion)new Region(region.getOffset(), region.getLength() + delta), expandRegionToFullLine, surroundingLines);
    }

    public void setKeepPreviewEdits(boolean keep) {
        super.setKeepPreviewEdits(keep);
        if (!keep) {
            this.copier = null;
        }
    }

    public TextEdit getPreviewEdit(TextEdit original) {
        if (!this.getKeepPreviewEdits() || this.copier == null) {
            throw new IllegalStateException();
        }
        return this.copier.getCopy(original);
    }

    public TextEdit[] getPreviewEdits(TextEdit[] originals) {
        if (!this.getKeepPreviewEdits() || this.copier == null) {
            throw new IllegalStateException();
        }
        if (originals == null || originals.length == 0) {
            return new TextEdit[0];
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(originals.length);
        TextEdit[] textEditArray = originals;
        int n = originals.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit original = textEditArray[n2];
            TextEdit copy = this.copier.getCopy(original);
            if (copy != null) {
                result.add(copy);
            }
            ++n2;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    public IDocument getPreviewDocument(IProgressMonitor pm) throws CoreException {
        return this.getPreview((TextEditBasedChangeGroup[])SourceFileChange.ALL_EDITS, (IProgressMonitor)pm).document;
    }

    private static void insert(TextEdit parent, TextEdit edit) {
        if (edit == null) {
            throw new IllegalArgumentException();
        }
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            return;
        }
        TextEdit[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            TextEdit child = children[i];
            if (SourceFileChange.covers(child, edit)) {
                SourceFileChange.insert(child, edit);
                return;
            }
            ++i;
        }
        int removed = 0;
        int i2 = 0;
        while (i2 < children.length) {
            TextEdit child = children[i2];
            if (SourceFileChange.covers(edit, child)) {
                parent.removeChild(i2 - removed++);
                edit.addChild(child);
            }
            ++i2;
        }
        parent.addChild(edit);
    }

    private static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset < otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDocumentContent(IDocument document, IRegion region, boolean expandRegionToFullLine, int surroundingLines) throws CoreException {
        try {
            int endLine;
            if (!expandRegionToFullLine) {
                return document.get(region.getOffset(), region.getLength());
            }
            int startLine = Math.max(document.getLineOfOffset(region.getOffset()) - surroundingLines, 0);
            if (region.getLength() == 0) {
                if (surroundingLines == 0) {
                    return "";
                }
                endLine = Math.min(document.getLineOfOffset(region.getOffset()) + surroundingLines - 1, document.getNumberOfLines() - 1);
            } else {
                endLine = Math.min(document.getLineOfOffset(region.getOffset() + region.getLength() - 1) + surroundingLines, document.getNumberOfLines() - 1);
            }
            int offset = document.getLineInformation(startLine).getOffset();
            IRegion endLineRegion = document.getLineInformation(endLine);
            int length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
            return document.get(offset, length);
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    private Collection<TextEdit> getDisabledEdits() {
        return Edits.DISABLED.of(this.getChangeGroups());
    }

    private Preview getPreview(TextEditBasedChangeGroup[] groups, IProgressMonitor pm) throws CoreException {
        Document document = new Document(this.getCurrentContent(pm));
        this.copier = new TextEditCopier(this.edit);
        try {
            this.createPreviewEditProcessor((IDocument)document, groups).performEdits();
            Preview preview = new Preview((IDocument)document, this.getNewRegion(groups));
            return preview;
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        finally {
            if (!this.getKeepPreviewEdits()) {
                this.copier = null;
            }
        }
    }

    private TextEditProcessor createPreviewEditProcessor(IDocument document, TextEditBasedChangeGroup[] groups) {
        TextEdit copiedEdit = this.copier.perform();
        PreviewEditProcessor result = new PreviewEditProcessor(document, copiedEdit, this.getKeepPreviewEdits() ? 2 : 0);
        if (groups == ALL_EDITS) {
            result.setExcludes(this.mapEdits(this.getDisabledEdits()));
        } else {
            result.setIncludes(this.mapEdits(Edits.ENABLED.of(groups)));
        }
        return result;
    }

    private IRegion getRegion(TextEditBasedChangeGroup[] groups) {
        if (groups == ALL_EDITS) {
            return this.edit.getRegion();
        }
        Collection<TextEdit> edits = Edits.ALL.of(groups);
        if (edits.isEmpty()) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])edits.toArray(new TextEdit[edits.size()]));
    }

    private IRegion getNewRegion(TextEditBasedChangeGroup[] groups) {
        if (groups == ALL_EDITS) {
            return this.copier.getCopy(this.edit).getRegion();
        }
        Collection<TextEdit> previewEdits = this.mapEdits(Edits.ALL.of(groups));
        if (previewEdits.isEmpty()) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])previewEdits.toArray(new TextEdit[previewEdits.size()]));
    }

    private Collection<TextEdit> mapEdits(Collection<TextEdit> edits) {
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(edits.size());
        for (TextEdit edit : edits) {
            TextEdit copy = this.copier.getCopy(edit);
            if (copy == null) continue;
            result.add(copy);
        }
        return result;
    }

    private static Set<TextEdit> flatten(Collection<TextEdit> edits) {
        HashSet<TextEdit> result = new HashSet<TextEdit>();
        for (TextEdit edit : edits) {
            SourceFileChange.flatten(edit, result);
        }
        return result;
    }

    private static void flatten(TextEdit edit, Set<TextEdit> result) {
        TextEdit[] children;
        result.add(edit);
        TextEdit[] textEditArray = children = edit.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit child = textEditArray[n2];
            SourceFileChange.flatten(child, result);
            ++n2;
        }
    }

    private static class BufferChangeWithExcludes
    extends BufferChange {
        private Set<TextEdit> excludes;

        public BufferChangeWithExcludes(TextEdit edit) {
            super(edit);
        }

        public void setExcludes(Collection<TextEdit> excludes) {
            if (excludes == null) {
                throw new IllegalArgumentException();
            }
            this.excludes = SourceFileChange.flatten(excludes);
        }

        @Override
        public boolean contains(TextEdit edit) {
            if (!super.contains(edit)) {
                return false;
            }
            return this.excludes == null || !this.excludes.contains(edit);
        }
    }

    private static enum Edits {
        ENABLED,
        DISABLED,
        ALL;


        public Collection<TextEdit> of(TextEditBasedChangeGroup[] groups) {
            HashSet<TextEdit> result = new HashSet<TextEdit>();
            TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                TextEditBasedChangeGroup group = textEditBasedChangeGroupArray[n2];
                if (this == ALL || this == DISABLED ^ group.isEnabled()) {
                    result.addAll(Arrays.asList(group.getTextEdits()));
                }
                ++n2;
            }
            return result;
        }
    }

    private static class Preview {
        public final IDocument document;
        public final IRegion changeRegion;

        public Preview(IDocument document, IRegion changeRegion) {
            this.document = document;
            this.changeRegion = changeRegion;
        }
    }

    private static class PreviewEditProcessor
    extends TextEditProcessor {
        private Set<TextEdit> excludes;
        private Set<TextEdit> includes;

        public PreviewEditProcessor(IDocument document, TextEdit root, int flags) {
            super(document, root, flags);
        }

        public void setIncludes(Collection<TextEdit> includes) {
            if (includes == null) {
                throw new IllegalArgumentException();
            }
            if (this.excludes != null) {
                throw new IllegalStateException();
            }
            this.includes = SourceFileChange.flatten(includes);
        }

        public void setExcludes(Collection<TextEdit> excludes) {
            if (excludes == null) {
                throw new IllegalArgumentException();
            }
            if (this.includes != null) {
                throw new IllegalStateException();
            }
            this.excludes = SourceFileChange.flatten(excludes);
        }

        protected boolean considerEdit(TextEdit edit) {
            if (this.excludes != null && this.excludes.contains(edit)) {
                return false;
            }
            return this.includes == null || this.includes.contains(edit);
        }
    }
}

