/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.context.Context;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.impl.IReconcileStrategy;
import org.eclipse.handly.model.impl.support.ISourceFileImplSupport;
import org.eclipse.handly.model.impl.support.WorkingCopyInfo;
import org.eclipse.handly.snapshot.ISnapshot;

class ReconcileStrategy
implements IReconcileStrategy {
    private final ISourceFileImplSupport sourceFile;

    ReconcileStrategy(ISourceFileImplSupport sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException();
        }
        this.sourceFile = sourceFile;
    }

    @Override
    public void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
        if (context.get(SOURCE_AST) == null && context.get(SOURCE_CONTENTS) == null) {
            throw new IllegalArgumentException();
        }
        Context context2 = new Context();
        WorkingCopyInfo info = this.sourceFile.getElementManager_().peekAtWorkingCopyInfo(this.sourceFile);
        context2.bind(ISourceFileImplSupport.ReconcileOperation.INITIAL_RECONCILE).to(!info.created);
        context2.bind(ISourceFileImplSupport.ReconcileOperation.RECONCILING_FORCED).to((Boolean)context.getOrDefault(RECONCILING_FORCED));
        if (context.containsKey(SOURCE_AST)) {
            context2.bind(ISourceFileImplSupport.SOURCE_AST).to(context.get(SOURCE_AST));
        }
        if (context.containsKey(SOURCE_CONTENTS)) {
            context2.bind(ISourceFileImplSupport.SOURCE_CONTENTS).to((String)context.get(SOURCE_CONTENTS));
        }
        if (context.containsKey(SOURCE_SNAPSHOT)) {
            context2.bind(ISourceFileImplSupport.SOURCE_SNAPSHOT).to((ISnapshot)context.get(SOURCE_SNAPSHOT));
        }
        this.sourceFile.getReconcileOperation_().reconcile(Contexts.with(context2, context), monitor);
    }
}

