/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.callhierarchy;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyNode;
import org.eclipse.handly.ui.callhierarchy.CallLocation;
import org.eclipse.handly.ui.callhierarchy.ICallHierarchyNode;
import org.eclipse.handly.ui.callhierarchy.ICallLocation;
import org.eclipse.handly.xtext.ui.callhierarchy.XtextCallHierarchyUtility;
import org.eclipse.xtext.resource.IReferenceDescription;

public abstract class XtextCallHierarchyNode
extends CallHierarchyNode {
    private static final XtextCallHierarchyNode[] EMPTY_ARRAY = new XtextCallHierarchyNode[0];

    protected XtextCallHierarchyNode(XtextCallHierarchyNode parent, Object element) {
        super((ICallHierarchyNode)parent, element);
    }

    protected ICallHierarchyNode[] computeChildren(IProgressMonitor monitor) {
        LinkedHashMap children = new LinkedHashMap();
        this.findCallReferences(callReference -> {
            XtextCallHierarchyNode child = this.createChildIfAbsent(children, (IReferenceDescription)callReference);
            if (child != null) {
                Object callee;
                Object caller;
                switch (this.getKind()) {
                    case CALLER: {
                        caller = child.getElement();
                        callee = this.getElement();
                        break;
                    }
                    case CALLEE: {
                        caller = this.getElement();
                        callee = child.getElement();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                child.addCallLocation(this.createCallLocation(caller, callee, (IReferenceDescription)callReference));
            }
        }, monitor);
        return (ICallHierarchyNode[])children.values().toArray(EMPTY_ARRAY);
    }

    protected void findCallReferences(Consumer<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        switch (this.getKind()) {
            case CALLER: {
                this.getCallHierarchyUtility().findCallerReferences(this.getUri(), acceptor, monitor);
                break;
            }
            case CALLEE: {
                this.getCallHierarchyUtility().findCalleeReferences(this.getUri(), acceptor, monitor);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    protected ICallLocation createCallLocation(Object caller, Object callee, IReferenceDescription callReference) {
        return new CallLocation(caller, callee, this.getCallHierarchyUtility().getCallTextInfo(callReference));
    }

    protected abstract URI getUri();

    protected abstract XtextCallHierarchyNode createChildIfAbsent(Map<URI, XtextCallHierarchyNode> var1, IReferenceDescription var2);

    protected abstract XtextCallHierarchyUtility getCallHierarchyUtility();
}

