/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.BreakFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ContinueFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ElifFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.IfFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.WhileFuncStatement;
import org.eclipse.escet.cif.metamodel.java.CifWithArgWalker;
import org.eclipse.escet.common.java.DependencyOrderer;
import org.eclipse.escet.common.java.Sets;

public class CifInternalFuncUtils {
    private CifInternalFuncUtils() {
    }

    public static Set<DiscVariable> getAssignedParameters(InternalFunction func) {
        FunctionStatement stat;
        Set parameters = Sets.setc((int)func.getParameters().size());
        ArrayDeque notDone = new ArrayDeque();
        notDone.addAll(func.getStatements());
        while ((stat = (FunctionStatement)notDone.poll()) != null) {
            IfFuncStatement s;
            if (stat instanceof BreakFuncStatement || stat instanceof ContinueFuncStatement || stat instanceof ReturnFuncStatement) continue;
            if (stat instanceof IfFuncStatement) {
                s = (IfFuncStatement)stat;
                notDone.addAll(s.getThens());
                notDone.addAll(s.getElses());
                for (ElifFuncStatement es : s.getElifs()) {
                    notDone.addAll(es.getThens());
                }
                continue;
            }
            if (stat instanceof WhileFuncStatement) {
                s = (WhileFuncStatement)stat;
                notDone.addAll(s.getStatements());
                continue;
            }
            if (stat instanceof AssignmentFuncStatement) {
                s = (AssignmentFuncStatement)stat;
                CifInternalFuncUtils.getAssignedParameters((AssignmentFuncStatement)s, parameters);
                continue;
            }
            throw new RuntimeException("Unexpected/unsupported function statement: " + String.valueOf(stat));
        }
        return parameters;
    }

    private static void getAssignedParameters(AssignmentFuncStatement asg, Set<DiscVariable> parameters) {
        Expression lhs;
        ArrayDeque<Expression> notDone = new ArrayDeque<Expression>();
        notDone.add(asg.getAddressable());
        while ((lhs = (Expression)notDone.poll()) != null) {
            if (lhs instanceof ProjectionExpression) {
                ProjectionExpression pe = (ProjectionExpression)lhs;
                notDone.add(pe.getChild());
                continue;
            }
            if (lhs instanceof TupleExpression) {
                TupleExpression te = (TupleExpression)lhs;
                notDone.addAll((Collection<Expression>)te.getFields());
                continue;
            }
            if (lhs instanceof DiscVariableExpression) {
                DiscVariableExpression ve = (DiscVariableExpression)lhs;
                DiscVariable var = ve.getVariable();
                EObject parent = var.eContainer();
                if (!(parent instanceof FunctionParameter)) continue;
                parameters.add(var);
                continue;
            }
            throw new RuntimeException("Unexpected/unsupported LHS expression: " + String.valueOf(lhs));
        }
    }

    public static boolean isFuncParam(DiscVariable discVar) {
        return discVar.eContainer() instanceof FunctionParameter;
    }

    public static boolean isFuncLocalVar(DiscVariable discVar) {
        return discVar.eContainer() instanceof InternalFunction;
    }

    public static boolean isFuncParamOrLocalVar(DiscVariable discVar) {
        return CifInternalFuncUtils.isFuncParam(discVar) || CifInternalFuncUtils.isFuncLocalVar(discVar);
    }

    public static class CollectInternalFunctionsUsage
    extends CifWithArgWalker<Set<InternalFunction>> {
        public Set<InternalFunction> findInternalFunctionUsage(InternalFunction intFunc) {
            Set collected = Sets.set();
            this.walkInternalFunction(intFunc, collected);
            return collected;
        }

        protected void preprocessFunctionExpression(FunctionExpression funcExpr, Set<InternalFunction> collected) {
            Function function = funcExpr.getFunction();
            if (function instanceof InternalFunction) {
                InternalFunction intFunction = (InternalFunction)function;
                collected.add(intFunction);
            }
        }
    }

    public static class OrderInternalFunctions
    extends DependencyOrderer<InternalFunction> {
        private CollectInternalFunctionsUsage collector = new CollectInternalFunctionsUsage();

        protected Set<InternalFunction> findDirectDependencies(InternalFunction intFunc) {
            return this.collector.findInternalFunctionUsage(intFunc);
        }
    }
}

