/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.svg.selector;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.batik.gvt.GraphicsNode;
import org.eclipse.escet.common.eclipse.ui.G2dSwtPainter;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.svg.SvgCanvas;
import org.eclipse.escet.common.svg.SvgUtils;
import org.eclipse.escet.common.svg.selector.MouseEventType;
import org.eclipse.escet.common.svg.selector.MouseEventWrapper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;

public class SvgSelector
implements MouseListener,
MouseMoveListener,
G2dSwtPainter {
    private static final boolean DEBUG = false;
    protected final SvgCanvas canvas;
    public final Queue<Pair<SvgSelector, String>> idQueue;
    private final Set<String> interactiveIds;
    private final Queue<MouseEventWrapper> mouseEventQueue = new ConcurrentLinkedQueue<MouseEventWrapper>();
    private GraphicsNode hoverNode = null;
    private String hoverId = null;
    private Shape hoverShape = null;
    private AffineTransform hoverTransform = null;
    private boolean mouseDown = false;
    private int lastX = Integer.MIN_VALUE;
    private int lastY = Integer.MIN_VALUE;
    protected Cursor hoverCursor;
    protected Cursor curCursor;

    public SvgSelector(SvgCanvas canvas, Set<String> interactiveIds) {
        this(canvas, interactiveIds, new ConcurrentLinkedQueue<Pair<SvgSelector, String>>());
    }

    public SvgSelector(final SvgCanvas canvas, Set<String> interactiveIds, Queue<Pair<SvgSelector, String>> idQueue) {
        this.canvas = canvas;
        this.idQueue = idQueue;
        this.interactiveIds = interactiveIds;
        Assert.check((boolean)(idQueue instanceof ConcurrentLinkedQueue));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (canvas.isDisposed()) {
                    return;
                }
                Display display = Display.getDefault();
                SvgSelector.this.hoverCursor = display.getSystemCursor(21);
                SvgSelector.this.curCursor = canvas.getCursor();
                canvas.addMouseListener(SvgSelector.this);
                canvas.addMouseMoveListener(SvgSelector.this);
                canvas.addPainter(SvgSelector.this);
            }
        });
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.mouseEventQueue.add(new MouseEventWrapper(e, MouseEventType.DOWN));
    }

    public void mouseUp(MouseEvent e) {
        this.mouseEventQueue.add(new MouseEventWrapper(e, MouseEventType.UP));
    }

    public void mouseMove(MouseEvent e) {
        this.mouseEventQueue.add(new MouseEventWrapper(e, MouseEventType.MOVE));
    }

    public void processQueue(boolean svgChanged) {
        Cursor newCursor;
        MouseEventWrapper event;
        boolean hoverInfoUpToDate = false;
        boolean hoverShapeUpToDate = false;
        while ((event = this.mouseEventQueue.poll()) != null) {
            int x = event.event.x;
            int y = event.event.y;
            this.updateHoverInfo(x, y);
            switch (event.type) {
                case DOWN: {
                    this.mouseDown = true;
                    this.updateQueue();
                    hoverShapeUpToDate = false;
                    break;
                }
                case UP: {
                    this.updateHoverShape();
                    hoverShapeUpToDate = true;
                    this.mouseDown = false;
                    break;
                }
                case MOVE: {
                    if (this.mouseDown) break;
                    this.updateHoverShape();
                    hoverShapeUpToDate = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected event: " + String.valueOf(event));
                }
            }
            this.lastX = x;
            this.lastY = y;
        }
        if (svgChanged && !this.mouseDown && !hoverShapeUpToDate) {
            if (!hoverInfoUpToDate) {
                this.updateHoverInfo(this.lastX, this.lastY);
            }
            this.updateHoverShape();
        }
        Cursor cursor = newCursor = this.hoverShape == null ? null : this.hoverCursor;
        if (newCursor != this.curCursor) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SvgSelector.this.canvas.isDisposed()) {
                        return;
                    }
                    SvgSelector.this.canvas.setCursor(newCursor);
                    SvgSelector.this.curCursor = newCursor;
                }
            });
        }
    }

    private void updateHoverInfo(int x, int y) {
        GraphicsNode node = null;
        Element elem = null;
        String id = null;
        node = this.canvas.getGraphicsNode().nodeHitAt((Point2D)new Point2D.Double(x, y));
        while (node != null) {
            elem = this.canvas.getBridgeContext().getElement(node);
            if (elem != null && (id = SvgUtils.getSvgElementId(elem)) != null && this.interactiveIds.contains(id)) break;
            node = node.getParent();
        }
        if (node != null && elem != null && id != null) {
            this.hoverNode = node;
            this.hoverId = id;
        } else {
            this.hoverNode = null;
            this.hoverId = null;
        }
    }

    private void updateHoverShape() {
        if (this.hoverNode == null) {
            this.hoverShape = null;
            this.hoverTransform = null;
        } else {
            this.hoverShape = this.hoverNode.getOutline();
            this.hoverTransform = this.hoverNode.getGlobalTransform();
        }
    }

    private void updateQueue() {
        if (this.hoverNode == null) {
            return;
        }
        this.idQueue.add((Pair<SvgSelector, String>)Pair.pair((Object)this, (Object)this.hoverId));
    }

    public void paint(Graphics2D g, int w, int h) {
        if (this.hoverShape != null) {
            g.setColor(this.mouseDown ? Color.green : Color.RED);
            g.transform(this.hoverTransform);
            g.setStroke(new BasicStroke(1.0f));
            g.draw(this.hoverShape);
        }
    }

    private void debug(String txt) {
        System.out.println(this.getClass().getSimpleName() + ": " + txt);
    }
}

