/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AlgVarCodeGenerator {
    private AlgVarCodeGenerator() {
    }

    public static void gencodeAlgVars(CifCompilerContext ctxt) {
        List<AlgVariable> variables = ctxt.getAlgVars();
        JavaCodeFile file = ctxt.addCodeFile("AlgVars");
        CodeBox h = file.header;
        h.add("/** Algebraic variables. */");
        h.add("public final class AlgVars {");
        CodeBox c = file.body;
        c.add("public static String[] ALG_VAR_NAMES = {");
        c.indent();
        for (AlgVariable var : variables) {
            c.add("\"%s\",", new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        }
        c.dedent();
        c.add("};");
        for (AlgVariable var : variables) {
            c.add();
            c.add("public static %s %s(State state) {", new Object[]{TypeCodeGenerator.gencodeType(var.getType(), ctxt), ctxt.getAlgVarMethodName(var)});
            c.indent();
            c.add("try {");
            c.indent();
            boolean found = false;
            List varResults = Lists.list();
            if (var.getValue() != null) {
                ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(var.getValue(), ctxt, "state");
                c.add("return %s;", new Object[]{result});
                varResults.add(result);
                found = true;
            }
            if (!found) {
                ComplexComponent comp = (ComplexComponent)var.eContainer();
                for (Equation eq : comp.getEquations()) {
                    if (eq.getVariable() != var) continue;
                    ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(eq.getValue(), ctxt, "state");
                    c.add("return %s;", new Object[]{result});
                    varResults.add(result);
                    found = true;
                    break;
                }
            }
            if (!found) {
                varResults.addAll(AlgVarCodeGenerator.gencodeAlgVarsPerLoc(var, ctxt, c));
            }
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of algebraic variable \\\"%s\\\" failed.\", e, state);", new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
            for (ExprCodeGeneratorResult varResult : varResults) {
                varResult.addExtraMethods(c);
            }
        }
    }

    private static List<ExprCodeGeneratorResult> gencodeAlgVarsPerLoc(AlgVariable var, CifCompilerContext ctxt, CodeBox c) {
        Automaton aut = (Automaton)var.eContainer();
        c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.indent();
        EList locs = aut.getLocations();
        List varResults = Lists.list();
        int locIdx = 0;
        while (locIdx < locs.size()) {
            Location loc = (Location)locs.get(locIdx);
            boolean found = false;
            for (Equation eq : loc.getEquations()) {
                if (eq.getVariable() != var) continue;
                ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(eq.getValue(), ctxt, "state");
                c.add("case %s: return %s;", new Object[]{ctxt.getLocationValueText(loc, locIdx), result});
                varResults.add(result);
                found = true;
                break;
            }
            Assert.check((boolean)found);
            ++locIdx;
        }
        c.add("default: throw new RuntimeException(\"Invalid lp value: \" + state.%s.%s);", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.dedent();
        c.add("}");
        return varResults;
    }
}

