/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.runtime;

import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class CodePointBuffer {
    private int[] buffer;
    private int count = 0;
    private int head = 0;
    private int tail = 0;
    private int position = 0;

    public CodePointBuffer() {
        this(1024);
    }

    public CodePointBuffer(int bufferSize) {
        this.buffer = new int[bufferSize];
    }

    private void doubleBufferSize() {
        int newSize = this.buffer.length * 2;
        Assert.check((newSize >= 0 ? 1 : 0) != 0);
        int[] newBuffer = new int[newSize];
        if (this.head <= this.tail) {
            System.arraycopy(this.buffer, this.head, newBuffer, this.head, this.count);
        } else {
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.tail);
            System.arraycopy(this.buffer, this.head, newBuffer, this.head + this.buffer.length, this.buffer.length - this.head);
            this.head += this.buffer.length;
        }
        this.buffer = newBuffer;
    }

    public void add(int codePoint) {
        int next = this.tail + 1;
        if (next == this.buffer.length) {
            next = 0;
        }
        if (next != this.head) {
            this.buffer[this.tail] = codePoint;
            this.tail = next;
        } else {
            this.doubleBufferSize();
            this.buffer[this.tail] = codePoint;
            ++this.tail;
        }
        ++this.count;
    }

    private int normalizeIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0");
        }
        if (index >= this.count) {
            throw new IndexOutOfBoundsException("index >= count");
        }
        int rslt = this.head + index;
        Assert.check((rslt >= 0 ? 1 : 0) != 0);
        if (rslt >= this.buffer.length) {
            rslt -= this.buffer.length;
        }
        return rslt;
    }

    public boolean canRead() {
        return this.position != this.count;
    }

    public int read() {
        if (!this.canRead()) {
            String msg = "Insufficient data in the buffer.";
            throw new IllegalStateException(msg);
        }
        int index = this.normalizeIndex(this.position);
        int rslt = this.buffer[index];
        ++this.position;
        return rslt;
    }

    public void unread(int amount) {
        Assert.check((amount >= 0 ? 1 : 0) != 0);
        if (this.position < amount) {
            String msg = "Insufficient data in the buffer.";
            throw new IllegalArgumentException(msg);
        }
        this.position -= amount;
    }

    public boolean peekEndOfFile() {
        if (1 > this.count) {
            String msg = "Insufficient data in the buffer.";
            throw new IllegalArgumentException(msg);
        }
        if (this.position < 1) {
            String msg = "Peeking beyond current buffer position.";
            throw new IllegalStateException(msg);
        }
        return this.buffer[this.head] == -1;
    }

    public String pollPrefix(int length) {
        StringBuilder rslt;
        if (length > this.count) {
            String msg = "Insufficient data in the buffer.";
            throw new IllegalArgumentException(msg);
        }
        if (this.position < length) {
            String msg = "Polling beyond current buffer position.";
            throw new IllegalStateException(msg);
        }
        if (length == 1 && this.buffer[this.head] == -1) {
            rslt = null;
        } else {
            rslt = new StringBuilder(length);
            int index = this.head;
            int i = 0;
            while (i < length) {
                int codePoint = this.buffer[index];
                if (codePoint == -1) {
                    String msg = "Illegal polling of end-of-file with other code points.";
                    throw new IllegalStateException(msg);
                }
                rslt.append(Strings.codePointToStr((int)codePoint));
                if (++index == this.buffer.length) {
                    index = 0;
                }
                ++i;
            }
        }
        this.head += length;
        Assert.check((this.head >= 0 ? 1 : 0) != 0);
        this.head %= this.buffer.length;
        this.count -= length;
        this.position -= length;
        return rslt == null ? null : rslt.toString();
    }

    public Character removePrefix(int length) {
        int rslt;
        if (length > this.count) {
            String msg = "Insufficient data in the buffer.";
            throw new IllegalArgumentException(msg);
        }
        if (this.position < length) {
            String msg = "Removing beyond current buffer position.";
            throw new IllegalStateException(msg);
        }
        if (length == 1 && this.buffer[this.head] == -1) {
            rslt = -1;
        } else {
            int index = this.head;
            rslt = -1;
            int i = 0;
            while (i < length) {
                int codePoint = this.buffer[index];
                if (codePoint == -1) {
                    String msg = "Illegal removing of end-of-file with other code points.";
                    throw new IllegalStateException(msg);
                }
                rslt = codePoint;
                if (++index == this.buffer.length) {
                    index = 0;
                }
                ++i;
            }
        }
        this.head += length;
        Assert.check((this.head >= 0 ? 1 : 0) != 0);
        this.head %= this.buffer.length;
        this.count -= length;
        this.position -= length;
        return rslt == -1 ? null : Character.valueOf((char)rslt);
    }
}

