/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.query;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryableUpdates
implements IQueryable<IInstallableUnit> {
    private IInstallableUnit[] iusToUpdate;
    ProvisioningUI ui;

    public QueryableUpdates(ProvisioningUI ui, IInstallableUnit[] iusToUpdate) {
        this.ui = ui;
        this.iusToUpdate = iusToUpdate;
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int totalWork = 2000;
        monitor.beginTask(ProvUIMessages.QueryableUpdates_UpdateListProgress, totalWork);
        IPlanner planner = (IPlanner)this.ui.getSession().getProvisioningAgent().getService(IPlanner.SERVICE_NAME);
        try {
            HashSet allUpdates = new HashSet();
            int i = 0;
            while (i < this.iusToUpdate.length) {
                if (monitor.isCanceled()) {
                    Collector collector = Collector.emptyCollector();
                    return collector;
                }
                IQueryResult updates = planner.updatesFor(this.iusToUpdate[i], new ProvisioningContext(this.ui.getSession().getProvisioningAgent()), (IProgressMonitor)new SubProgressMonitor(monitor, totalWork / 2 / this.iusToUpdate.length));
                allUpdates.addAll(updates.toUnmodifiableSet());
                ++i;
            }
            IQueryResult iQueryResult = query.perform(allUpdates.iterator());
            return iQueryResult;
        }
        catch (OperationCanceledException operationCanceledException) {
            Collector collector = Collector.emptyCollector();
            return collector;
        }
        finally {
            monitor.done();
        }
    }
}

