/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.actions.UninstallAction;
import org.eclipse.equinox.internal.p2.ui.actions.UpdateAction;
import org.eclipse.equinox.internal.p2.ui.admin.InstallIUDropAdapter;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIActivator;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.ProvView;
import org.eclipse.equinox.internal.p2.ui.admin.RemoveProfilesJob;
import org.eclipse.equinox.internal.p2.ui.admin.dialogs.AddProfileDialog;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.p2.ui.model.Profiles;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilesView
extends ProvView {
    protected Action addProfileAction;
    protected Action removeProfileAction;
    protected Action uninstallAction;
    UpdateAction updateAction;
    private PropertyDialogAction propertiesAction;
    private StructuredViewerProvisioningListener listener;
    static /* synthetic */ Class class$0;

    @Override
    protected void addListeners() {
        super.addListeners();
        this.listener = new StructuredViewerProvisioningListener(((Object)((Object)this)).getClass().getName(), (StructuredViewer)this.viewer, 6, this.getProvisioningUI().getOperationRunner());
        ProvUI.getProvisioningEventBus((ProvisioningSession)this.getProvisioningUI().getSession()).addListener((ProvisioningListener)this.listener);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        ProvUI.getProvisioningEventBus((ProvisioningSession)this.getProvisioningUI().getSession()).removeListener((ProvisioningListener)this.listener);
    }

    @Override
    protected void configureViewer(TreeViewer treeViewer) {
        super.configureViewer(treeViewer);
        InstallIUDropAdapter adapter = new InstallIUDropAdapter((StructuredViewer)treeViewer);
        adapter.setFeedbackEnabled(false);
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        treeViewer.addDropSupport(1, transfers, (DropTargetListener)adapter);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.addProfileAction);
        manager.add((IAction)this.removeProfileAction);
        manager.add((IAction)this.propertiesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.updateAction);
        manager.add((IAction)this.uninstallAction);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addProfileAction);
        if (this.removeProfileAction.isEnabled()) {
            manager.add((IAction)this.removeProfileAction);
        }
        if (this.propertiesAction.isEnabled()) {
            manager.add((IAction)this.propertiesAction);
        }
        if (this.updateAction.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.updateAction);
            manager.add((IAction)this.uninstallAction);
        }
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.addProfileAction);
        manager.add((IAction)this.removeProfileAction);
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.addProfileAction = new AddProfileAction();
        this.removeProfileAction = new RemoveProfileAction();
        this.uninstallAction = new UninstallAction(this.getProvisioningUI(), (ISelectionProvider)this.viewer, null);
        this.propertiesAction = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer);
        this.updateAction = new UpdateAction(this.getProvisioningUI(), (ISelectionProvider)this.viewer, null, true);
        this.updateAction.setSkipSelectionPage(true);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                ProfilesView.this.selectionChanged(ss);
            }
        });
        this.selectionChanged((IStructuredSelection)this.viewer.getSelection());
    }

    @Override
    protected void selectionChanged(IStructuredSelection ss) {
        Object[] selectionArray;
        super.selectionChanged(ss);
        this.propertiesAction.setEnabled(false);
        this.removeProfileAction.setEnabled(false);
        if (ss.size() == 1) {
            this.propertiesAction.setEnabled(true);
        }
        if ((selectionArray = ss.toArray()).length > 0) {
            this.removeProfileAction.setEnabled(true);
            int i = 0;
            while (i < selectionArray.length) {
                IProfile profile;
                Object object = selectionArray[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((profile = (IProfile)ProvUI.getAdapter((Object)object, (Class)clazz)) == null) {
                    this.removeProfileAction.setEnabled(false);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    protected IAction getDoubleClickAction() {
        return this.propertiesAction;
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new ProvElementContentProvider();
    }

    @Override
    protected Object getInput() {
        return new Profiles(this.getProvisioningUI());
    }

    @Override
    protected String getProfileId() {
        IProfile profile;
        Object firstElement = this.getSelection().getFirstElement();
        if (firstElement instanceof InstalledIUElement) {
            return ((InstalledIUElement)firstElement).getProfileId();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profile = (IProfile)ProvUI.getAdapter((Object)firstElement, (Class)clazz)) != null) {
            return profile.getProfileId();
        }
        return null;
    }

    @Override
    protected List<String> getVisualProperties() {
        List<String> list = super.getVisualProperties();
        list.add("org.eclipse.equinox.internal.provisional.p2.ui.admin.showInstallRoots");
        return list;
    }

    String[] getKnownProfileIds() {
        IProfile[] allProfiles = ProvAdminUIActivator.getDefault().getProfileRegistry().getProfiles();
        String[] ids = new String[allProfiles.length];
        int i = 0;
        while (i < allProfiles.length) {
            ids[i] = allProfiles[i].getProfileId();
            ++i;
        }
        return ids;
    }

    @Override
    protected ProvisioningUI getProvisioningUI() {
        ProvisioningUI ui = ProvAdminUIActivator.getDefault().getProvisioningUI(this.getProfileId());
        if (ui != null) {
            return ui;
        }
        return super.getProvisioningUI();
    }

    private class AddProfileAction
    extends Action {
        AddProfileAction() {
            this.setText(ProvAdminUIMessages.ProfilesView_AddProfileLabel);
            this.setToolTipText(ProvAdminUIMessages.ProfilesView_AddProfileTooltip);
            this.setImageDescriptor(ProvUIImages.getImageDescriptor((String)"obj/profile_obj.gif"));
        }

        public void run() {
            new AddProfileDialog(ProfilesView.this.viewer.getControl().getShell(), ProfilesView.this.getKnownProfileIds()).open();
        }
    }

    private class RemoveProfileAction
    extends Action {
        RemoveProfileAction() {
            this.setText(ProvAdminUIMessages.ProfilesView_RemoveProfileLabel);
            this.setToolTipText(ProvAdminUIMessages.ProfilesView_RemoveProfileTooltip);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        }

        public void run() {
            Object[] selections = ProfilesView.this.getSelection().toArray();
            ArrayList<String> profilesOnly = new ArrayList<String>();
            int i = 0;
            while (i < selections.length) {
                if (selections[i] instanceof ProfileElement) {
                    profilesOnly.add(((ProfileElement)selections[i]).getProfileId());
                }
                ++i;
            }
            RemoveProfilesJob op = new RemoveProfilesJob(ProvAdminUIMessages.Ops_RemoveProfileOperationLabel, ProfilesView.this.getProvisioningUI().getSession(), profilesOnly.toArray(new String[profilesOnly.size()]));
            ProfilesView.this.run(op);
        }
    }
}

