/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.collection;

import java.util.ConcurrentModificationException;
import java.util.Spliterator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.jena.mem2.collection.FastHashBase;
import org.apache.jena.mem2.collection.JenaMap;
import org.apache.jena.mem2.iterator.SparseArrayIterator;
import org.apache.jena.mem2.spliterator.SparseArraySpliterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class FastHashMap<K, V>
extends FastHashBase<K>
implements JenaMap<K, V> {
    protected V[] values;

    protected FastHashMap(int initialSize) {
        super(initialSize);
        this.values = this.newValuesArray(this.keys.length);
    }

    protected FastHashMap() {
        this.values = this.newValuesArray(this.keys.length);
    }

    protected FastHashMap(FastHashMap<K, V> mapToCopy) {
        super(mapToCopy);
        this.values = this.newValuesArray(this.keys.length);
        System.arraycopy(mapToCopy.values, 0, this.values, 0, mapToCopy.values.length);
    }

    protected FastHashMap(FastHashMap<K, V> mapToCopy, UnaryOperator<V> valueProcessor) {
        super(mapToCopy);
        this.values = this.newValuesArray(this.keys.length);
        for (int i = 0; i < mapToCopy.values.length; ++i) {
            V value = mapToCopy.values[i];
            if (value == null) continue;
            this.values[i] = valueProcessor.apply(value);
        }
    }

    protected abstract V[] newValuesArray(int var1);

    @Override
    protected void growKeysAndHashCodeArrays() {
        super.growKeysAndHashCodeArrays();
        V[] oldValues = this.values;
        this.values = this.newValuesArray(this.keys.length);
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }

    @Override
    protected void removeFrom(int here) {
        this.values[this.positions[here] ^ 0xFFFFFFFF] = null;
        super.removeFrom(here);
    }

    @Override
    public void clear() {
        super.clear();
        this.values = this.newValuesArray(this.keys.length);
    }

    @Override
    public boolean tryPut(K key, V value) {
        int hashCode = key.hashCode();
        int pIndex = this.findPosition(key, hashCode);
        if (pIndex < 0) {
            if (this.tryGrowPositionsArrayIfNeeded()) {
                pIndex = this.findPosition(key, hashCode);
            }
            int eIndex = this.getFreeKeyIndex();
            this.keys[eIndex] = key;
            this.values[eIndex] = value;
            this.hashCodesOrDeletedIndices[eIndex] = hashCode;
            this.positions[pIndex ^ 0xFFFFFFFF] = ~eIndex;
            return true;
        }
        this.values[this.positions[pIndex] ^ 0xFFFFFFFF] = value;
        return false;
    }

    @Override
    public void put(K key, V value) {
        int hashCode = key.hashCode();
        int pIndex = this.findPosition(key, hashCode);
        if (pIndex < 0) {
            if (this.tryGrowPositionsArrayIfNeeded()) {
                pIndex = this.findPosition(key, hashCode);
            }
            int eIndex = this.getFreeKeyIndex();
            this.keys[eIndex] = key;
            this.values[eIndex] = value;
            this.hashCodesOrDeletedIndices[eIndex] = hashCode;
            this.positions[pIndex ^ 0xFFFFFFFF] = ~eIndex;
        } else {
            this.values[this.positions[pIndex] ^ 0xFFFFFFFF] = value;
        }
    }

    public V getValueAt(int i) {
        return this.values[i];
    }

    @Override
    public V get(K key) {
        int pIndex = this.findPosition(key, key.hashCode());
        if (pIndex < 0) {
            return null;
        }
        return this.values[~this.positions[pIndex]];
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        int pIndex = this.findPosition(key, key.hashCode());
        if (pIndex < 0) {
            return defaultValue;
        }
        return this.values[~this.positions[pIndex]];
    }

    @Override
    public V computeIfAbsent(K key, Supplier<V> absentValueSupplier) {
        int hashCode = key.hashCode();
        int pIndex = this.findPosition(key, hashCode);
        if (pIndex < 0) {
            if (this.tryGrowPositionsArrayIfNeeded()) {
                pIndex = this.findPosition(key, hashCode);
            }
            int eIndex = this.getFreeKeyIndex();
            this.keys[eIndex] = key;
            this.hashCodesOrDeletedIndices[eIndex] = hashCode;
            V value = absentValueSupplier.get();
            this.values[eIndex] = value;
            this.positions[pIndex ^ 0xFFFFFFFF] = ~eIndex;
            return value;
        }
        return this.values[~this.positions[pIndex]];
    }

    @Override
    public void compute(K key, UnaryOperator<V> valueProcessor) {
        int hashCode = key.hashCode();
        int pIndex = this.findPosition(key, hashCode);
        if (pIndex < 0) {
            Object value = valueProcessor.apply(null);
            if (value == null) {
                return;
            }
            int eIndex = this.getFreeKeyIndex();
            this.keys[eIndex] = key;
            this.hashCodesOrDeletedIndices[eIndex] = hashCode;
            this.values[eIndex] = value;
            this.positions[pIndex ^ 0xFFFFFFFF] = ~eIndex;
            this.tryGrowPositionsArrayIfNeeded();
        } else {
            int eIndex = ~this.positions[pIndex];
            Object value = valueProcessor.apply(this.values[eIndex]);
            if (value == null) {
                this.removeFrom(pIndex);
            } else {
                this.values[eIndex] = value;
            }
        }
    }

    @Override
    public ExtendedIterator<V> valueIterator() {
        int initialSize = this.size();
        Runnable checkForConcurrentModification = () -> {
            if (this.size() != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArrayIterator<V>(this.values, this.keysPos, checkForConcurrentModification);
    }

    @Override
    public Spliterator<V> valueSpliterator() {
        int initialSize = this.size();
        Runnable checkForConcurrentModification = () -> {
            if (this.size() != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArraySpliterator<V>(this.values, this.keysPos, checkForConcurrentModification);
    }
}

