/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.collection.CompositeCollection;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.util.StateflowUtil;
import org.eclipse.epsilon.emc.simulink.util.collection.SimulinkBlockCollection;
import org.eclipse.epsilon.emc.simulink.util.collection.SimulinkElementCollection;
import org.eclipse.epsilon.emc.simulink.util.collection.SimulinkLineCollection;
import org.eclipse.epsilon.emc.simulink.util.collection.SimulinkPortCollection;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;

public class TypeHelper {
    private static Map<String, String> map = new HashMap<String, String>();

    public static Kind getKind(String type) {
        if (type.toLowerCase().startsWith(Kind.STATEFLOW.name().toLowerCase())) {
            return Kind.STATEFLOW;
        }
        String kind = map.get(type);
        if (kind != null) {
            try {
                return Kind.get(kind);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static Kind getKind(SimulinkModel model, Object handle) {
        if (handle != null) {
            try {
                String type = (String)model.getEngine().evalWithSetupAndResult("handle = ?;", "get_param(handle, 'Type');", new Object[]{handle});
                return Kind.get(type);
            }
            catch (Exception exception) {
                return Kind.STATEFLOW;
            }
        }
        return null;
    }

    public static Collection<ISimulinkModelElement> getAllOfType(SimulinkModel model, String type) throws EolModelElementTypeNotFoundException {
        Kind kind = TypeHelper.getKind(type);
        if (kind == null) {
            Kind[] kinds = new Kind[]{};
            kinds = type.charAt(0) == type.toLowerCase().charAt(0) ? new Kind[]{Kind.PORT, Kind.LINE, Kind.BLOCK} : new Kind[]{Kind.BLOCK, Kind.PORT, Kind.LINE};
            Kind[] kindArray = kinds;
            int n = kinds.length;
            int n2 = 0;
            while (n2 < n) {
                Kind k = kindArray[n2];
                try {
                    return k.getAllSimulinkTypeFromModel(model, type);
                }
                catch (Exception exception) {
                    ++n2;
                }
            }
        } else {
            try {
                switch (kind) {
                    case STATEFLOW: {
                        return StateflowUtil.getAllOfStateflowTypeFromModel(model, type);
                    }
                }
                return kind.getAllSimulinkTypeFromModel(model, type);
            }
            catch (Exception exception) {
                throw new EolModelElementTypeNotFoundException(model.getName(), type);
            }
        }
        return new SimulinkElementCollection(model);
    }

    public static Collection<ISimulinkModelElement> getAll(SimulinkModel model) {
        CompositeCollection compositeCollection = new CompositeCollection();
        compositeCollection.addComposited(Kind.SIMULINK.getAll(model));
        compositeCollection.addComposited(Kind.STATEFLOW.getAll(model));
        return compositeCollection;
    }

    public static void put(String type, String supertype) {
        if (!map.containsKey(type)) {
            try {
                map.put(type, supertype);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("unable to add to types");
            }
        }
    }

    public static enum Kind {
        BLOCK("Block"),
        LINE("Line"),
        PORT("Port"),
        SIMULINK("Simulink"),
        STATEFLOW("Stateflow");

        private String kind;

        private Kind(String kind) {
            this.kind = kind;
        }

        public String getKind() {
            return this.kind;
        }

        public boolean is(String v) {
            return this.name().equalsIgnoreCase(v);
        }

        public boolean isSimulink() {
            return !STATEFLOW.equals((Object)this);
        }

        public Collection<ISimulinkModelElement> getAll(SimulinkModel model) {
            switch (this) {
                case BLOCK: 
                case LINE: 
                case PORT: {
                    try {
                        return this.getAllSimulinkKindFromModel(model);
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                case SIMULINK: {
                    CompositeCollection compositeCollection = new CompositeCollection();
                    compositeCollection.addComposited(BLOCK.getAll(model));
                    compositeCollection.addComposited(LINE.getAll(model));
                    compositeCollection.addComposited(PORT.getAll(model));
                    return compositeCollection;
                }
                case STATEFLOW: {
                    try {
                        return StateflowUtil.getAllStateflowBlocksFromModel(model);
                    }
                    catch (MatlabException matlabException) {}
                }
            }
            return Collections.emptyList();
        }

        private Collection<ISimulinkModelElement> getAllSimulinkKindFromModel(SimulinkModel model) throws MatlabException, IllegalStateException {
            try {
                String findKindCmd = "find_system('?','FindAll','on',%s,'Type','%s');";
                String cmd = String.format(findKindCmd, model.getSearchPreferences().searchStatement(), this.getKind());
                Object blocks = model.getEngine().evalWithResult(cmd, new Object[]{model.getSimulinkModelName()});
                switch (this) {
                    case BLOCK: {
                        return new SimulinkBlockCollection(blocks, model);
                    }
                    case LINE: {
                        return new SimulinkLineCollection(blocks, model);
                    }
                    case PORT: {
                        return new SimulinkPortCollection(blocks, model);
                    }
                }
                throw new IllegalStateException("Invalid Kind");
            }
            catch (MatlabException matlabException) {
                return Collections.emptyList();
            }
        }

        private Collection<ISimulinkModelElement> getAllSimulinkTypeFromModel(SimulinkModel model, String type) throws Exception {
            Object blocks = null;
            if (this.isSimulink()) {
                String findTypeCmd = "find_system('?','FindAll','on',%s,'%sType','?');";
                String cmd = String.format(findTypeCmd, model.getSearchPreferences().searchStatement(), this.getKind());
                blocks = model.getEngine().evalWithResult(cmd, new Object[]{model.getSimulinkModelName(), type});
                switch (this) {
                    case BLOCK: {
                        return new SimulinkBlockCollection(blocks, model);
                    }
                    case LINE: {
                        return new SimulinkLineCollection(blocks, model);
                    }
                    case PORT: {
                        return new SimulinkPortCollection(blocks, model);
                    }
                }
                throw new Exception("Only specific Simulink types (block, port, line) are allowed");
            }
            throw new EolModelElementTypeNotFoundException(model.getName(), type);
        }

        public static Kind get(String kind) throws Exception {
            try {
                return Kind.valueOf(kind.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("Is not kind");
            }
        }
    }
}

