/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictContext;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeConflict
extends VisualConflict {
    private static final String CHANGE_RELATED_TO = "Change related to ";
    private static final String COMP_DESCRIPTION_KEY = "compdescription";
    private static final String COMPOSITE_GIF = "composite.gif";
    private static final String COMPOSITE_CONFLICT_BOTH_KEY = "compositeconflict.both";
    private static final String OPPOSITE_KEY = "opposite";
    private static final String COMPOSITE_CONFLICT_THEIR_KEY = "compositeconflict.their";
    private static final String COMPOSITE_CONFLICT_MY_KEY = "compositeconflict.my";
    private static final String INCOMING_COMP_DESCRIPTION_KEY = "incomingcompdescription";
    private static final String LOCAL_COMP_DESCRIPTION_KEY = "localcompdescription";

    public CompositeConflict(ConflictBucket conflictBucket, DecisionManager decisionManager, boolean meCausing) {
        super(conflictBucket, decisionManager, meCausing, false);
        this.init();
    }

    @Override
    protected ConflictContext initConflictContext() {
        return new ConflictContext(this.getDecisionManager(), this.getLeftOperation(), this.getTheirOperation());
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (OperationUtil.isComposite((AbstractOperation)this.getMyOperation()) && OperationUtil.isComposite((AbstractOperation)this.getTheirOperation())) {
            description.setDescription(DecisionUtil.getDescription(COMPOSITE_CONFLICT_BOTH_KEY, this.getDecisionManager().isBranchMerge()));
            description.add(LOCAL_COMP_DESCRIPTION_KEY, this.getLeftOperation());
            description.add(INCOMING_COMP_DESCRIPTION_KEY, this.getRightOperation());
        } else if (this.isLeftMy()) {
            description.setDescription(DecisionUtil.getDescription(COMPOSITE_CONFLICT_MY_KEY, this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription(COMPOSITE_CONFLICT_THEIR_KEY, this.getDecisionManager().isBranchMerge()));
        }
        description.add(COMP_DESCRIPTION_KEY, this.getLeftOperation());
        description.add(OPPOSITE_KEY, this.getDecisionManager().getModelElement(this.getRightOperation().getModelElementId()));
        description.setImage(COMPOSITE_GIF);
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        String composite = null;
        String other = null;
        composite = this.getLeftOperation() instanceof CompositeOperation ? ((CompositeOperation)this.getLeftOperation()).getCompositeName() : CHANGE_RELATED_TO + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getLeftOperation().getModelElementId()));
        other = this.getRightOperation() instanceof CompositeOperation ? ((CompositeOperation)this.getRightOperation()).getCompositeName() : CHANGE_RELATED_TO + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getRightOperation().getModelElementId()));
        if (this.isLeftMy()) {
            myOption.setOptionLabel(composite);
            theirOption.setOptionLabel(other);
        } else {
            myOption.setOptionLabel(other);
            theirOption.setOptionLabel(composite);
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

