/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.Messages;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

public final class WorkspaceLocator {
    private static final Map<String, ESWorkspaceProviderImpl> WORKSPACE_PROVIDER_MAP = new LinkedHashMap<String, ESWorkspaceProviderImpl>();

    private WorkspaceLocator() {
    }

    public static ESWorkspaceProviderImpl createWorkspaceProviderFor(String workspaceProviderId) {
        ESWorkspaceProviderImpl ws = WorkspaceLocator.createWorkspace(workspaceProviderId);
        WORKSPACE_PROVIDER_MAP.put(workspaceProviderId, ws);
        return ws;
    }

    public static void removeWorkspaceProviderFor(String workspaceProviderId) {
        WORKSPACE_PROVIDER_MAP.remove(workspaceProviderId);
    }

    private static ESWorkspaceProviderImpl createWorkspace(String workspaceProviderId) {
        ESWorkspaceProviderImpl ws = new ESWorkspaceProviderImpl();
        ws.setName(workspaceProviderId);
        try {
            ws.initialize();
        }
        catch (RuntimeException e) {
            ModelUtil.logException((String)Messages.ESWorkspaceProviderImpl_WorkspaceInit_Failed, (Throwable)e);
            throw e;
        }
        ws.notifyPostWorkspaceInitiators();
        return ws;
    }

    public static boolean hasId(String workspaceProviderId) {
        for (String id : WORKSPACE_PROVIDER_MAP.keySet()) {
            if (!id.equals(workspaceProviderId)) continue;
            return true;
        }
        return false;
    }

    public static ESWorkspaceProviderImpl getWorkspaceById(String workspaceProviderId) {
        for (Map.Entry<String, ESWorkspaceProviderImpl> entry : WORKSPACE_PROVIDER_MAP.entrySet()) {
            String id = entry.getKey();
            if (!id.equals(workspaceProviderId)) continue;
            return entry.getValue();
        }
        return WorkspaceLocator.createWorkspaceProviderFor(workspaceProviderId);
    }
}

