/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model;

import java.util.Collection;
import java.util.Date;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.InvalidHandleException;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationRecorder;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESCompositeOperationHandleImpl;
import org.eclipse.emf.emfstore.internal.common.api.APIDelegate;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.semantic.SemanticCompositeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeOperationHandle
implements APIDelegate<ESCompositeOperationHandleImpl> {
    private boolean isValid;
    private CompositeOperation compositeOperation;
    private OperationRecorder operationRecorder;
    private ESCompositeOperationHandleImpl handle;

    public CompositeOperationHandle(OperationRecorder operationRecorder, CompositeOperation compositeOperation) {
        this.operationRecorder = operationRecorder;
        this.compositeOperation = compositeOperation;
        this.isValid = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void abort() throws InvalidHandleException {
        this.checkAndCloseHandle();
        this.operationRecorder.abortCompositeOperation();
        this.dropAllReferences();
    }

    private void dropAllReferences() {
        this.compositeOperation = null;
        this.operationRecorder = null;
    }

    private void checkAndCloseHandle() throws InvalidHandleException {
        if (!this.isValid) {
            throw new InvalidHandleException();
        }
        this.isValid = false;
    }

    public void end(String name, String description, ModelElementId modelElementId) throws InvalidHandleException {
        this.checkAndCloseHandle();
        this.compositeOperation.setCompositeName(name);
        this.compositeOperation.setCompositeDescription(description);
        this.compositeOperation.setClientDate(new Date());
        this.compositeOperation.setReversed(false);
        this.compositeOperation.setModelElementId(modelElementId);
        this.operationRecorder.endCompositeOperation();
        this.dropAllReferences();
    }

    public void end(SemanticCompositeOperation semanticCompositeOperation) throws InvalidHandleException {
        this.checkAndCloseHandle();
        semanticCompositeOperation.setClientDate(new Date());
        semanticCompositeOperation.setReversed(false);
        semanticCompositeOperation.getSubOperations().addAll((Collection)this.compositeOperation.getSubOperations());
        this.operationRecorder.endCompositeOperation(semanticCompositeOperation);
    }

    public ESCompositeOperationHandleImpl toAPI() {
        if (this.handle == null) {
            this.handle = this.createAPI();
        }
        return this.handle;
    }

    public ESCompositeOperationHandleImpl createAPI() {
        return new ESCompositeOperationHandleImpl(this);
    }
}

