/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.internal.core.Activator;

public class EclipseUtils {
    private static final String PROPERTY_OS_NAME = "os.name";
    private static String[] gShellEnvironmentCache = null;

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith("win");
    }

    public static boolean isWindowsXP() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().equalsIgnoreCase("Windows XP");
    }

    public static boolean isLinux() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith("linux");
    }

    public static boolean isMacOSX() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith("mac");
    }

    public static String getOsFamily() {
        if (EclipseUtils.isWindows()) {
            return "windows";
        }
        if (EclipseUtils.isLinux()) {
            return "linux";
        }
        if (EclipseUtils.isMacOSX()) {
            return "osx";
        }
        return "other";
    }

    public static String getKeyOs(String key) {
        String os = EclipseUtils.getOsFamily();
        String keyOs = String.format(key, os);
        return keyOs;
    }

    public static String getPathSeparator() {
        if (EclipseUtils.isWindows()) {
            return ";";
        }
        return ":";
    }

    public static IProject getProjectByName(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static IProject getProjectByLaunchConfiguration(ILaunchConfiguration configuration) {
        ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription(configuration);
        if (buildConfig != null) {
            return buildConfig.getProjectDescription().getProject();
        }
        return null;
    }

    public static IConfiguration getConfigurationFromDescription(ICConfigurationDescription configDescription) {
        return ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescription);
    }

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IScopeContext[] contexts) {
        String value = null;
        String from = null;
        int i = 0;
        while (i < contexts.length) {
            value = contexts[i].getNode(pluginId).get(key, null);
            if (value != null && !(value = value.trim()).isEmpty()) {
                from = contexts[i].getName();
                break;
            }
            ++i;
        }
        if (value != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("EclipseUtils.getPreferenceValueForId(\"" + pluginId + "\", \"" + key + "\", \"" + defaultValue + "\") = \"" + value + "\" from " + from);
            }
            return value;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("EclipseUtils.getPreferenceValueForId(\"" + pluginId + "\", \"" + key + "\", \"" + defaultValue + "\") = \"" + defaultValue + "\" default");
        }
        return defaultValue;
    }

    public static IScopeContext[] getPreferenceScopeContexts(IProject project) {
        IScopeContext[] contexts = project != null ? new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
        return contexts;
    }

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IProject project) {
        IScopeContext[] contexts = EclipseUtils.getPreferenceScopeContexts(project);
        return EclipseUtils.getPreferenceValueForId(pluginId, key, defaultValue, contexts);
    }

    public static String getVariableValue(String name) {
        IValueVariable variable = VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name);
        if (variable != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("EclipseUtils.getVariableValue(\"" + name + "\") = \"" + variable.getValue() + "\"");
            }
            return variable.getValue();
        }
        System.out.println("EclipseUtils.getVariableValue(\"" + name + "\" ) not found");
        return null;
    }

    public static void setVariableValue(String name, String value) {
        IValueVariable variable;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("EclipseUtils.setVariableValue(\"" + name + "\", \"" + value + "\")");
        }
        if ((variable = VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name)) != null) {
            variable.setValue(value);
        } else {
            System.out.println("EclipseUtils.setVariableValue(\"" + name + "\", \"" + value + "\") not set");
        }
    }

    public static void setVariableValue(String name, String description, String value) {
        IStringVariableManager manager;
        IValueVariable variable;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("EclipseUtils.setVariableValue(\"" + name + "\", \"" + description + "\", \"" + value + "\")");
        }
        if ((variable = (manager = VariablesPlugin.getDefault().getStringVariableManager()).getValueVariable(name)) == null) {
            variable = manager.newValueVariable(name, description);
            try {
                manager.addVariables(new IValueVariable[]{variable});
            }
            catch (CoreException e) {
                Activator.log(e);
                variable = null;
            }
        }
        if (variable != null) {
            variable.setValue(value);
        } else {
            System.out.println("EclipseUtils.setVariableValue(\"" + name + "\", \"" + value + "\") not set");
        }
    }

    public static IConfiguration[] getConfigurationsForProject(IProject project) {
        ICProjectDescription cProjectDescription = CoreModel.getDefault().getProjectDescription(project);
        if (cProjectDescription == null) {
            return null;
        }
        ICConfigurationDescription[] cfgs = cProjectDescription.getConfigurations();
        if (cfgs == null) {
            return null;
        }
        LinkedList<IConfiguration> list = new LinkedList<IConfiguration>();
        int i = 0;
        while (i < cfgs.length) {
            IConfiguration config;
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            if (info != null && (config = info.getManagedProject().getConfiguration(cfgs[i].getId())) != null) {
                list.add(config);
            }
            ++i;
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new IConfiguration[list.size()]);
    }

    public static ICConfigurationDescription getBuildConfigDescription(ILaunchConfiguration config) {
        ICProjectDescription projDesc;
        ICConfigurationDescription cfg;
        block11: {
            IProject project;
            block10: {
                String projectName;
                block9: {
                    block8: {
                        cfg = null;
                        projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
                        if (projectName != null) break block8;
                        return null;
                    }
                    projectName = projectName.trim();
                    if (!projectName.isEmpty()) break block9;
                    return null;
                }
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.isAccessible()) break block10;
                return null;
            }
            projDesc = CoreModel.getDefault().getProjectDescription(project, false);
            if (projDesc != null) break block11;
            return null;
        }
        try {
            String buildConfigID = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
            if (!buildConfigID.isEmpty()) {
                cfg = projDesc.getConfigurationById(buildConfigID);
            }
            if (cfg == null) {
                cfg = projDesc.getActiveConfiguration();
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return cfg;
    }

    public static String performStringSubstitution(String expression) {
        if (expression == null || expression.isEmpty()) {
            return null;
        }
        String result = expression;
        if (result.indexOf("${user.home}") >= 0) {
            String userHome = new Path(System.getProperty("user.home")).toString();
            userHome = Matcher.quoteReplacement(userHome);
            result = result.replaceAll("\\$\\{user.home\\}", userHome);
        }
        if (result.indexOf("${") >= 0) {
            IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                result = variableManager.performStringSubstitution(result, false);
            }
            catch (CoreException e) {
                result = null;
            }
        }
        return result;
    }

    public static IProject getProjectFromConfiguration(IConfiguration config) {
        ICConfigurationDescription configDesc = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)config);
        IProject project = configDesc.getProjectDescription().getProject();
        return project;
    }

    public static String[] getShellEnvironment() {
        if (gShellEnvironmentCache != null) {
            return gShellEnvironmentCache;
        }
        ArrayList<String> envList = new ArrayList<String>();
        String shell = System.getenv("SHELL");
        if (shell == null || shell.trim().isEmpty()) {
            System.out.println("No SHELL in environment");
            return null;
        }
        String[] cmdArray = new String[]{shell, "-i", "-c", "env"};
        if (Activator.getInstance().isDebugging()) {
            System.out.println("> " + StringUtils.join(cmdArray, " "));
        }
        String[] envp = null;
        ArrayList<String> outputLines = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = null;
            Process process = !PTY.isSupported((PTY.Mode)PTY.Mode.TERMINAL) || "win32".equals(Platform.getOS()) ? ProcessFactory.getFactory().exec(cmdArray, envp) : ProcessFactory.getFactory().exec(cmdArray, envp, null, new PTY(PTY.Mode.TERMINAL));
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                outputLines.add(line);
            }
            if (Activator.getInstance().isDebugging()) {
                for (String l : outputLines) {
                    System.out.println(l);
                }
            }
            process.destroy();
            if (process.exitValue() != 0) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("exit (" + process.exitValue() + ")");
                }
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        for (String line : outputLines) {
            if (!line.contains("=")) continue;
            envList.add(line);
        }
        gShellEnvironmentCache = envList.toArray(new String[envList.size()]);
        return gShellEnvironmentCache;
    }
}

