/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.jdt.internal.launch.MavenRuntimeClasspathProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchConfigurationListener
implements ILaunchConfigurationListener,
IMavenProjectChangedListener {
    private static final Logger log = LoggerFactory.getLogger(MavenLaunchConfigurationListener.class);

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        this.updateLaunchConfiguration(configuration);
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        this.updateLaunchConfiguration(configuration);
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    private void updateLaunchConfiguration(ILaunchConfiguration configuration) {
        try {
            if (!MavenRuntimeClasspathProvider.isSupportedType(configuration.getType().getIdentifier())) {
                return;
            }
            if (configuration.getAttributes().containsKey(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER)) {
                return;
            }
            IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            if (javaProject != null && javaProject.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
                MavenRuntimeClasspathProvider.enable(configuration);
            }
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        MavenProjectChangedEvent[] mavenProjectChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            MavenProjectChangedEvent event = mavenProjectChangedEventArray[n2];
            try {
                switch (event.getKind()) {
                    case 1: {
                        MavenRuntimeClasspathProvider.enable(event.getMavenProject().getProject());
                        break;
                    }
                    case 2: {
                        MavenRuntimeClasspathProvider.disable(event.getOldMavenProject().getProject());
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("Could not update launch configuration", (Throwable)e);
            }
            ++n2;
        }
    }
}

