/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejbliteshare;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.ejbliteshare.ReasonableStatus;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;

public class EJBLiteWebVehicleRunner
implements VehicleRunnable {
    private static final Logger logger = Logger.getLogger(EJBLiteWebVehicleRunner.class.getName());

    protected String getServletPath(String vehicle) {
        return "/" + vehicle + "_vehicle.jsp";
    }

    protected String getQueryString(Properties p) {
        return "?testName=" + TestUtil.getProperty(p, "testName");
    }

    @Override
    public Status run(String[] argv, Properties p) {
        String vehicle = TestUtil.getProperty(p, "vehicle");
        String contextRoot = TestUtil.getProperty(p, "vehicle_archive_name");
        String requestUrl = "/" + contextRoot + this.getServletPath(vehicle) + this.getQueryString(p);
        TSURL ctsURL = new TSURL();
        URL url = null;
        HttpURLConnection connection = null;
        int statusCode = 3;
        Object response = null;
        try {
            url = ctsURL.getURL("http", TestUtil.getProperty(p, "webServerHost"), Integer.parseInt(TestUtil.getProperty(p, "webServerPort")), requestUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            logger.info("Connecting " + url.toExternalForm());
            connection.connect();
            response = TestUtil.getResponse(connection).trim();
            statusCode = ((String)response).indexOf("[TEST PASSED] ") >= 0 ? 0 : 1;
        }
        catch (IOException e) {
            statusCode = 1;
            response = "Failed to connect to the test webapp." + TestUtil.printStackTraceToString(e);
        }
        return new ReasonableStatus(statusCode, (String)response);
    }
}

