/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order.AnotherInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order.Missile;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order.Weapon;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class EnterpriseLifecycleInterceptorDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseLifecycleInterceptorDefinitionTest.class)).withBeansXml(new BeansXml().interceptors(new Class[]{MissileInterceptor.class}))).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="enabled_interceptors", id="g"), @SpecAssertion(section="enabled_interceptors", id="h")})
    public void testLifecycleInterception() {
        ActionSequence.reset();
        Bean bean = this.getUniqueBean(Missile.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext((Contextual)bean);
        Missile missile = (Missile)bean.create(ctx);
        missile.fire();
        bean.destroy((Object)missile, ctx);
        List postConstruct = ActionSequence.getSequenceData((String)"postConstruct");
        Assert.assertEquals((int)postConstruct.size(), (int)4);
        Assert.assertEquals((String)((String)postConstruct.get(0)), (String)AnotherInterceptor.class.getName());
        Assert.assertEquals((String)((String)postConstruct.get(1)), (String)MissileInterceptor.class.getName());
        Assert.assertEquals((String)((String)postConstruct.get(2)), (String)Weapon.class.getName());
        Assert.assertEquals((String)((String)postConstruct.get(3)), (String)Missile.class.getName());
        List preDestroy = ActionSequence.getSequenceData((String)"preDestroy");
        Assert.assertEquals((int)preDestroy.size(), (int)4);
        Assert.assertEquals((String)((String)postConstruct.get(0)), (String)AnotherInterceptor.class.getName());
        Assert.assertEquals((String)((String)postConstruct.get(1)), (String)MissileInterceptor.class.getName());
        Assert.assertEquals((String)((String)postConstruct.get(2)), (String)Weapon.class.getName());
        Assert.assertEquals((String)((String)postConstruct.get(3)), (String)Missile.class.getName());
    }
}

