/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.servlet;

import jakarta.enterprise.context.Conversation;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.jboss.cdi.tck.tests.context.conversation.servlet.Message;
import org.jboss.cdi.tck.util.ActionSequence;

@WebServlet(value={"/servlet/*"})
public class Servlet
extends HttpServlet {
    @Inject
    private Message message;
    @Inject
    private Conversation conversation;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getRequestURI();
        if (uri.endsWith("/display")) {
            this.printInfo(resp.getWriter());
        } else if (uri.endsWith("/begin")) {
            this.conversation.begin();
            this.printInfo(resp.getWriter());
        } else if (uri.endsWith("/end")) {
            this.conversation.end();
            this.printInfo(resp.getWriter());
        } else if (uri.endsWith("/set")) {
            this.setMessage(req);
            this.printInfo(resp.getWriter());
        } else if (uri.endsWith("/invalidateSession")) {
            ActionSequence.addAction((String)"beforeInvalidate");
            req.getSession().invalidate();
            ActionSequence.addAction((String)"afterInvalidate");
            this.printInfo(resp.getWriter());
        } else if (uri.endsWith("/resetSequence")) {
            ActionSequence.reset();
        } else if (uri.endsWith("/getSequence")) {
            resp.getWriter().print(ActionSequence.getSequence().dataToCsv());
        } else {
            resp.setStatus(404);
        }
        resp.setContentType("text/plain");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getRequestURI();
        if (uri.endsWith("/set")) {
            this.setMessage(req);
            this.printInfo(resp.getWriter());
        } else {
            resp.setStatus(404);
        }
        resp.setContentType("text/plain");
    }

    private void printInfo(PrintWriter writer) {
        writer.append("message: " + this.message.getValue());
        writer.append("\n");
        writer.append("cid: [" + this.conversation.getId());
        writer.append("]");
        writer.append("\n");
        writer.append("transient: " + this.conversation.isTransient());
    }

    private void setMessage(HttpServletRequest request) {
        String value = request.getParameter("message");
        if (value == null) {
            throw new IllegalArgumentException("message must be specified");
        }
        this.message.setValue(value);
    }
}

