/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.ejb;

import jakarta.annotation.Resource;
import jakarta.ejb.Stateless;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.jboss.cdi.tck.tests.context.application.ejb.FMS;
import org.jboss.cdi.tck.tests.context.application.ejb.SimpleApplicationBean;

@Stateless
public class FMSModelIII
implements FMS {
    private static final String CLIMB_COMMAND = "ClimbCommand";
    private static final String DESCEND_COMMAND = "DescendCommand";
    @Resource
    private TimerService timerService;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Instance<SimpleApplicationBean> simpleApplicationBeanInstance;
    private static volatile boolean applicationScopeActive = false;
    private static volatile double beanId = 0.0;
    private static volatile boolean sameBean = false;
    private static boolean climbed;
    private static boolean descended;

    @Override
    public void climb() throws Exception {
        this.timerService.createTimer(200L, (Serializable)((Object)CLIMB_COMMAND));
    }

    @Override
    public void descend() throws Exception {
        this.timerService.createTimer(100L, (Serializable)((Object)DESCEND_COMMAND));
    }

    @Timeout
    public void timeout(Timer timer) {
        if (this.beanManager.getContext(ApplicationScoped.class).isActive()) {
            applicationScopeActive = true;
            if (beanId > 0.0) {
                if (beanId == ((SimpleApplicationBean)this.simpleApplicationBeanInstance.get()).getId()) {
                    sameBean = true;
                }
            } else {
                beanId = ((SimpleApplicationBean)this.simpleApplicationBeanInstance.get()).getId();
            }
        }
        if (timer.getInfo().equals(CLIMB_COMMAND)) {
            climbed = true;
        }
        if (timer.getInfo().equals(DESCEND_COMMAND)) {
            descended = true;
        }
    }

    @Override
    public boolean isApplicationScopeActive() {
        return applicationScopeActive;
    }

    @Override
    public boolean isSameBean() {
        return sameBean;
    }

    public static boolean isClimbed() {
        return climbed;
    }

    public static boolean isDescended() {
        return descended;
    }

    public static void reset() {
        beanId = 0.0;
        climbed = false;
        descended = false;
        applicationScopeActive = false;
        sameBean = false;
    }
}

