/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.async;

import jakarta.inject.Inject;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.cdi.tck.tests.context.application.async.AsyncRequestProcessor;
import org.jboss.cdi.tck.tests.context.application.async.SimpleAsyncListener;
import org.jboss.cdi.tck.tests.context.application.async.StatusBean;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebServlet(name="AsyncServlet", urlPatterns={"/AsyncServlet"}, asyncSupported=true)
public class AsyncServlet
extends HttpServlet {
    public static final String TEST_TIMEOUT = "timeout";
    public static final String TEST_COMPLETE = "complete";
    public static final String TEST_ERROR = "error";
    public static final String TEST_LOOP = "loop";
    private static final String[] VALID_TESTS = new String[]{"timeout", "complete", "error", "loop"};
    private static final SimpleLogger logger = new SimpleLogger(AsyncServlet.class);
    private static final long TIMEOUT = 200L;
    private static boolean inLoop = false;
    private ExecutorService executorService;
    @Inject
    StatusBean statusBean;

    public void init() throws ServletException {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String test = req.getParameter("test");
        if (!Arrays.asList(VALID_TESTS).contains(test)) {
            resp.setStatus(404);
            return;
        }
        this.statusBean.reset();
        AsyncContext actx = req.startAsync();
        actx.addListener(actx.createListener(SimpleAsyncListener.class));
        resp.setContentType("text/plain");
        if (TEST_TIMEOUT.equals(test)) {
            actx.setTimeout(200L);
        } else if (TEST_COMPLETE.equals(test)) {
            this.executorService.execute(new AsyncRequestProcessor(actx, 50L, false, null));
        } else if (TEST_ERROR.equals(test)) {
            this.executorService.execute(new AsyncRequestProcessor(actx, 50L, true, "/FailingServlet"));
        } else if (TEST_LOOP.equals(test)) {
            if (inLoop) {
                this.executorService.execute(new AsyncRequestProcessor(actx, 50L, false, null));
            } else {
                this.executorService.execute(new AsyncRequestProcessor(actx, 50L, true, null));
                inLoop = true;
            }
        }
        logger.log("Service finished: {0}", new Object[]{test});
    }
}

