/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.ejbweb;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.Properties;

@Named(value="mybean")
public class MyManagedBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Properties p = new Properties();
    private long timeout;
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    private transient JMSContext context;
    @Resource(name="jms/MY_QUEUE")
    private transient Queue queue;
    @Resource(name="jms/MY_TOPIC")
    private transient Topic topic;

    @PostConstruct
    public void postConstruct() {
        System.out.println("MyManageBean:postConstruct()");
        System.out.println("queue=" + String.valueOf(this.queue));
        System.out.println("topic=" + String.valueOf(this.topic));
        if (this.queue == null || this.topic == null || this.context == null) {
            throw new RuntimeException("postConstruct failed: injection failure");
        }
    }

    public void init(Properties p) {
        System.out.println("MyManageBean:init()");
        try {
            TestUtil.init((Properties)p);
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RuntimeException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RuntimeException("init: failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvQueueTestUsingCDIFromManagedBean() {
        boolean pass = true;
        JMSConsumer consumer = null;
        TestUtil.logMsg((String)"sendRecvQueueTestUsingCDIFromManagedBean");
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            consumer = this.context.createConsumer((Destination)this.queue);
            TestUtil.logMsg((String)"Creating TextMessage");
            messageSent = this.context.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvQueueTestUsingCDIFromManagedBean");
            TestUtil.logMsg((String)"Sending TextMessage");
            this.context.createProducer().send((Destination)this.queue, (Message)messageSent);
            TestUtil.logMsg((String)"Receiving TextMessage");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"No message was received");
                pass = false;
            } else {
                TestUtil.logMsg((String)("Message Sent: \"" + messageSent.getText() + "\""));
                TestUtil.logMsg((String)("Message Received: \"" + messageReceived.getText() + "\""));
                if (messageReceived.getText().equals(messageSent.getText())) {
                    TestUtil.logMsg((String)"Received correct message");
                } else {
                    TestUtil.logErr((String)"Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvTopicTestUsingCDIFromManagedBean() {
        boolean pass = true;
        JMSConsumer consumer = null;
        TestUtil.logMsg((String)"sendRecvTopicTestUsingCDIFromManagedBean");
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            consumer = this.context.createConsumer((Destination)this.queue);
            TestUtil.logMsg((String)"Creating TextMessage");
            messageSent = this.context.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvTopicTestUsingCDIFromManagedBean");
            TestUtil.logMsg((String)"Sending TextMessage");
            this.context.createProducer().send((Destination)this.queue, (Message)messageSent);
            TestUtil.logMsg((String)"Receiving TextMessage");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"No message was received");
                pass = false;
            } else {
                TestUtil.logMsg((String)("Message Sent: \"" + messageSent.getText() + "\""));
                TestUtil.logMsg((String)("Message Received: \"" + messageReceived.getText() + "\""));
                if (messageReceived.getText().equals(messageSent.getText())) {
                    TestUtil.logMsg((String)"Received correct message");
                } else {
                    TestUtil.logErr((String)"Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }
}

