/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.closedQueueSession;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedQueueSessionTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.appclient.closedQueueSession.ClosedQueueSessionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedQueueSessionTests theTests = new ClosedQueueSessionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseSession(int type, String user, String password) throws Exception {
        if (type == 0 || type == 2) {
            tool = new JmsTool(type, user, password, this.mode);
            tool.getDefaultQueueConnection().start();
            this.logMsg("Closing queue session");
            tool.getDefaultQueueSession().close();
        }
        this.logMsg("Session closed");
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            this.logMsg("Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void closedQueueSessionGetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getMessageListener");
            try {
                MessageListener foo = tool.getDefaultQueueReceiver().getMessageListener();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetMessageListenerTest", e);
        }
    }

    public void closedQueueSessionSetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setMessageListener");
            try {
                MessageListener foo = new MessageListener(){

                    public void onMessage(Message m) {
                    }
                };
                tool.getDefaultQueueReceiver().setMessageListener(foo);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetMessageListenerTest", e);
        }
    }
}

