/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.APIAssertionTest;
import com.sun.ts.tests.common.connector.whitebox.ContextWork;
import com.sun.ts.tests.common.connector.whitebox.Counter;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.DistributedWorkImpl;
import com.sun.ts.tests.common.connector.whitebox.LocalTxMessageListener;
import com.sun.ts.tests.common.connector.whitebox.RogueWorkImpl;
import com.sun.ts.tests.common.connector.whitebox.ScheduleWork;
import com.sun.ts.tests.common.connector.whitebox.TSSICWithListener;
import com.sun.ts.tests.common.connector.whitebox.TSSecurityContextWithListener;
import com.sun.ts.tests.common.connector.whitebox.WorkAndAssocImpl;
import com.sun.ts.tests.common.connector.whitebox.WorkImpl;
import com.sun.ts.tests.common.connector.whitebox.WorkListenerImpl;
import com.sun.ts.tests.common.connector.whitebox.WorkListenerImpl2;
import com.sun.ts.tests.common.connector.whitebox.WorkXid;
import com.sun.ts.tests.common.connector.whitebox.WorkXid1;
import com.sun.ts.tests.common.connector.whitebox.XidImpl;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.HintsContext;
import jakarta.resource.spi.work.SecurityContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkContext;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import jakarta.resource.spi.work.WorkRejectedException;
import java.io.Serializable;
import javax.transaction.xa.Xid;

public class TestWorkManager {
    private WorkManager wmgr;
    private static Xid myxid;
    private static Xid mynestxid;
    private XATerminator xa;
    private String sicUser = "";
    private String sicPwd = "";
    private String eisUser = "";
    private LocalTxMessageListener ml;
    private BootstrapContext bsc = null;
    private boolean useSecurityMapping = false;

    public TestWorkManager(BootstrapContext val) {
        this.bsc = val;
        this.wmgr = this.bsc.getWorkManager();
        this.xa = this.bsc.getXATerminator();
        this.sicUser = TestUtil.getSystemProperty((String)"j2eelogin.name");
        this.sicPwd = TestUtil.getSystemProperty((String)"j2eelogin.password");
        this.eisUser = TestUtil.getSystemProperty((String)"eislogin.name");
        this.verifyConfigSettings();
    }

    public void runTests() {
        this.doWork();
        this.startWork();
        this.rogueWork();
        this.distributableWork();
        this.scheduleWorkListener();
        this.scheduleWork();
        this.submitXidWork();
        this.submitNestedXidWork();
        this.submitSecurityContextWork();
        this.submitSICWork();
        this.testWorkContextProvider();
        this.testWorkContextLifecycleListener();
        this.doWorkAndAssoc();
        this.doAPITests();
    }

    public void submitSecurityContextWork() {
        if (!this.useSecurityMapping) {
            this.cbTestCPCandNullPrin();
            this.cbTestAllCallbacksAndPrin();
            this.cbTestAllCallbacksNullPrin();
            this.cbTestCPCandPVC();
            this.cbTestCPCandGPC();
            this.cbTestCPCandPrin();
        } else {
            this.cbTestGPCandCPCFail();
            this.cbTestEISCPCandPrin();
        }
    }

    public void cbTestEISCPCandPrin() {
        Object str = "Enterred cbEISTestCPCandPrin() and Testing that A CPC ";
        str = (String)str + "that has nothing added to subject and has a non-null principal is handled";
        this.debug((String)str);
        this.debug("cbTestEISCPCandPrin():  useSecurityMapping SHOULD be true");
        this.debug("cbTestEISCPCandPrin():  useSecurityMapping IS " + this.useSecurityMapping);
        TSSecurityContextWithListener tsic = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, this.eisUser, this.useSecurityMapping);
        tsic.setCallbacks(true, false, false);
        tsic.setAddPrinToExecSubject(false);
        tsic.setLogOutString("cbEISTestCPCandPrin:  callbacks handled.");
        TSSecurityContextWithListener sic = tsic;
        this.testSecurityInflow(sic, true);
        this.debug("done testing cbEISTestCPCandPrin()");
    }

    public void cbTestCPCandPrin() {
        Object str = "Enterred cbTestCPCandPrin() and Testing that A CPC ";
        str = (String)str + "that has nothing added to subject and has a null principal is handled";
        this.debug((String)str);
        this.debug("cbTestCPCandPrin():  useSecurityMapping SHOULD be false");
        this.debug("cbTestCPCandPrin():  useSecurityMapping IS " + this.useSecurityMapping);
        TSSecurityContextWithListener tsic = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, null, this.useSecurityMapping);
        tsic.setCallbacks(true, false, false);
        tsic.setAddPrinToExecSubject(false);
        tsic.setLogOutString("cbTestCPCandPrin:  callbacks handled.");
        TSSecurityContextWithListener sic = tsic;
        this.testSecurityInflow(sic, true);
        this.debug("done testing cbTestCPCandPrin()");
    }

    public void cbTestAllCallbacksNullPrin() {
        Object str = "Enterred cbTestAllCallbacksNullPrin() and Testing a GPC, PVC, and CPC ";
        str = (String)str + "that have nothing added to subject and a null principal are handled";
        this.debug((String)str);
        this.debug("cbTestAllCallbacksNullPrin():  useSecurityMapping SHOULD be false");
        this.debug("cbTestAllCallbacksNullPrin():  useSecurityMapping IS " + this.useSecurityMapping);
        TSSecurityContextWithListener tsic = new TSSecurityContextWithListener(null, null, null, this.useSecurityMapping);
        tsic.setCallbacks(true, true, true);
        tsic.setAddPrinToExecSubject(false);
        tsic.setLogOutString("cbTestAllCallbacksNullPrin:  callbacks handled.");
        TSSecurityContextWithListener sic = tsic;
        this.testSecurityInflow(sic, true);
        this.debug("done testing cbTestAllCallbacksNullPrin()");
    }

    public void cbTestAllCallbacksAndPrin() {
        Object str = "Enterred cbTestAllCallbacksAndPrin() and Testing a GPC, PVC, and CPC ";
        str = (String)str + "that have nothing added to subject and a non-null principal are handled";
        this.debug((String)str);
        this.debug("cbTestAllCallbacksAndPrin():  useSecurityMapping SHOULD be false");
        this.debug("cbTestAllCallbacksAndPrin():  useSecurityMapping IS " + this.useSecurityMapping);
        TSSecurityContextWithListener tsic = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, this.eisUser, this.useSecurityMapping);
        tsic.setCallbacks(true, true, true);
        tsic.setAddPrinToExecSubject(false);
        tsic.setLogOutString("cbTestAllCallbacksAndPrin:  callbacks handled.");
        this.debug("TestWorkManager.cbTestAllCallbacksAndPrin - done calling tsic.setLogOutString()");
        TSSecurityContextWithListener sic = tsic;
        this.testSecurityInflow(sic, true);
        this.debug("done testing cbTestAllCallbacksAndPrin()");
    }

    public void cbTestCPCandNullPrin() {
        Object str = "Enterred cbTestCPCandNullPrin() and Testing that A CPC ";
        str = (String)str + "that has nothing added to subject and has a null principal is handled";
        this.debug((String)str);
        this.debug("cbTestCPCandNullPrin():  useSecurityMapping SHOULD be false");
        this.debug("cbTestCPCandNullPrin():  useSecurityMapping IS " + this.useSecurityMapping);
        TSSecurityContextWithListener tsic = new TSSecurityContextWithListener(null, null, null, this.useSecurityMapping);
        tsic.setCallbacks(true, false, false);
        tsic.setAddPrinToExecSubject(false);
        tsic.setLogOutString("cbTestCPCandNullPrin:  Case-1 security callbacks handled.");
        TSSecurityContextWithListener sic = tsic;
        this.testSecurityInflow(sic, true);
        this.debug("done testing cbTestCPCandNullPrin()");
    }

    public void cbTestCPCandGPC() {
        Object str = "Enterred cbTestCPCandGPC() and Testing that ";
        str = (String)str + "GPC (w non-null group) followed by a CPC that has non-null princiapl) is handled";
        this.debug((String)str);
        this.debug("cbTestCPCandPrin():  useSecurityMapping SHOULD be false");
        this.debug("cbTestCPCandPrin():  useSecurityMapping IS " + this.useSecurityMapping);
        TSSecurityContextWithListener tsic = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, this.eisUser, this.useSecurityMapping);
        tsic.setCallbacks(true, true, false);
        tsic.setAddPrinToExecSubject(false);
        tsic.setLogOutString("cbTestCPCandGPC:  callbacks handled.");
        TSSecurityContextWithListener sic = tsic;
        this.testSecurityInflow(sic, true);
        this.debug("done testing cbTestCPCandGPC()");
    }

    public void cbTestCPCandPVC() {
        Object str = "Enterred cbTestCPCandPVC() and Testing that ";
        str = (String)str + "PVC followed by a CPC that has non-null principal) is handled";
        this.debug((String)str);
        this.debug("cbTestCPCandPVC():  useSecurityMapping SHOULD be false");
        this.debug("cbTestCPCandPVC():  useSecurityMapping IS " + this.useSecurityMapping);
        TSSecurityContextWithListener tsic = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, this.eisUser, this.useSecurityMapping);
        tsic.setCallbacks(true, false, true);
        tsic.setLogOutString("cbTestCPCandPVC:  callbacks handled.");
        tsic.setAddPrinToExecSubject(false);
        TSSecurityContextWithListener sic = tsic;
        this.testSecurityInflow(sic, true);
        this.debug("done testing cbTestCPCandPVC()");
    }

    public void cbTestGPCandCPCFail() {
        Object str = "Enterred cbTestGPCandCPCFail() and Testing a GPC, and CPC fail";
        str = (String)str + "where principal is added to execSubject and CPC is not handled";
        this.debug((String)str);
        this.debug("cbTestGPCandCPCFail():  useSecurityMapping SHOULD be true");
        this.debug("cbTestGPCandCPCFail():  useSecurityMapping IS " + this.useSecurityMapping);
        TSSecurityContextWithListener tsic = new TSSecurityContextWithListener("fakeusr", "fakepwd", "fakepwd", true);
        tsic.setCallbacks(true, true, false);
        tsic.setAddPrinToExecSubject(true);
        tsic.setExpectFailure(true);
        tsic.setLogOutString("cbTestGPCandCPCFail:  callbacks are NOT handled - as expected.");
        TSSecurityContextWithListener sic = tsic;
        this.testSecurityInflow(sic, true);
        this.debug("done testing cbTestGPCandCPCFail()");
    }

    public void submitSICWork() {
        try {
            ConnectorStatus.getConnectorStatus().logState("enterred submitSICWork()");
            this.debug("enterred submitSICWork()");
            ContextWork w1 = new ContextWork(this.wmgr);
            this.debug("creating SIC with user=" + this.sicUser + "  pwd=" + this.sicPwd + "    eisUser = " + this.eisUser);
            TSSecurityContextWithListener sic = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, this.eisUser, this.useSecurityMapping);
            w1.addWorkContext((WorkContext)sic);
            this.wmgr.doWork((Work)w1, Long.MAX_VALUE, null, null);
            ConnectorStatus.getConnectorStatus().logState("submitted work with SIC Listener");
        }
        catch (WorkCompletedException e) {
            this.debug("WorkCompleted calling submitSICWork()");
        }
        catch (Exception e) {
            this.debug("got exception in submitSICWork() with user = " + this.sicUser + " pwd = " + this.sicPwd + "  principal=" + this.eisUser);
            this.debug(e.toString());
            Debug.printDebugStack(e);
        }
    }

    public void testWorkContextLifecycleListener() {
        try {
            this.debug("enterred testWorkContextLifecycleListener()");
            ContextWork workimpl = new ContextWork(this.wmgr);
            Counter.resetCount();
            WorkListenerImpl2 wl = new WorkListenerImpl2();
            this.debug("Submitting Work Object testWorkContextLifecycleListener().");
            HintsContext hic = new HintsContext();
            hic.setName("someReallyLongAndUncommonName");
            hic.setHint("jakarta.resource.Name", (Serializable)((Object)"someReallyLongAndUncommonHintValue"));
            workimpl.addWorkContext((WorkContext)hic);
            TSSICWithListener sic = new TSSICWithListener(this.eisUser, this.eisUser, this.sicUser, true);
            workimpl.addWorkContext((WorkContext)sic);
            this.wmgr.doWork((Work)workimpl, Long.MAX_VALUE, null, (WorkListener)wl);
            this.debug("done submitting work obj in testWorkContextLifecycleListener()");
        }
        catch (WorkRejectedException ex) {
            this.debug("Problem:  testWorkContextLifecycleListener WorkException thrown is " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (WorkException ex) {
            this.debug("testWorkContextLifecycleListener WorkException thrown is " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            this.debug("Problem:  testWorkContextLifecycleListener Exception thrown is " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void testWorkContextProvider() {
        try {
            this.debug("enterred testWorkContextProvider()");
            ContextWork workimpl = new ContextWork(this.wmgr);
            ExecutionContext ec = new ExecutionContext();
            WorkListenerImpl wl = new WorkListenerImpl();
            this.debug("Submitting Work Object - which should genetate WorkRejectedException.");
            this.wmgr.doWork((Work)workimpl, 5000L, ec, (WorkListener)wl);
        }
        catch (WorkRejectedException we) {
            String str = "SUCCESS:  WorkContextProvider causes expected WorkRejectedException";
            this.debug(str);
            ConnectorStatus.getConnectorStatus().logState(str);
        }
        catch (WorkException we) {
            this.debug("FAILURE:  testWorkContextProvider() WorkException thrown is " + we.getMessage());
        }
        catch (Exception ex) {
            this.debug("FAILURE:  testWorkContextProvider() Exception thrown is " + ex.getMessage());
        }
        this.debug("leaving testWorkContextProvider()");
    }

    public void testSecurityInflow(SecurityContext sic, boolean writeToDB) {
        try {
            ConnectorStatus.getConnectorStatus().logState("enterred testSecurityInflow()");
            this.debug("enterred testSecurityInflow()");
            ExecutionContext ec = this.startTx();
            ContextWork w1 = new ContextWork(this.wmgr);
            WorkListenerImpl wl = new WorkListenerImpl();
            wl.setUidStr("notifications test");
            TransactionContext tic = new TransactionContext();
            tic.setXid(ec.getXid());
            w1.addWorkContext((WorkContext)tic);
            w1.addWorkContext((WorkContext)sic);
            this.wmgr.doWork((Work)w1, Long.MAX_VALUE, null, (WorkListener)wl);
            if (writeToDB) {
                this.xa.commit(ec.getXid(), true);
            } else {
                this.xa.rollback(tic.getXid());
            }
        }
        catch (WorkCompletedException e) {
            this.debug("WorkCompleted calling testSecurityInflow()");
        }
        catch (Exception e) {
            this.debug("got exception in testSecurityInflow() with user = " + sic.getName());
            this.debug(e.toString());
            Debug.printDebugStack(e);
        }
    }

    private ExecutionContext startTx() {
        ExecutionContext ec = new ExecutionContext();
        try {
            XidImpl xid = new XidImpl();
            ec.setXid((Xid)xid);
            ec.setTransactionTimeout(5000L);
        }
        catch (Exception ex) {
            Debug.printDebugStack(ex);
        }
        return ec;
    }

    public void scheduleWork() {
        try {
            ScheduleWork sw = new ScheduleWork();
            this.wmgr.scheduleWork((Work)sw);
            this.debug("Schedule work called");
            ConnectorStatus.getConnectorStatus().logState("Schedule Work Called");
        }
        catch (WorkException we) {
            this.debug("TestWorkManager Exception thrown is " + we.getMessage());
        }
    }

    public void scheduleWorkListener() {
        try {
            ScheduleWork sw = new ScheduleWork();
            ExecutionContext ec = new ExecutionContext();
            this.wmgr.scheduleWork((Work)sw, 5000L, ec, null);
            this.debug("Schedule work listener called");
            ConnectorStatus.getConnectorStatus().logState("Schedule Work Listener Called");
        }
        catch (WorkException we) {
            this.debug("TestWorkManager Exception thrown is " + we.getMessage());
        }
    }

    public void doAPITests() {
        APIAssertionTest apiTest = new APIAssertionTest();
        apiTest.runTests();
    }

    public void doWork() {
        try {
            WorkImpl workimpl = new WorkImpl(this.wmgr);
            ExecutionContext ec = new ExecutionContext();
            this.debug("doWork():  Creating WorkListener");
            WorkListenerImpl wl = new WorkListenerImpl();
            ConnectorStatus.getConnectorStatus().logState("Work Object Submitted");
            this.wmgr.doWork((Work)workimpl, Long.MAX_VALUE, ec, (WorkListener)wl);
        }
        catch (WorkException we) {
            this.debug("TestWorkManager WorkException thrown is " + we.getMessage());
        }
    }

    public void doWorkAndAssoc() {
        try {
            WorkAndAssocImpl workimpl = new WorkAndAssocImpl(this.wmgr);
            ExecutionContext ec = new ExecutionContext();
            this.debug("doWorkAndAssoc():  Creating WorkListener");
            WorkListenerImpl wl = new WorkListenerImpl();
            ConnectorStatus.getConnectorStatus().logState("Work Object Submitted");
            this.wmgr.doWork((Work)workimpl, Long.MAX_VALUE, ec, (WorkListener)wl);
        }
        catch (WorkException we) {
            this.debug("TestWorkManager WorkException thrown is " + we.getMessage());
            we.printStackTrace();
        }
    }

    public void startWork() {
        try {
            WorkImpl workimpl = new WorkImpl(this.wmgr);
            ExecutionContext ec = new ExecutionContext();
            this.debug("startWork: Creating WorkListener");
            WorkListenerImpl wl = new WorkListenerImpl();
            long value = this.wmgr.startWork((Work)workimpl, 1000L, ec, (WorkListener)wl);
            this.debug("startWork: WorkManager value = " + value);
            ConnectorStatus.getConnectorStatus().logState("WorkManager value returned " + value);
            this.debug("WorkManager value returned " + value);
        }
        catch (WorkException we) {
            this.debug("TestWorkManager.startWork() Exception thrown is " + we.getMessage());
        }
    }

    public void rogueWork() {
        try {
            RogueWorkImpl rwi = new RogueWorkImpl();
            this.wmgr.doWork((Work)rwi);
        }
        catch (WorkCompletedException wx) {
            ConnectorStatus.getConnectorStatus().logState("Rogue work throws WorkCompletedException");
        }
        catch (WorkException we) {
            this.debug("TestWorkManager Exception thrown is " + we.getMessage());
        }
    }

    public void distributableWork() {
        try {
            DistributedWorkImpl dwi = new DistributedWorkImpl(this.wmgr);
            ExecutionContext ec = new ExecutionContext();
            this.debug("distributableWork(): Creating WorkListener");
            WorkListenerImpl wl = new WorkListenerImpl();
            long value = this.wmgr.startWork((Work)dwi, 1000L, ec, (WorkListener)wl);
            ConnectorStatus.getConnectorStatus().logState("DistributedWork Object Submitted");
            if (value >= -1L) {
                ConnectorStatus.getConnectorStatus().logState("WorkManagers DistributedWork value returned " + value);
                this.debug("WorkManagers DistributedWork value returned " + value);
            }
        }
        catch (WorkCompletedException wx) {
            ConnectorStatus.getConnectorStatus().logState("Rogue work throws WorkCompletedException");
        }
        catch (WorkException we) {
            this.debug("TestWorkManager Exception thrown is " + we.getMessage());
        }
    }

    public void setXid(Xid xid) {
        myxid = xid;
    }

    public Xid getXid() {
        return myxid;
    }

    public void setNestXid(Xid xid) {
        mynestxid = xid;
    }

    public Xid getNestXid() {
        return mynestxid;
    }

    public void setUseSecurityMapping(boolean val) {
        this.useSecurityMapping = val;
    }

    public boolean getUseSecurityMapping() {
        return this.useSecurityMapping;
    }

    public void submitXidWork() {
        try {
            XidImpl myid = new XidImpl();
            this.setXid(myid);
            WorkXid workid = new WorkXid();
            ExecutionContext ec = new ExecutionContext();
            ec.setXid((Xid)myid);
            this.debug("TestWorkManager.submitXidWork XID IS " + myid.getFormatId());
            this.wmgr.doWork((Work)workid, Long.MAX_VALUE, ec, null);
            this.debug("WorkXid Submitted");
            ConnectorStatus.getConnectorStatus().logState("WorkXid Submitted");
        }
        catch (WorkException we) {
            Debug.printDebugStack((Exception)((Object)we));
        }
    }

    public void submitNestedXidWork() {
        try {
            XidImpl myid = new XidImpl();
            WorkXid1 workid = new WorkXid1(this.wmgr, myid);
            this.setNestXid(myid);
            this.debug("TestWorkManager.submitNestedXidWork XID IS " + myid.getFormatId());
            ExecutionContext ec = new ExecutionContext();
            ec.setXid((Xid)myid);
            this.wmgr.doWork((Work)workid, Long.MAX_VALUE, ec, null);
            this.debug("WorkXid1 submitted");
        }
        catch (WorkException we) {
            Debug.printDebugStack((Exception)((Object)we));
        }
    }

    private void verifyConfigSettings() {
        Object err = "WARNING - TestWorkManager could not find required system property: ";
        if (this.sicUser == null) {
            err = (String)err + "j2eelogin.name";
            this.debug((String)err);
            this.sicUser = "j2ee";
        }
        if (this.sicPwd == null) {
            err = (String)err + "j2eelogin.password";
            this.debug((String)err);
            this.sicUser = "j2ee";
        }
        if (this.eisUser == null) {
            err = (String)err + "j2eelogin.password";
            this.debug((String)err);
            this.sicUser = "cts1";
        }
    }

    private void debug(String str) {
        Debug.trace(str);
    }
}

