/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.MessageFactory;
import java.util.UUID;

public class UUIDConverter
implements Converter<UUID> {
    public static final String CONVERTER_ID = "jakarta.faces.UUID";
    public static final String UUID_ID = "jakarta.faces.converter.UUIDConverter.UUID";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";

    @Override
    public UUID getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null || value.isBlank()) {
            return null;
        }
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw new ConverterException(MessageFactory.getMessage(context, UUID_ID, value, "29573f55-4254-4afa-9ca6-6b5ae6c7ab6e", MessageFactory.getLabel(context, component)), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, UUID value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        try {
            return value.toString();
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }
}

