/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.util.ComponentUtilities;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.Map;

public class ImageHyperlink
extends Hyperlink
implements NamingContainer {
    private static final String IMAGE_FACET = "image";
    protected static final String IMAGE_FACET_SUFFIX = "_image";
    private String align = null;
    private String alt = null;
    private int border = Integer.MIN_VALUE;
    private boolean borderSet = false;
    private int height = Integer.MIN_VALUE;
    private boolean heightSet = false;
    private int hspace = Integer.MIN_VALUE;
    private boolean hspaceSet = false;
    private String icon = null;
    private String imageURL = null;
    private String textPosition = null;
    private boolean visible = false;
    private boolean visibleSet = false;
    private int vspace = Integer.MIN_VALUE;
    private boolean vspaceSet = false;
    private int width = Integer.MIN_VALUE;
    private boolean widthSet = false;

    public ImageHyperlink() {
        this.setRendererType("com.sun.webui.jsf.ImageHyperlink");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.ImageHyperlink";
    }

    public UIComponent getImageFacet() {
        Object image = ComponentUtilities.getPrivateFacet((UIComponent)this, IMAGE_FACET, false);
        if (image != null) {
            return image;
        }
        String url = this.getImageURL();
        String imgIcon = this.getIcon();
        if (url == null && imgIcon == null) {
            ComponentUtilities.removePrivateFacet((UIComponent)this, IMAGE_FACET);
            return null;
        }
        image = url != null ? new ImageComponent() : new Icon();
        Map map = image.getAttributes();
        if (imgIcon != null) {
            map.put("icon", imgIcon);
        }
        if (url != null) {
            map.put("url", url);
        }
        this.setAttributes(ComponentUtilities.createPrivateFacetId((UIComponent)this, IMAGE_FACET), (UIComponent)image);
        return image;
    }

    protected void setAttributes(String facetId, UIComponent image) {
        Boolean disabled;
        String description;
        int dim;
        image.setId(facetId);
        image.setParent((UIComponent)this);
        String alignAttr = this.getAlign();
        Map atts = image.getAttributes();
        if (alignAttr != null) {
            atts.put("align", alignAttr);
        }
        if ((dim = this.getBorder()) >= 0) {
            atts.put("border", dim);
        }
        if ((description = this.getAlt()) != null) {
            atts.put("alt", description);
        }
        if ((dim = this.getHeight()) >= 0) {
            atts.put("height", dim);
        }
        if ((dim = this.getHspace()) >= 0) {
            atts.put("hspace", dim);
        }
        if ((dim = this.getVspace()) >= 0) {
            atts.put("vspace", dim);
        }
        if ((dim = this.getWidth()) >= 0) {
            atts.put("width", dim);
        }
        if ((disabled = (Boolean)this.getAttributes().get("disabled")) != null) {
            atts.put("disabled", String.valueOf(disabled));
        }
    }

    @Override
    public String getOnDblClick() {
        return super.getOnDblClick();
    }

    public String getAlign() {
        if (this.align != null) {
            return this.align;
        }
        ValueExpression vb = this.getValueExpression("align");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAlign(String newAlign) {
        this.align = newAlign;
    }

    public String getAlt() {
        if (this.alt != null) {
            return this.alt;
        }
        ValueExpression vb = this.getValueExpression("alt");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAlt(String newAlt) {
        this.alt = newAlt;
    }

    public int getBorder() {
        if (this.borderSet) {
            return this.border;
        }
        ValueExpression vb = this.getValueExpression("border");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setBorder(int newBorder) {
        this.border = newBorder;
        this.borderSet = true;
    }

    public int getHeight() {
        if (this.heightSet) {
            return this.height;
        }
        ValueExpression vb = this.getValueExpression("height");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
        this.heightSet = true;
    }

    public int getHspace() {
        if (this.hspaceSet) {
            return this.hspace;
        }
        ValueExpression vb = this.getValueExpression("hspace");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setHspace(int newHspace) {
        this.hspace = newHspace;
        this.hspaceSet = true;
    }

    public String getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        ValueExpression vb = this.getValueExpression("icon");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setIcon(String newIcon) {
        this.icon = newIcon;
    }

    public String getImageURL() {
        if (this.imageURL != null) {
            return this.imageURL;
        }
        ValueExpression vb = this.getValueExpression("imageURL");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setImageURL(String newImageURL) {
        this.imageURL = newImageURL;
    }

    public String getTextPosition() {
        if (this.textPosition != null) {
            return this.textPosition;
        }
        ValueExpression vb = this.getValueExpression("textPosition");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return "right";
    }

    public void setTextPosition(String newTextPosition) {
        this.textPosition = newTextPosition;
    }

    @Override
    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    @Override
    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public int getVspace() {
        if (this.vspaceSet) {
            return this.vspace;
        }
        ValueExpression vb = this.getValueExpression("vspace");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setVspace(int newVspace) {
        this.vspace = newVspace;
        this.vspaceSet = true;
    }

    public int getWidth() {
        if (this.widthSet) {
            return this.width;
        }
        ValueExpression vb = this.getValueExpression("width");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
        this.widthSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.align = (String)values[1];
        this.alt = (String)values[2];
        this.border = (Integer)values[3];
        this.borderSet = (Boolean)values[4];
        this.height = (Integer)values[5];
        this.heightSet = (Boolean)values[6];
        this.hspace = (Integer)values[7];
        this.hspaceSet = (Boolean)values[8];
        this.icon = (String)values[9];
        this.imageURL = (String)values[10];
        this.textPosition = (String)values[11];
        this.visible = (Boolean)values[12];
        this.visibleSet = (Boolean)values[13];
        this.vspace = (Integer)values[14];
        this.vspaceSet = (Boolean)values[15];
        this.width = (Integer)values[16];
        this.widthSet = (Boolean)values[17];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.align, this.alt, this.border, this.borderSet ? Boolean.TRUE : Boolean.FALSE, this.height, this.heightSet ? Boolean.TRUE : Boolean.FALSE, this.hspace, this.hspaceSet ? Boolean.TRUE : Boolean.FALSE, this.icon, this.imageURL, this.textPosition, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE, this.vspace, this.vspaceSet ? Boolean.TRUE : Boolean.FALSE, this.width, this.widthSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

