/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import jakarta.faces.FactoryFinder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.Beans;

public final class ComponentUtilities {
    private static final String USCORE = "_";

    private ComponentUtilities() {
    }

    public static void putPrivateFacet(UIComponent parent, String facetName, UIComponent facet) {
        if (parent == null || facet == null || facetName == null) {
            return;
        }
        parent.getFacets().put(ComponentUtilities.createPrivateFacetName(facetName), facet);
    }

    public static void removePrivateFacet(UIComponent parent, String facetName) {
        if (parent == null || facetName == null) {
            return;
        }
        parent.getFacets().remove(ComponentUtilities.createPrivateFacetName(facetName));
    }

    public static UIComponent getPrivateFacet(UIComponent parent, String facetName, boolean matchId) {
        if (parent == null || facetName == null) {
            return null;
        }
        String pfacetName = ComponentUtilities.createPrivateFacetName(facetName);
        UIComponent facet = (UIComponent)parent.getFacets().get(pfacetName);
        if (facet == null || !matchId) {
            return facet;
        }
        String id = ComponentUtilities.createPrivateFacetId(parent, facetName);
        if (!id.equals(facet.getId())) {
            parent.getFacets().remove(pfacetName);
            return null;
        }
        return facet;
    }

    public static String createPrivateFacetName(String facetName) {
        return USCORE.concat(facetName);
    }

    public static String createPrivateFacetId(UIComponent parent, String facetName) {
        String pfacetName = ComponentUtilities.createPrivateFacetName(facetName);
        String id = parent.getId();
        if (id != null) {
            pfacetName = id.concat(pfacetName);
        }
        return pfacetName;
    }

    public static UIComponent getChild(UIComponent parent, String id) {
        return ComponentUtilities.findChild(parent, id, id);
    }

    public static UIComponent findChild(UIComponent parent, String id, String facetName) {
        UIComponent child2;
        if (parent == null) {
            return null;
        }
        if (facetName != null && (child2 = (UIComponent)parent.getFacets().get(facetName)) != null) {
            return child2;
        }
        if (id != null) {
            for (UIComponent child2 : parent.getChildren()) {
                if (!id.equals(child2.getId())) continue;
                return child2;
            }
        }
        return null;
    }

    public static UIComponent getForm(FacesContext context, UIComponent component) {
        if (component != null) {
            if (component instanceof UIForm) {
                return component;
            }
            UIComponent form = component;
            do {
                if ((form = form.getParent()) == null || !(form instanceof UIForm)) continue;
                return form;
            } while (form != null);
        }
        return null;
    }

    public static String getFormName(FacesContext context, UIComponent component) {
        UIComponent form = ComponentUtilities.getForm(context, component);
        if (form != null) {
            return form.getClientId(context);
        }
        return null;
    }

    public static String getBase(FacesContext context) {
        return ComponentUtilities.getContext(context) + context.getViewRoot().getViewId();
    }

    public static String getContext(FacesContext context) {
        if (Beans.isDesignTime()) {
            return "http://localhost:18080/myapp";
        }
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        StringBuilder sb = new StringBuilder(request.getScheme());
        sb.append("://");
        sb.append(request.getServerName());
        if (!("http".equals(request.getScheme()) && 80 == request.getServerPort() || "https".equals(request.getScheme()) && 443 == request.getServerPort())) {
            sb.append(":").append(request.getServerPort());
        }
        sb.append(request.getContextPath());
        return sb.toString();
    }

    public static String getActionURL(FacesContext context, String url) {
        return context.getApplication().getViewHandler().getActionURL(context, url);
    }

    public static void addPhaseListener(PhaseListener phaseListener) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.addPhaseListener(phaseListener);
    }

    public static void removePhaseListener(PhaseListener phaseListener) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.removePhaseListener(phaseListener);
    }
}

