/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import jakarta.mail.Session;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MailSessionFactory
implements ObjectFactory {
    protected static final String factoryType = "jakarta.mail.Session";

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable<?, ?> env) throws Exception {
        Reference ref = (Reference)refObj;
        if (!ref.getClassName().equals(factoryType)) {
            return null;
        }
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", "localhost");
        Enumeration<RefAddr> attrs = ref.getAll();
        while (attrs.hasMoreElements()) {
            RefAddr attr = attrs.nextElement();
            if ("factory".equals(attr.getType())) continue;
            props.put(attr.getType(), attr.getContent());
        }
        return Session.getInstance((Properties)props, null);
    }
}

