/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer.cfg;

import com.sun.enterprise.deployment.types.ConcurrencyContextType;
import com.sun.enterprise.deployment.types.CustomContextType;
import com.sun.enterprise.deployment.types.StandardContextType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class CfgParser {
    private CfgParser() {
    }

    static Set<ConcurrencyContextType> parseContextInfo(String contextInfo, String contextInfoEnabled) {
        if (contextInfo == null || !Boolean.TRUE.toString().equalsIgnoreCase(contextInfoEnabled)) {
            return Set.of(StandardContextType.values());
        }
        List<String> strings = Arrays.asList(contextInfo.split(","));
        return CfgParser.standardize(strings);
    }

    public static Set<ConcurrencyContextType> standardize(Iterable<String> contexts) {
        HashSet<ConcurrencyContextType> result = new HashSet<ConcurrencyContextType>();
        for (String input : contexts) {
            StandardContextType contextType;
            String context = input.trim();
            if (context.isEmpty()) continue;
            if ("Transaction".equalsIgnoreCase(context)) {
                result.add((ConcurrencyContextType)StandardContextType.WorkArea);
            }
            if ("Application".equals(context)) {
                result.add((ConcurrencyContextType)StandardContextType.Classloader);
                result.add((ConcurrencyContextType)StandardContextType.JNDI);
            }
            result.add((ConcurrencyContextType)((contextType = StandardContextType.parse((String)context)) == null ? new CustomContextType(context) : contextType));
        }
        return result;
    }

    static int parseInt(String strValue, int defaultValue) {
        if (strValue != null) {
            try {
                return Integer.parseInt(strValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    static long parseLong(String strValue, long defaultValue) {
        if (strValue != null) {
            try {
                return Long.parseLong(strValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

