/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.validator;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;

public final class MethodExprValidator
implements Validator,
StateHolder {
    private MethodExpression methodExpression = null;
    private boolean transientValue = false;

    public MethodExprValidator() {
    }

    public MethodExprValidator(MethodExpression newMethodExpression) {
        this.methodExpression = newMethodExpression;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            try {
                ELContext elContext = context.getELContext();
                this.methodExpression.invoke(elContext, new Object[]{context, component, value});
            }
            catch (ELException ee) {
                Throwable e = ee.getCause();
                if (e instanceof ValidatorException) {
                    throw (ValidatorException)e;
                }
                FacesMessage message = new FacesMessage(ee.getMessage());
                throw new ValidatorException(message, ee.getCause());
            }
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.methodExpression};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.methodExpression = (MethodExpression)values[0];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientValue = newTransientValue;
    }

    public MethodExpression getMethodExpression() {
        return this.methodExpression;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof MethodExprValidator)) {
            return false;
        }
        MethodExprValidator other = (MethodExprValidator)otherObject;
        MethodExpression otherMe = other.getMethodExpression();
        return this.methodExpression.equals((Object)otherMe);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash;
        if (this.methodExpression != null) {
            hash += this.methodExpression.hashCode();
        }
        return hash;
    }
}

