/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPAVersion;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.ParentExpression;
import org.eclipse.persistence.jpa.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;

public final class JPQLExpression
extends AbstractExpression
implements ParentExpression {
    private JPQLGrammar jpqlGrammar;
    private String queryBNFId;
    private AbstractExpression queryStatement;
    private boolean tolerant;
    private boolean idExpression = false;
    private boolean versionExpression = false;
    private AbstractExpression unknownEndingStatement;
    private boolean jakartaData = false;
    private boolean generateImplicitThisAlias = false;
    private List<IdentificationVariable> identificationVariablesWithoutAlias = new ArrayList<IdentificationVariable>();

    public JPQLExpression(CharSequence query, JPQLGrammar jpqlGrammar) {
        this(query, jpqlGrammar, false);
    }

    public JPQLExpression(CharSequence query, JPQLGrammar jpqlGrammar, boolean tolerant) {
        this(query, jpqlGrammar, "ql_statement", tolerant);
    }

    public JPQLExpression(CharSequence jpqlFragment, JPQLGrammar jpqlGrammar, String queryBNFId, boolean tolerant) {
        this(jpqlGrammar, queryBNFId, tolerant, false);
        this.parse(new WordParser(jpqlFragment), tolerant);
    }

    public JPQLExpression(CharSequence jpqlFragment, JPQLGrammar jpqlGrammar, String queryBNFId, boolean tolerant, boolean jakartaData) {
        this(jpqlGrammar, queryBNFId, tolerant, jakartaData);
        if (jakartaData) {
            jpqlFragment = this.preParse(jpqlFragment);
        }
        this.parse(new WordParser(jpqlFragment), tolerant);
        if (this.generateImplicitThisAlias && this.getIdentificationVariablesWithoutAlias() != null) {
            for (IdentificationVariable identificationVariable : this.getIdentificationVariablesWithoutAlias()) {
                identificationVariable.setThisVirtualIdentificationVariable(false);
            }
            this.identificationVariablesWithoutAlias = new ArrayList<IdentificationVariable>();
        }
    }

    private JPQLExpression(JPQLGrammar jpqlGrammar, String queryBNFId, boolean tolerant, boolean jakartaData) {
        super(null);
        this.queryBNFId = queryBNFId;
        this.tolerant = tolerant;
        this.jpqlGrammar = jpqlGrammar;
        this.jakartaData = jakartaData;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getQueryStatement().accept(visitor);
        this.getUnknownEndingStatement().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getQueryStatement());
        children.add(this.getUnknownEndingStatement());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.queryStatement != null) {
            children.add(this.queryStatement);
        }
        if (this.unknownEndingStatement != null) {
            children.add(this.unknownEndingStatement);
        }
    }

    public QueryPosition buildPosition(String actualQuery, int position) {
        position = ExpressionTools.repositionCursor(actualQuery, position, this.toActualText());
        QueryPosition queryPosition = new QueryPosition(position);
        this.populatePosition(queryPosition, position);
        return queryPosition;
    }

    public Expression getExpression(String actualQuery, int position) {
        QueryPosition queryPosition = this.buildPosition(actualQuery, position);
        return queryPosition.getExpression();
    }

    @Override
    public JPQLGrammar getGrammar() {
        return this.jpqlGrammar;
    }

    @Override
    public JPAVersion getJPAVersion() {
        return this.jpqlGrammar.getJPAVersion();
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF(this.queryBNFId);
    }

    @Override
    public boolean isGenerateImplicitThisAlias() {
        return this.generateImplicitThisAlias;
    }

    @Override
    public void setGenerateImplicitThisAlias(boolean generateImplicitThisAlias) {
        this.generateImplicitThisAlias = generateImplicitThisAlias;
    }

    @Override
    public boolean isParentExpression() {
        return true;
    }

    public boolean isJakartaData() {
        return this.jakartaData;
    }

    public Expression getQueryStatement() {
        if (this.queryStatement == null) {
            this.queryStatement = this.buildNullExpression();
        }
        return this.queryStatement;
    }

    public Expression getUnknownEndingStatement() {
        if (this.unknownEndingStatement == null) {
            this.unknownEndingStatement = this.buildNullExpression();
        }
        return this.unknownEndingStatement;
    }

    @Override
    public List<IdentificationVariable> getIdentificationVariablesWithoutAlias() {
        return this.identificationVariablesWithoutAlias;
    }

    public boolean hasQueryStatement() {
        return this.queryStatement != null && !this.queryStatement.isNull();
    }

    public boolean hasUnknownEndingStatement() {
        return this.unknownEndingStatement != null && !this.unknownEndingStatement.isNull();
    }

    public boolean hasIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(boolean idExpression) {
        this.idExpression = idExpression;
    }

    public boolean hasVersionExpression() {
        return this.versionExpression;
    }

    public void setVersionExpression(boolean versionExpression) {
        this.versionExpression = versionExpression;
    }

    @Override
    protected boolean isTolerant() {
        return this.tolerant;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        wordParser.skipLeadingWhitespace();
        if (tolerant || this.queryBNFId != "ql_statement") {
            this.queryStatement = this.queryBNFId == "ql_statement" ? this.parseUsingExpressionFactory(wordParser, this.queryBNFId, tolerant) : this.parse(wordParser, this.queryBNFId, tolerant);
            int count = wordParser.skipLeadingWhitespace();
            if (this.queryStatement == null || !wordParser.isTail()) {
                wordParser.moveBackward(count);
                this.unknownEndingStatement = this.buildUnknownExpression(wordParser.substring());
            } else if (!wordParser.isTail() || tolerant && count > 0) {
                this.unknownEndingStatement = this.buildUnknownExpression(" ");
            } else if (this.queryStatement.isUnknown()) {
                this.unknownEndingStatement = this.buildUnknownExpression(this.queryStatement.toParsedText());
                this.queryStatement = null;
            }
        } else {
            switch (wordParser.character()) {
                case 'D': 
                case 'd': {
                    this.queryStatement = new DeleteStatement(this);
                    break;
                }
                case 'U': 
                case 'u': {
                    this.queryStatement = new UpdateStatement(this);
                    break;
                }
                case 'S': 
                case 's': {
                    this.queryStatement = new SelectStatement(this);
                }
            }
            if (this.queryStatement != null) {
                this.queryStatement.parse(wordParser, tolerant);
            } else {
                this.queryStatement = this.parse(wordParser, this.queryBNFId, tolerant);
            }
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.queryStatement != null) {
            this.queryStatement.toParsedText(writer, actual);
        }
        if (this.unknownEndingStatement != null) {
            this.unknownEndingStatement.toParsedText(writer, actual);
        }
    }

    private CharSequence preParse(CharSequence jpqlFragment) {
        WordParser wordParser = new WordParser(jpqlFragment);
        wordParser.skipLeadingWhitespace();
        if ("FROM".equalsIgnoreCase(wordParser.word())) {
            return "SELECT this " + String.valueOf(jpqlFragment);
        }
        return jpqlFragment;
    }
}

