/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools;

import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.tools.AbstractRefactoringTool;
import org.eclipse.persistence.jpa.jpql.tools.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.tools.model.IJPQLQueryBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.IJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractSchemaNameStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CollectionValuedPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ConstructorExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.EntityTypeLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.JPQLQueryStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.OrderByItemStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ResultVariableStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SelectStatementStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateFieldPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.TreatExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;

public abstract class RefactoringTool
extends AbstractRefactoringTool {
    private IJPQLQueryBuilder jpqlQueryBuilder;
    private IJPQLQueryFormatter jpqlQueryFormatter;
    private JPQLQueryStateObject stateObject;

    protected RefactoringTool(IManagedTypeProvider managedTypeProvider, IJPQLQueryBuilder jpqlQueryBuilder, CharSequence jpqlQuery) {
        this(managedTypeProvider, jpqlQueryBuilder, jpqlQuery, "ql_statement");
    }

    protected RefactoringTool(IManagedTypeProvider managedTypeProvider, IJPQLQueryBuilder jpqlQueryBuilder, CharSequence jpqlFragment, String jpqlQueryBNFId) {
        super(jpqlFragment, managedTypeProvider, jpqlQueryBNFId);
        this.jpqlQueryBuilder = jpqlQueryBuilder;
    }

    protected ClassNameRenamer buildClassNameRenamer(String oldClassName, String newClassName) {
        return new ClassNameRenamer(oldClassName, newClassName);
    }

    protected EntityNameRenamer buildEntityNameRenamer(String oldEntityName, String newEntityName) {
        return new EntityNameRenamer(oldEntityName, newEntityName);
    }

    protected EnumConstantRenamer buildEnumConstantRenamer(String oldClassName, String newClassName) {
        return new EnumConstantRenamer(this.getManagedTypeProvider(), oldClassName, newClassName);
    }

    protected FieldNameRenamer buildFieldNameRenamer(String typeName, String oldFieldName, String newFieldName) {
        return new FieldNameRenamer(this.getManagedTypeProvider(), typeName, oldFieldName, newFieldName);
    }

    protected abstract IJPQLQueryFormatter buildFormatter();

    protected abstract JPQLQueryContext buildJPQLQueryContext();

    protected ResultVariableNameRenamer buildResultVariableNameRenamer(String oldVariableName, String newVariableName) {
        return new ResultVariableNameRenamer(oldVariableName, newVariableName);
    }

    protected JPQLQueryStateObject buildStateObject() {
        return this.jpqlQueryBuilder.buildStateObject(this.getManagedTypeProvider(), this.getJPQLFragment(), this.getJPQLQueryBNFId(), this.isTolerant());
    }

    protected VariableNameRenamer buildVariableNameRenamer(String oldVariableName, String newVariableName) {
        return new VariableNameRenamer(oldVariableName, newVariableName);
    }

    public IJPQLQueryFormatter getFormatter() {
        if (this.jpqlQueryFormatter == null) {
            this.jpqlQueryFormatter = this.buildFormatter();
        }
        return this.jpqlQueryFormatter;
    }

    public JPQLGrammar getGrammar() {
        return this.jpqlQueryBuilder.getGrammar();
    }

    public IJPQLQueryBuilder getJPQLQueryBuilder() {
        return this.jpqlQueryBuilder;
    }

    public JPQLQueryStateObject getStateObject() {
        if (this.stateObject == null) {
            this.stateObject = this.buildStateObject();
        }
        return this.stateObject;
    }

    public void renameClassName(String oldClassName, String newClassName) {
        ClassNameRenamer renamer = this.buildClassNameRenamer(oldClassName, newClassName);
        this.getStateObject().accept(renamer);
    }

    public void renameEntityName(String oldEntityName, String newEntityName) {
        EntityNameRenamer renamer = this.buildEntityNameRenamer(oldEntityName, newEntityName);
        this.getStateObject().accept(renamer);
    }

    public void renameEnumConstant(String oldEnumConstant, String newEnumConstant) {
        EnumConstantRenamer renamer = this.buildEnumConstantRenamer(oldEnumConstant, newEnumConstant);
        this.getStateObject().accept(renamer);
    }

    public void renameField(Class<?> type, String oldFieldName, String newFieldName) {
        this.renameField(type.getName(), oldFieldName, newFieldName);
    }

    public void renameField(IType type, String oldFieldName, String newFieldName) {
        this.renameField(type.getName(), oldFieldName, newFieldName);
    }

    public void renameField(String typeName, String oldFieldName, String newFieldName) {
        FieldNameRenamer renamer = this.buildFieldNameRenamer(typeName, oldFieldName, newFieldName);
        this.getStateObject().accept(renamer);
    }

    public void renameResultVariable(String oldVariableName, String newVariableName) {
        ResultVariableNameRenamer renamer = this.buildResultVariableNameRenamer(oldVariableName, newVariableName);
        this.getStateObject().accept(renamer);
    }

    public void renameVariable(String oldVariableName, String newVariableName) {
        VariableNameRenamer renamer = this.buildVariableNameRenamer(oldVariableName, newVariableName);
        this.getStateObject().accept(renamer);
    }

    public void setFormatter(IJPQLQueryFormatter jpqlQueryFormatter) {
        this.jpqlQueryFormatter = jpqlQueryFormatter;
    }

    @Override
    public String toActualText() {
        return this.getFormatter().toString(this.getStateObject());
    }

    protected static class ClassNameRenamer
    extends AbstractTraverseChildrenVisitor {
        protected StateObjectUpdater<ConstructorExpressionStateObject> constructorUpdater;
        protected final String newClassName;
        protected final String oldClassName;
        protected StateObjectUpdater<StateFieldPathExpressionStateObject> pathExpressionUpdater;

        public ClassNameRenamer(String oldClassName, String newClassName) {
            this.oldClassName = oldClassName;
            this.newClassName = newClassName;
        }

        protected StateObjectUpdater<ConstructorExpressionStateObject> buildConstructorUpdater() {
            return new StateObjectUpdater<ConstructorExpressionStateObject>(){

                @Override
                public void update(ConstructorExpressionStateObject stateObject, CharSequence newValue) {
                    stateObject.setClassName(newValue);
                }
            };
        }

        protected StateObjectUpdater<StateFieldPathExpressionStateObject> buildPathExpressionStateObjectUpdater() {
            return new StateObjectUpdater<StateFieldPathExpressionStateObject>(){

                @Override
                public void update(StateFieldPathExpressionStateObject stateObject, CharSequence newValue) {
                    stateObject.setPath(newValue);
                }
            };
        }

        protected StateObjectUpdater<ConstructorExpressionStateObject> constructorUpdater() {
            if (this.constructorUpdater == null) {
                this.constructorUpdater = this.buildConstructorUpdater();
            }
            return this.constructorUpdater;
        }

        protected StateObjectUpdater<StateFieldPathExpressionStateObject> pathExpressionUpdater() {
            if (this.pathExpressionUpdater == null) {
                this.pathExpressionUpdater = this.buildPathExpressionStateObjectUpdater();
            }
            return this.pathExpressionUpdater;
        }

        @Override
        public void visit(ConstructorExpressionStateObject stateObject) {
            this.visit(stateObject, stateObject.getClassName(), this.constructorUpdater());
        }

        @Override
        public void visit(StateFieldPathExpressionStateObject stateObject) {
            this.visit(stateObject, stateObject.getPath(), this.pathExpressionUpdater());
        }

        protected <T extends StateObject> void visit(T stateObject, String value, StateObjectUpdater<T> updater) {
            if (this.oldClassName.equals(value)) {
                updater.update(stateObject, this.newClassName);
            } else {
                int index = value.lastIndexOf(46);
                while (index > -1) {
                    String fragment = value.substring(0, index);
                    if (this.oldClassName.equals(fragment)) {
                        StringBuilder newValue = new StringBuilder(this.newClassName);
                        newValue.append('.');
                        if (index + 1 < value.length()) {
                            newValue.append(value.substring(index + 1));
                        }
                        updater.update(stateObject, newValue);
                        break;
                    }
                    if (fragment.length() < this.oldClassName.length()) break;
                    index = value.lastIndexOf(46, index - 1);
                }
            }
        }
    }

    protected static class EntityNameRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final String newEntityName;
        protected final String oldEntityName;

        public EntityNameRenamer(String oldEntityName, String newEntityName) {
            this.oldEntityName = oldEntityName;
            this.newEntityName = newEntityName;
        }

        @Override
        public void visit(AbstractSchemaNameStateObject stateObject) {
            if (this.oldEntityName.equals(stateObject.getText())) {
                stateObject.setText(this.newEntityName);
            }
        }

        @Override
        public void visit(EntityTypeLiteralStateObject stateObject) {
            if (this.oldEntityName.equals(stateObject.getText())) {
                stateObject.setText(this.newEntityName);
            }
        }

        @Override
        public void visit(IdentificationVariableStateObject stateObject) {
            if (this.oldEntityName.equals(stateObject.getText())) {
                stateObject.setText(this.newEntityName);
            }
        }

        @Override
        public void visit(TreatExpressionStateObject stateObject) {
            if (this.oldEntityName.equals(stateObject.getEntityTypeName())) {
                stateObject.setEntityTypeName(this.newEntityName);
            }
        }
    }

    protected static class EnumConstantRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final IManagedTypeProvider managedTypeProvider;
        protected final String newEnumConstant;
        protected final String oldEnumConstant;

        public EnumConstantRenamer(IManagedTypeProvider managedTypeProvider, String oldEnumConstant, String newEnumConstant) {
            this.oldEnumConstant = oldEnumConstant;
            this.newEnumConstant = newEnumConstant;
            this.managedTypeProvider = managedTypeProvider;
        }

        protected void renameEnumConstant(AbstractPathExpressionStateObject stateObject) {
            IType type;
            String path = stateObject.toString();
            if (path.equals(this.oldEnumConstant) && (type = this.managedTypeProvider.getTypeRepository().getEnumType(path)) != null) {
                stateObject.setPath(this.newEnumConstant);
            }
        }

        @Override
        public void visit(CollectionValuedPathExpressionStateObject stateObject) {
            this.renameEnumConstant(stateObject);
        }

        @Override
        public void visit(StateFieldPathExpressionStateObject stateObject) {
            this.renameEnumConstant(stateObject);
        }
    }

    protected static class FieldNameRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final IManagedTypeProvider managedTypeProvider;
        protected final String newFieldName;
        protected final String oldFieldName;
        protected final String typeName;

        public FieldNameRenamer(IManagedTypeProvider managedTypeProvider, String typeName, String oldFieldName, String newFieldName) {
            this.typeName = typeName;
            this.oldFieldName = oldFieldName;
            this.newFieldName = newFieldName;
            this.managedTypeProvider = managedTypeProvider;
        }

        protected void rename(AbstractPathExpressionStateObject stateObject) {
            IMapping mapping;
            int count = stateObject.itemsSize();
            for (int index = 1; index < count && (mapping = stateObject.getMapping(index)) != null; ++index) {
                String parentTypeName;
                if (!mapping.getName().equals(this.oldFieldName) || !(parentTypeName = mapping.getParent().getType().getName()).equals(this.typeName)) continue;
                stateObject.setPath(index, this.newFieldName);
                break;
            }
        }

        @Override
        public void visit(CollectionValuedPathExpressionStateObject stateObject) {
            this.rename(stateObject);
        }

        @Override
        public void visit(StateFieldPathExpressionStateObject stateObject) {
            this.rename(stateObject);
        }
    }

    protected static class ResultVariableNameRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final String newVariableName;
        protected final String oldVariableName;
        protected boolean renameIdentificationVariable;

        public ResultVariableNameRenamer(String oldVariableName, String newVariableName) {
            this.oldVariableName = oldVariableName;
            this.newVariableName = newVariableName;
        }

        @Override
        public void visit(IdentificationVariableStateObject stateObject) {
            if (this.renameIdentificationVariable && this.oldVariableName.equalsIgnoreCase(stateObject.getText())) {
                stateObject.setText(this.newVariableName);
            }
        }

        @Override
        public void visit(JPQLQueryStateObject stateObject) {
            if (stateObject.hasQueryStatement()) {
                stateObject.getQueryStatement().accept(this);
            }
        }

        @Override
        public void visit(OrderByItemStateObject stateObject) {
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
            }
        }

        @Override
        public void visit(ResultVariableStateObject stateObject) {
            if (this.oldVariableName.equalsIgnoreCase(stateObject.getResultVariable())) {
                stateObject.setResultVariable(this.newVariableName);
            }
        }

        @Override
        public void visit(SelectStatementStateObject stateObject) {
            stateObject.getSelectClause().accept(this);
            if (stateObject.hasOrderByClause()) {
                this.renameIdentificationVariable = true;
                try {
                    stateObject.getOrderByClause().accept(this);
                }
                finally {
                    this.renameIdentificationVariable = false;
                }
            }
        }
    }

    protected static class VariableNameRenamer
    extends AbstractTraverseChildrenVisitor {
        protected final String newVariableName;
        protected final String oldVariableName;

        public VariableNameRenamer(String oldVariableName, String newVariableName) {
            this.oldVariableName = oldVariableName;
            this.newVariableName = newVariableName;
        }

        @Override
        public void visit(CollectionValuedPathExpressionStateObject stateObject) {
            stateObject.getIdentificationVariable();
            super.visit(stateObject);
        }

        @Override
        public void visit(IdentificationVariableStateObject stateObject) {
            if (this.oldVariableName.equalsIgnoreCase(stateObject.getText())) {
                stateObject.setText(this.newVariableName);
            }
        }

        @Override
        public void visit(StateFieldPathExpressionStateObject stateObject) {
            stateObject.getIdentificationVariable();
            super.visit(stateObject);
        }
    }

    protected static interface StateObjectUpdater<T extends StateObject> {
        public void update(T var1, CharSequence var2);
    }
}

