/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.engine;

import jakarta.inject.Inject;
import jakarta.mvc.Models;
import jakarta.mvc.engine.ViewEngineContext;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.krazo.engine.ViewEngineBase;

public abstract class ServletViewEngine
extends ViewEngineBase {
    @Inject
    protected ServletContext servletContext;

    protected void forwardRequest(final ViewEngineContext context, String ... extensions) throws ServletException, IOException {
        RequestDispatcher rd = null;
        Object request = (HttpServletRequest)context.getRequest(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)context.getResponse(HttpServletResponse.class);
        Models models = context.getModels();
        for (String name : models) {
            request.setAttribute(name, models.get(name));
        }
        for (Map.Entry e : this.servletContext.getServletRegistrations().entrySet()) {
            Collection mappings = ((ServletRegistration)e.getValue()).getMappings();
            if (mappings == null || !mappings.containsAll(Arrays.asList(extensions))) continue;
            rd = this.servletContext.getNamedDispatcher((String)e.getKey());
            request = new HttpServletRequestWrapper((HttpServletRequest)context.getRequest(HttpServletRequest.class)){

                public String getRequestURI() {
                    return ServletViewEngine.this.resolveView(context);
                }

                public String getServletPath() {
                    return ServletViewEngine.this.resolveView(context);
                }

                public String getPathInfo() {
                    return null;
                }

                public StringBuffer getRequestURL() {
                    return new StringBuffer(this.getRequestURI());
                }
            };
            break;
        }
        if (rd == null) {
            rd = this.servletContext.getRequestDispatcher(this.resolveView(context));
        }
        rd.forward((ServletRequest)new HttpServletRequestWrapper(request), (ServletResponse)new HttpServletResponseWrapper(response));
    }
}

