/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJAnnotationArray;
import org.jboss.jdeparser.JAnnotation;
import org.jboss.jdeparser.JAnnotationArray;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;
import org.jboss.jdeparser.Writable;

class ImplJAnnotation
implements JAnnotation,
Writable {
    private final JType type;
    private LinkedHashMap<String, Writable> properties;

    ImplJAnnotation(JType type) {
        this.type = type;
    }

    @Override
    public JAnnotation value(JExpr expr) {
        return this.value("value", expr);
    }

    @Override
    public JAnnotation value(String literal) {
        return this.value(JExprs.str(literal));
    }

    @Override
    public JAnnotation annotationValue(String type) {
        return this.annotationValue(JTypes.typeNamed(type));
    }

    @Override
    public JAnnotation annotationValue(JType type) {
        return this.annotationValue("value", type);
    }

    @Override
    public JAnnotation annotationValue(Class<? extends Annotation> type) {
        return this.annotationValue(JTypes.typeOf(type));
    }

    @Override
    public JAnnotationArray annotationArrayValue(String type) {
        return this.annotationArrayValue(JTypes.typeNamed(type));
    }

    @Override
    public JAnnotationArray annotationArrayValue(JType type) {
        return this.annotationArrayValue("value", type);
    }

    @Override
    public JAnnotationArray annotationArrayValue(Class<? extends Annotation> type) {
        return this.annotationArrayValue(JTypes.typeOf(type));
    }

    @Override
    public JAnnotation value(String name, String literal) {
        return this.value(name, JExprs.str(literal));
    }

    @Override
    public JAnnotation value(String name, JExpr expr) {
        LinkedHashMap<String, Writable> properties = this.properties;
        if (properties == null) {
            properties = this.properties = new LinkedHashMap();
        }
        properties.put(name, (AbstractJExpr)expr);
        return this;
    }

    @Override
    public JAnnotation annotationValue(String name, String type) {
        return this.annotationValue(name, JTypes.typeNamed(type));
    }

    @Override
    public JAnnotation annotationValue(String name, JType type) {
        LinkedHashMap<String, Writable> properties = this.properties;
        if (properties == null) {
            properties = this.properties = new LinkedHashMap();
        }
        ImplJAnnotation annotation = new ImplJAnnotation(type);
        properties.put(name, annotation);
        return annotation;
    }

    @Override
    public JAnnotation annotationValue(String name, Class<? extends Annotation> type) {
        return this.annotationValue(name, JTypes.typeOf(type));
    }

    @Override
    public JAnnotationArray annotationArrayValue(String name, String type) {
        return this.annotationArrayValue(name, JTypes.typeNamed(type));
    }

    @Override
    public JAnnotationArray annotationArrayValue(String name, JType type) {
        LinkedHashMap<String, Writable> properties = this.properties;
        if (properties == null) {
            properties = this.properties = new LinkedHashMap();
        }
        ImplJAnnotationArray array = new ImplJAnnotationArray(type);
        properties.put(name, array);
        return array;
    }

    @Override
    public JAnnotationArray annotationArrayValue(String name, Class<? extends Annotation> type) {
        return this.annotationArrayValue(name, JTypes.typeOf(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(SourceFileWriter writer) throws IOException {
        writer.write(Tokens$.PUNCT.AT);
        writer.write(this.type);
        LinkedHashMap<String, Writable> properties = this.properties;
        if (properties != null && !properties.isEmpty()) {
            writer.write(Tokens$.PUNCT.PAREN.OPEN);
            writer.pushIndent(FormatPreferences.Indentation.LINE);
            try {
                writer.write(FormatPreferences.Space.WITHIN_PAREN_ANNOTATION);
                if (properties.size() == 1 && properties.containsKey("value")) {
                    properties.get("value").write(writer);
                } else {
                    Iterator<Map.Entry<String, Writable>> iterator = properties.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Writable> entry = iterator.next();
                        writer.writeEscapedWord(entry.getKey());
                        writer.write(FormatPreferences.Space.AROUND_ASSIGN);
                        writer.write(Tokens$.PUNCT.BINOP.ASSIGN);
                        writer.write(FormatPreferences.Space.AROUND_ASSIGN);
                        entry.getValue().write(writer);
                        if (!iterator.hasNext()) continue;
                        writer.write(FormatPreferences.Space.BEFORE_COMMA);
                        writer.write(Tokens$.PUNCT.COMMA);
                        writer.write(FormatPreferences.Space.AFTER_COMMA);
                    }
                }
            }
            finally {
                writer.popIndent(FormatPreferences.Indentation.LINE);
            }
            writer.write(FormatPreferences.Space.WITHIN_PAREN_ANNOTATION);
            writer.write(Tokens$.PUNCT.PAREN.CLOSE);
        }
    }
}

