/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.exceptions.XMLMarshalException;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;

public class XMLValidator {
    public static final int NONVALIDATING = 0;
    public static final int SCHEMA_VALIDATION = 3;
    public static final int DTD_VALIDATION = 2;
    private XMLContext xmlContext;
    private XMLMarshaller marshaller;
    private ErrorHandler errorHandler;

    protected XMLValidator(XMLContext xmlContext) {
        this.xmlContext = xmlContext;
        this.marshaller = new XMLMarshaller(xmlContext);
    }

    public boolean validateRoot(Object rootObject) throws XMLMarshalException {
        if (rootObject == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        XMLDescriptor xmlDescriptor = (XMLDescriptor)this.xmlContext.getSession(rootObject).getDescriptor(rootObject);
        Document document = this.marshaller.objectToXML(rootObject, xmlDescriptor, false);
        if (xmlDescriptor.getSchemaReference() == null) {
            throw XMLMarshalException.schemaReferenceNotSet(xmlDescriptor.getJavaClassName());
        }
        return xmlDescriptor.getSchemaReference().isValid(document, this.getErrorHandler());
    }

    public boolean validate(Object object) throws XMLMarshalException {
        if (object == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            String name = ((XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object)).getDefaultRootElement();
            if (name == null) {
                String qualifiedName = object.getClass().getName();
                int idx = qualifiedName.lastIndexOf(46);
                name = qualifiedName.substring(idx + 1);
            }
            XMLDescriptor descriptor = (XMLDescriptor)this.marshaller.getDescriptor(object);
            Root root = new Root();
            root.setObject(object);
            root.setLocalName(name);
            XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            Document doc = xmlPlatform.createDocument();
            this.marshaller.marshal((Object)root, doc);
            return xmlPlatform.validate(doc.getDocumentElement(), descriptor, this.getErrorHandler());
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.validateException(e);
        }
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

