/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.commands.CLIUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-threadpool")
@PerLookup
@I18n(value="delete.threadpool")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteThreadpool
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteThreadpool.class);
    @Param(name="threadpool_id", primary=true)
    String threadpool_id;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Configs configs;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator habitat;
    private ThreadPools threadPools;
    @AccessRequired.To(value={"delete"})
    private ThreadPool pool;

    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.config = CLIUtil.updateConfigIfNeeded(this.config, this.target, this.habitat);
        this.threadPools = this.config.getThreadPools();
        if (!this.isThreadPoolExists(this.threadPools)) {
            report.setMessage(localStrings.getLocalString("delete.threadpool.notexists", "Thread Pool named {0} does not exist.", new Object[]{this.threadpool_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        this.pool = null;
        for (ThreadPool tp : this.config.getThreadPools().getThreadPool()) {
            if (!tp.getName().equals(this.threadpool_id)) continue;
            this.pool = tp;
        }
        List nwlsnrList = this.pool.findNetworkListeners();
        for (NetworkListener nwlsnr : nwlsnrList) {
            if (!this.pool.getName().equals(nwlsnr.getThreadPool())) continue;
            report.setMessage(localStrings.getLocalString("delete.threadpool.beingused", "{0} threadpool is being used in the network listener {1}", new Object[]{this.threadpool_id, nwlsnr.getName()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                public Object run(ThreadPools param) throws PropertyVetoException, TransactionFailure {
                    List poolList = param.getThreadPool();
                    for (ThreadPool pool : poolList) {
                        String currPoolId = pool.getName();
                        if (currPoolId == null || !currPoolId.equals(DeleteThreadpool.this.threadpool_id)) continue;
                        poolList.remove(pool);
                        break;
                    }
                    return poolList;
                }
            }, (ConfigBeanProxy)this.threadPools);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            String str = e.getMessage();
            report.setMessage(localStrings.getLocalString("delete.threadpool.failed", "Delete Thread Pool failed because of: ", new Object[]{str}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean isThreadPoolExists(ThreadPools threadPools) {
        for (ThreadPool pool : threadPools.getThreadPool()) {
            String currPoolId = pool.getName();
            if (currPoolId == null || !currPoolId.equals(this.threadpool_id)) continue;
            return true;
        }
        return false;
    }
}

